/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.host.rest;

import cn.com.yusys.yusp.registry.host.common.DashboardCmdPair;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.host.domain.ExtHostInfo;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.host.service.HostService;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HostResource {
    private final Logger log = LoggerFactory.getLogger(HostResource.class);
    @Autowired
    private HostService service;

    @GetMapping(value={"/api/host/infos"})
    public ResultDto<List<HostDomain>> loadHostList() {
        ResultDto<List<HostDomain>> resultDto = new ResultDto<List<HostDomain>>(this.service.getHosts());
        resultDto.setTotal(resultDto.getData().size());
        return resultDto;
    }

    @GetMapping(value={"/api/host/infos/{cluster}"})
    public ResultDto<List<HostDomain>> getHostListByBusinessDomain(@PathVariable String cluster) {
        ResultDto<List<HostDomain>> resultDto = new ResultDto<List<HostDomain>>(this.service.getHostsByCluster(cluster));
        resultDto.setTotal(resultDto.getData().size());
        return resultDto;
    }

    @GetMapping(value={"/api/host/extinfo"})
    public ResultDto<List<ExtHostInfo>> getExtHostInfo(String hostName) {
        this.log.debug("hostName:{}", (Object)hostName);
        return new ResultDto<List<ExtHostInfo>>(this.service.getExtHostInfo(hostName));
    }

    @PostMapping(value={"/api/host/addhost"})
    public ResultDto<HostDomain> addHostInfo(@RequestBody HostDomain host) {
        if (host.getBusinessDomains() == null) {
            host.setBusinessDomains(new ArrayList<String>());
        }
        ResultDto<HostDomain> result = new ResultDto<HostDomain>(host);
        result.setMessage(this.service.addHostInfo(host));
        LogUtil.info((Object)ModulNameConstant.HOST_INFO, "\u65b0\u589e\u4e3b\u673a[{}]->{}", host.getIp(), result.getMessage());
        return result;
    }

    @PostMapping(value={"/api/host/test"})
    public ResultDto<HostDomain> testConn(@RequestBody HostDomain host) {
        ResultDto<HostDomain> resultDto = new ResultDto<HostDomain>(host);
        resultDto.setMessage(this.service.testConn(host));
        LogUtil.info((Object)ModulNameConstant.HOST_INFO, "\u6d4b\u8bd5\u8fde\u63a5[{}]->{}", host.getIp(), resultDto.getMessage());
        return resultDto;
    }

    @GetMapping(value={"/api/host/cmd"})
    public ResultDto<DashboardCmdPair> runCmd(String hostName, String dir, String cmd) throws DashboardSessionException {
        LogUtil.info((Object)ModulNameConstant.HOST_INFO, "\u547d\u4ee4\u6267\u884c[{}]->{}", hostName, cmd);
        return new ResultDto<DashboardCmdPair>(this.service.runCmd(hostName, dir, cmd));
    }

    @PostMapping(value={"/api/host/delhost"})
    public ResultDto<HostDomain> delHostInfo(@RequestBody HostDomain host) {
        ResultDto<HostDomain> result = new ResultDto<HostDomain>(host);
        result.setMessage(this.service.delHostInfo(host));
        LogUtil.info((Object)ModulNameConstant.HOST_INFO, "\u5220\u9664\u4e3b\u673a[{}]->{}", host.getIp(), result.getMessage());
        return result;
    }
}

