/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.host.repository;

import cn.com.yusys.yusp.registry.host.common.DashboardCmdPair;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.domain.ExtHostInfo;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.domain.HostDomainList;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.host.ssh.cmd.SimpleCmd;
import cn.com.yusys.yusp.registry.host.ssh.common.ConnectionInfo;
import cn.com.yusys.yusp.registry.host.ssh.session.SimpleSshSession;
import cn.com.yusys.yusp.registry.host.ssh.session.SshSessionFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class HostRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(HostRepository.class);
    private SshSessionFactory factory;

    public HostRepository(ConfigFileConfiguration properties) {
        super(properties.getRegistryStore());
        this.loadFactory();
    }

    public HostDomainList getHostList() {
        HostDomainList hostList = (HostDomainList)this.getLoadObj();
        if (hostList == null) {
            hostList = new HostDomainList();
        }
        if (hostList.getHostDomains() == null) {
            hostList.setHostDomains(new ArrayList<HostDomain>());
        }
        for (HostDomain hostDomain : hostList.getHostDomains()) {
            if (hostDomain.getClusters() != null) continue;
            hostDomain.setClusters(new ArrayList<String>());
        }
        return hostList;
    }

    public List<HostDomain> getHostListByBusinessDomain(String businessDomain) {
        HostDomainList hostDomainList = (HostDomainList)this.getLoadObj();
        HostDomainList resultHostDomainList = new HostDomainList();
        ArrayList<HostDomain> temp = new ArrayList<HostDomain>();
        for (HostDomain hostDomain : hostDomainList.getHostDomains()) {
            if (hostDomain.getBusinessDomains() == null || hostDomain.getBusinessDomains().size() == 0) {
                temp.add(hostDomain);
                continue;
            }
            if (!hostDomain.getBusinessDomains().contains(businessDomain)) continue;
            temp.add(hostDomain);
        }
        resultHostDomainList.setHostDomains(temp);
        if (resultHostDomainList.getHostDomains() == null) {
            hostDomainList.setHostDomains(new ArrayList<HostDomain>());
        }
        return resultHostDomainList.getHostDomains();
    }

    public List<HostDomain> getHostListByCluster(String cluster) {
        HostDomainList hostDomainList = (HostDomainList)this.getLoadObj();
        HostDomainList resultHostDomainList = new HostDomainList();
        ArrayList<HostDomain> temp = new ArrayList<HostDomain>();
        for (HostDomain hostDomain : hostDomainList.getHostDomains()) {
            if (!hostDomain.getClusters().contains(cluster)) continue;
            temp.add(hostDomain);
        }
        resultHostDomainList.setHostDomains(temp);
        if (resultHostDomainList.getHostDomains() == null) {
            hostDomainList.setHostDomains(new ArrayList<HostDomain>());
        }
        return resultHostDomainList.getHostDomains();
    }

    public List<HostDomain> getHosts() {
        return this.getHostList().getHostDomains();
    }

    public HostDomain getHostByName(String hostName) {
        this.log.info("\u83b7\u53d6\u4e3b\u673a\u540d:{}\u7684\u4e3b\u673a\u4fe1\u606f", (Object)hostName);
        if (StringUtils.isEmpty((CharSequence)hostName)) {
            return new HostDomain();
        }
        HostDomain domain = null;
        List<HostDomain> hostDomains = this.getHosts();
        for (HostDomain hostDomain : hostDomains) {
            if (!StringUtils.equals((CharSequence)hostName, (CharSequence)hostDomain.getHostName())) continue;
            domain = hostDomain;
            break;
        }
        return domain;
    }

    public HostDomain getHostByIp(String ip) {
        this.log.info("\u83b7\u53d6ip:{}\u7684\u4e3b\u673a\u4fe1\u606f", (Object)ip);
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return new HostDomain();
        }
        HostDomain domain = null;
        List<HostDomain> hostDomains = this.getHosts();
        for (HostDomain hostDomain : hostDomains) {
            if (!StringUtils.equals((CharSequence)ip, (CharSequence)hostDomain.getIp())) continue;
            domain = hostDomain;
            break;
        }
        return domain;
    }

    public SshSessionFactory getFactory() {
        return this.factory;
    }

    public SimpleSshSession getSimpleSshSession(String hostName) throws DashboardSessionException {
        if (this.getFactory() == null) {
            throw new DashboardSessionException("\u4e3b\u673a\u8fde\u63a5\u5de5\u5382\u521d\u59cb\u5316\u5f02\u5e38!");
        }
        SimpleSshSession simpleSshSession = this.getFactory().getSession(this.getConnectionInfo(hostName));
        if (simpleSshSession == null) {
            throw new DashboardSessionException("\u5bf9\u5e94\u4e3b\u673a\u672a\u521d\u59cb\u5316\u8fde\u63a5\uff01");
        }
        return simpleSshSession;
    }

    public String goCmd(String hostName, String cmd) throws DashboardSessionException {
        SimpleSshSession session = null;
        String result = null;
        try {
            session = this.getSimpleSshSession(hostName);
            String string = result = session.goCmd(cmd);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DashboardCmdPair goCmd(String hostName, String dir, String cmd) throws DashboardFileException, DashboardSessionException {
        if (this.getFactory() == null) {
            throw new DashboardFileException("\u4f1a\u8bdd\u672a\u6b63\u5e38\u521d\u59cb\u5316!");
        }
        DashboardCmdPair pair = new DashboardCmdPair(dir, cmd);
        return this.getFactory().getSession(this.getConnectionInfo(hostName)).goCmd(pair);
    }

    public void upload(String hostName, File file, String target, boolean cover) throws DashboardSessionException, FileNotFoundException, JSchException, SftpException {
        SimpleSshSession session = null;
        try {
            session = this.getSimpleSshSession(hostName);
            session.upload(file, target, cover);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void upload(String hostName, InputStream stream, String fileName, String target, boolean cover) throws DashboardSessionException, FileNotFoundException, JSchException, SftpException {
        SimpleSshSession session = null;
        try {
            session = this.getSimpleSshSession(hostName);
            session.upload(stream, fileName, target, cover);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void remove(String hostName, String fileName, String target) throws DashboardSessionException, FileNotFoundException, JSchException, SftpException {
        SimpleSshSession session = null;
        try {
            session = this.getSimpleSshSession(hostName);
            session.remove(fileName, target);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<ChannelSftp.LsEntry> getFiles(String hostName, String path) throws DashboardSessionException, JSchException, SftpException {
        SimpleSshSession session = null;
        List<ChannelSftp.LsEntry> entrys = null;
        try {
            session = this.getSimpleSshSession(hostName);
            List<ChannelSftp.LsEntry> list = entrys = session.getFiles(path);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void downLoadFile(String hostName, String srcFile, String srcPath, File outfile) throws DashboardSessionException, JSchException, SftpException, IOException {
        SimpleSshSession session = null;
        try {
            session = this.getSimpleSshSession(hostName);
            session.downLoadFile(srcFile, srcPath, outfile);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadFactory() {
        this.factory = SshSessionFactory.getInstance();
    }

    public void updateFactory(HostDomain host) {
        ConnectionInfo info = new ConnectionInfo();
        info.setHostName(host.getHostName());
        info.setPassword(host.getPassword());
        info.setUri(host.getIp());
        info.setUserName(host.getUserName());
    }

    public ExtHostInfo getExtHostInfo(String hostName) throws DashboardParamException, DashboardSessionException {
        HostDomainList hostList = this.getHostList();
        for (HostDomain host : hostList.getHostDomains()) {
            if (!StringUtils.equals((CharSequence)host.getHostName(), (CharSequence)hostName)) continue;
            return this.collectInfo(host);
        }
        throw new DashboardParamException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e3b\u673a");
    }

    public ExtHostInfo collectInfo(HostDomain host) throws DashboardSessionException {
        SimpleSshSession session = this.getSimpleSshSession(host.getHostName());
        ExtHostInfo extInfo = new ExtHostInfo();
        extInfo.setName(host.getHostName());
        String hostState = "\u8fd0\u884c\u4e2d";
        try {
            session.connect();
            String hostKey = session.getPublicKey();
            extInfo.setHostKey(hostKey);
            if (host.getInstances() != null) {
                extInfo.setInstances(this.catProcessList(host.getInstances(), session));
            }
            extInfo.setHardwareInfos(this.catHostInfo(session));
        }
        catch (JSchException e) {
            hostState = "\u65e0\u6cd5\u8fde\u63a5";
            throw new DashboardSessionException("\u4e3b\u673a\u8fde\u63a5\u5931\u8d25!");
        }
        finally {
            if (Objects.nonNull(session)) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        extInfo.setHostState(hostState);
        return extInfo;
    }

    public Map<String, Integer> catProcessList(String instances, SimpleSshSession session) {
        String[] inss;
        HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
        for (String s : inss = instances.toString().split(",")) {
            integerMap.put(s, this.getProcessCount(session, s));
        }
        return integerMap;
    }

    public Map<String, String> catHostInfo(SimpleSshSession session) {
        HashMap<String, String> hards = new HashMap<String, String>();
        hards.put("cpu", this.getCpuUsage(session));
        hards.put("Mem", this.getMemoryUsage(session));
        return hards;
    }

    public int getProcessCount(SimpleSshSession session, String name) {
        String num = session.goCmd(SimpleCmd.catProcessCount(name)).trim();
        return StringUtils.isEmpty((CharSequence)num) ? 0 : Integer.parseInt(num);
    }

    private String getMemoryUsage(SimpleSshSession sshSession) {
        String[] totals = sshSession.goCmd("free -kt").split("\n")[3].split(" ");
        double[] rec = new double[2];
        int count = 0;
        for (String s : totals) {
            if (s.isEmpty()) continue;
            if (count >= 1) {
                rec[count - 1] = Double.parseDouble(s);
                if (count == 2) break;
            }
            ++count;
        }
        String usage = (int)(rec[1] / rec[0] * 100.0) + "%";
        this.log.info("\u5185\u5b58\u4f7f\u7528\u7387\uff1a{}", (Object)usage);
        return usage;
    }

    private String getCpuUsage(SimpleSshSession session) {
        String[] cpus = session.goCmd("vmstat").split("\n")[2].split(" ");
        ArrayList<String> cpuList = new ArrayList<String>();
        for (String s : cpus) {
            if (s.isEmpty()) continue;
            cpuList.add(s);
        }
        int usage = 100 - Integer.parseInt((String)cpuList.get(cpuList.size() - 3));
        this.log.info("cpu\u4f7f\u7528\u7387:{}", (Object)usage);
        return String.valueOf(usage);
    }

    public String addHostInfo(HostDomain host) {
        HostDomainList list = this.getHostList();
        boolean update = false;
        for (HostDomain hostDomain : list.getHostDomains()) {
            if (!hostDomain.getIp().equals(host.getIp())) continue;
            update = true;
            BeanUtils.copyProperties((Object)host, (Object)hostDomain);
        }
        if (!update) {
            list.getHostDomains().add(host);
        }
        String msg = "success";
        try {
            this.getAfo().writeObject(list);
            this.updateFactory(host);
        }
        catch (DashboardFileException e) {
            msg = e.getMessage();
            e.printStackTrace();
        }
        return msg;
    }

    @Override
    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(HostDomainList.class);
    }

    public String delHostInfo(HostDomain host) {
        HostDomainList list = this.getHostList();
        HostDomain removeDomain = null;
        String msg = "success";
        for (HostDomain hostDomain : list.getHostDomains()) {
            if (!hostDomain.getIp().equals(host.getIp())) continue;
            removeDomain = hostDomain;
        }
        if (removeDomain == null) {
            msg = "invalid obj,can not delete";
            return msg;
        }
        list.getHostDomains().remove(removeDomain);
        try {
            this.getAfo().writeObject(list);
            this.updateFactory(host);
        }
        catch (DashboardFileException e) {
            msg = e.getMessage();
            e.printStackTrace();
        }
        return msg;
    }

    public ConnectionInfo getConnectionInfo(String hostName) {
        HostDomainList hostList = (HostDomainList)this.getLoadObj();
        if (hostList != null && hostList.getHostDomains() != null) {
            for (HostDomain host : hostList.getHostDomains()) {
                if (!Objects.equals(hostName, host.getHostName())) continue;
                ConnectionInfo info = new ConnectionInfo();
                info.setHostName(host.getHostName());
                info.setPassword(host.getPassword());
                info.setUri(host.getIp());
                info.setUserName(host.getUserName());
                return info;
            }
        }
        return null;
    }

    public String goCmd(Session session, String cmd) {
        return new SimpleSshSession(session).goCmd(cmd);
    }
}

