/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.host.common;

import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.util.ByteUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractFileObject {
    private final File file;
    private final JavaType javaType;
    private ObjectMapper mapper;
    private static final Lock lock = new ReentrantLock();
    private int hash;
    private Object obj;

    public AbstractFileObject(String path, Class cl) {
        this(new File(path), cl);
    }

    public AbstractFileObject(File file, Class cl) {
        this(file, TypeFactory.defaultInstance().constructType((Type)cl));
    }

    public AbstractFileObject(File file, JavaType javaType) {
        this.javaType = javaType;
        this.file = file;
        this.mapper = this.configMapper();
        this.loadObject();
    }

    public int getHash() {
        return this.hash;
    }

    public File getFile() {
        return this.file;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public Object getObj() {
        return this.obj;
    }

    public String getJavaTypeName() {
        StringBuilder sb = new StringBuilder();
        ByteUtils.concat(sb, this.getJavaType());
        return ByteUtils.lowCase(sb).toString();
    }

    protected abstract ObjectMapper configMapper();

    public void loadObject() {
        Object o = this.loadOriginData();
        if (o != null) {
            this.hash = o.hashCode();
        }
        this.obj = this.convert(o);
    }

    public Object loadOriginData() {
        Object o = null;
        JsonNode root = this.getJsonRoot();
        JsonNode node = root.get(this.getJavaTypeName());
        try {
            if (node != null) {
                o = this.mapper.readValue(node.traverse(), Object.class);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode getJsonRoot() {
        JsonNode root = null;
        try {
            lock.lock();
            try {
                root = this.mapper.readTree(this.getFile());
            }
            catch (IOException e) {
                this.buildEmptyFile();
                try {
                    root = this.mapper.readTree(this.getFile());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            lock.unlock();
        }
        return root;
    }

    private void buildEmptyFile() {
        File file = this.getFile();
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists() || parent.isDirectory()) {
                parent.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.mapper.writeValue(this.getFile(), new HashMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object convert(Object o) {
        return this.mapper.convertValue(o, this.getJavaType());
    }

    public void writeObject(Object t) throws DashboardFileException {
        if (!this.checkType(t)) {
            throw new DashboardFileException("\u5199\u5165\u4e0d\u6b63\u786e\u7684\u5bf9\u8c61\u7c7b\u578b");
        }
        if (!this.checkHash()) {
            this.reload();
            throw new DashboardFileException("\u8be5\u6587\u4ef6\u5df2\u88ab\u4fee\u6539\uff01\u6b63\u5728\u91cd\u65b0\u8f7d\u5165");
        }
        this.write(t);
        this.reload();
    }

    private boolean checkType(Object o) {
        return this.getJavaType().getRawClass().isAssignableFrom(o.getClass());
    }

    private boolean checkHash() {
        return this.getHash() == (this.loadOriginData() != null ? this.loadOriginData().hashCode() : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Object o) {
        ObjectNode root = (ObjectNode)this.getJsonRoot();
        root.putPOJO(this.getJavaTypeName(), o);
        try {
            lock.lock();
            this.mapper.writeValue(this.getFile(), (Object)root);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupsFile() {
        File file = this.getFile();
        if (file.exists()) {
            String suffex = new SimpleDateFormat("yyyyMMddHHssmmSSS").format(new Date());
            lock.lock();
            try {
                Path targetPath = Paths.get(file.getPath() + "." + suffex, new String[0]);
                if (Files.exists(targetPath, new LinkOption[0])) {
                    return;
                }
                Files.copy(Paths.get(file.getPath(), new String[0]), Paths.get(file.getPath() + "." + suffex, new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void reload() {
        this.loadObject();
    }
}

