/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.RuleTradeDefineBo;
import cn.com.yusys.yusp.param.vo.RuleTradeDefineVo;
import cn.com.yusys.yusp.rule.dao.RuleTradeDefineDao;
import cn.com.yusys.yusp.rule.dao.RuleTradeElementDao;
import cn.com.yusys.yusp.rule.domain.entity.RuleTradeDefineEntity;
import cn.com.yusys.yusp.rule.service.RuleTradeDefineService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleTradeDefineServiceImpl
implements RuleTradeDefineService {
    private static final Logger logger = LoggerFactory.getLogger(RuleTradeDefineServiceImpl.class);
    @Autowired
    private RuleTradeDefineDao ruleTradeDefineMapper;
    @Autowired
    private RuleTradeElementDao ruleTradeElementMapper;

    @Override
    public int create(RuleTradeDefineBo ruleTradeDefineBo) throws Exception {
        this.beforeCheck(ruleTradeDefineBo);
        RuleTradeDefineEntity resp = this.ruleTradeDefineMapper.show(ruleTradeDefineBo.getTradeCode());
        if (resp != null) {
            throw new IcspException("500", "\u8be5\u4ea4\u6613\u4fe1\u606f\u5df2\u5b58\u5728!");
        }
        ruleTradeDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleTradeDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleTradeDefineEntity ruleTradeDefineEntity = new RuleTradeDefineEntity();
        BeanUtils.beanCopy((Object)ruleTradeDefineBo, (Object)ruleTradeDefineEntity);
        return this.ruleTradeDefineMapper.insert(ruleTradeDefineEntity);
    }

    @Override
    public int update(RuleTradeDefineBo ruleTradeDefineBo) throws Exception {
        this.beforeCheck(ruleTradeDefineBo);
        RuleTradeDefineEntity resp = this.ruleTradeDefineMapper.show(ruleTradeDefineBo.getTradeCode());
        if (resp == null) {
            throw new IcspException("500", "\u8be5\u4ea4\u6613\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        ruleTradeDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleTradeDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleTradeDefineEntity ruleTradeDefineEntity = new RuleTradeDefineEntity();
        BeanUtils.beanCopy((Object)ruleTradeDefineBo, (Object)ruleTradeDefineEntity);
        return this.ruleTradeDefineMapper.updateByPrimaryKey(ruleTradeDefineEntity);
    }

    private void beforeCheck(RuleTradeDefineBo ruleTradeDefineBo) {
        if (StringUtils.isEmpty((CharSequence)ruleTradeDefineBo.getTradeCode())) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)ruleTradeDefineBo.getTradeName())) {
            throw new IcspException("500", "\u4ea4\u6613\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)ruleTradeDefineBo.getChannelCode())) {
            throw new IcspException("500", "\u6e20\u9053\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public int delete(String tradeCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tradeCode)) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RuleTradeDefineEntity resp = this.ruleTradeDefineMapper.show(tradeCode);
        if (resp == null) {
            throw new IcspException("500", "\u8be5\u4ea4\u6613\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        this.ruleTradeElementMapper.deleteByTradeCode(tradeCode);
        return this.ruleTradeDefineMapper.deleteByPrimaryKey(tradeCode);
    }

    @Override
    public List<RuleTradeDefineVo> index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<RuleTradeDefineEntity> list = this.ruleTradeDefineMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleTradeDefineVo.class);
        PageHelper.clearPage();
        return voList;
    }

    @Override
    public List<RuleTradeDefineVo> list(QueryModel model) throws Exception {
        List<RuleTradeDefineEntity> list = this.ruleTradeDefineMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleTradeDefineVo.class);
        return voList;
    }

    @Override
    public RuleTradeDefineVo show(String tradeCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tradeCode)) {
            throw new IcspException("500", "\u4ea4\u6613\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RuleTradeDefineVo ruleTradeDefineVo = new RuleTradeDefineVo();
        BeanUtils.beanCopy((Object)this.ruleTradeDefineMapper.show(tradeCode), (Object)ruleTradeDefineVo);
        return ruleTradeDefineVo;
    }

    @Override
    public List<RuleTradeDefineVo> query(String queryKey) throws Exception {
        PageHelper.startPage((int)1, (int)20);
        List<RuleTradeDefineEntity> list = this.ruleTradeDefineMapper.query(queryKey);
        PageHelper.clearPage();
        List voList = (List)BeanUtils.beansCopy(list, RuleTradeDefineVo.class);
        return voList;
    }
}

