/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.service.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.param.bo.RuleRiskDefineBo;
import cn.com.yusys.yusp.param.vo.RuleRiskDefineVo;
import cn.com.yusys.yusp.rule.dao.RuleRiskDefineDao;
import cn.com.yusys.yusp.rule.domain.entity.RuleRiskDefineEntity;
import cn.com.yusys.yusp.rule.domain.query.RuleRiskDefineQuery;
import cn.com.yusys.yusp.rule.service.RuleRiskDefineService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={IcspException.class, Exception.class})
public class RuleRiskDefineServiceImpl
implements RuleRiskDefineService {
    private static final Logger logger = LoggerFactory.getLogger(RuleRiskDefineServiceImpl.class);
    @Autowired
    private RuleRiskDefineDao ruleRiskDefineMapper;

    @Override
    public int create(RuleRiskDefineBo ruleRiskDefineBo) {
        this.beforeCheck(ruleRiskDefineBo, "create");
        ruleRiskDefineBo.setRiskId(StringUtils.getUUID());
        ruleRiskDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleRiskDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleRiskDefineEntity ruleRiskDefineEntity = new RuleRiskDefineEntity();
        BeanUtils.beanCopy((Object)ruleRiskDefineBo, (Object)ruleRiskDefineEntity);
        return this.ruleRiskDefineMapper.insert(ruleRiskDefineEntity);
    }

    @Override
    public int update(RuleRiskDefineBo ruleRiskDefineBo) {
        this.beforeCheck(ruleRiskDefineBo, "update");
        ruleRiskDefineBo.setLastChgUser(SessionUtils.getUserId());
        ruleRiskDefineBo.setLastChgDt(DateUtils.formatDateTimeByDef());
        RuleRiskDefineEntity ruleRiskDefineEntity = new RuleRiskDefineEntity();
        BeanUtils.beanCopy((Object)ruleRiskDefineBo, (Object)ruleRiskDefineEntity);
        return this.ruleRiskDefineMapper.updateByPrimaryKey(ruleRiskDefineEntity);
    }

    private void beforeCheck(RuleRiskDefineBo ruleRiskDefineBo, String operType) {
        if (ruleRiskDefineBo == null) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ("update".equals(operType) && StringUtils.isEmpty((CharSequence)ruleRiskDefineBo.getRiskId())) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)ruleRiskDefineBo.getRiskName())) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)ruleRiskDefineBo.getIsEnable())) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public int delete(String riskId) {
        if (StringUtils.isEmpty((CharSequence)riskId)) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.ruleRiskDefineMapper.deleteByPrimaryKey(riskId);
    }

    @Override
    public List<RuleRiskDefineVo> index(QueryModel model) {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<RuleRiskDefineEntity> list = this.ruleRiskDefineMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleRiskDefineVo.class);
        PageHelper.clearPage();
        return voList;
    }

    @Override
    public List<RuleRiskDefineVo> list(QueryModel model) {
        List<RuleRiskDefineEntity> list = this.ruleRiskDefineMapper.selectByModel(model);
        List voList = (List)BeanUtils.beansCopy(list, RuleRiskDefineVo.class);
        return voList;
    }

    @Override
    public RuleRiskDefineVo show(RuleRiskDefineQuery ruleRiskDefineQuery) {
        if (null == ruleRiskDefineQuery || StringUtils.isEmpty((CharSequence)ruleRiskDefineQuery.getRiskId())) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        QueryModel model = new QueryModel();
        model.setCondition((Object)ruleRiskDefineQuery);
        List<RuleRiskDefineVo> list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u98ce\u9669\u89c4\u5219\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!");
        }
        return list.get(0);
    }
}

