/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.check;

import java.util.List;
import java.util.Map;

public class RuleObject {
    private Map<String, List> mapRuleCondition;
    private Map<String, List> mapParameter;
    private Map<String, Map> mapRuleDefine;
    private List<Map> listPriorEvent;
    private List<Map> listPostEvent;

    public RuleObject() {
    }

    public RuleObject(Map<String, Map> ruleDefine, Map<String, List> mapRuleCond, Map<String, List> mapParam, List<Map> priorEvent, List<Map> postEvent) {
        this.mapRuleCondition = mapRuleCond;
        this.mapParameter = mapParam;
        this.mapRuleDefine = ruleDefine;
        this.listPriorEvent = priorEvent;
        this.listPostEvent = postEvent;
    }

    public Map getRuleDefine(String ruleId) {
        return this.mapRuleDefine.get(ruleId);
    }

    public List<Map> getCondition(String ruleId) {
        return this.mapRuleCondition.get(ruleId);
    }

    public List<Map> getPriorEvent() {
        return this.listPriorEvent;
    }

    public List<Map> getPostEvent() {
        return this.listPostEvent;
    }

    public List<Map> getParameter(String condId) {
        return this.mapParameter == null ? null : this.mapParameter.get(condId);
    }

    public boolean isEmptyPrior() {
        return this.listPriorEvent == null || this.listPriorEvent.isEmpty();
    }

    public boolean isEmptyPost() {
        return this.listPostEvent == null || this.listPostEvent.isEmpty();
    }

    public void addRule(RuleObject rule) {
        if (rule == null || rule.isEmptyPrior() && rule.isEmptyPost()) {
            return;
        }
        if (this.mapRuleDefine == null) {
            this.mapRuleDefine = rule.mapRuleDefine;
        } else {
            this.mapRuleDefine.putAll(rule.mapRuleDefine);
        }
        if (this.mapParameter == null) {
            this.mapParameter = rule.mapParameter;
        } else {
            this.mapParameter.putAll(rule.mapParameter);
        }
        if (this.mapRuleCondition == null) {
            this.mapRuleCondition = rule.mapRuleCondition;
        } else {
            this.mapRuleCondition.putAll(rule.mapRuleCondition);
        }
        if (this.listPostEvent == null) {
            this.listPostEvent = rule.listPostEvent;
        } else {
            this.listPostEvent.addAll(rule.listPostEvent);
        }
        if (this.listPriorEvent == null) {
            this.listPriorEvent = rule.listPriorEvent;
        } else {
            this.listPriorEvent.addAll(rule.listPriorEvent);
        }
        if (this.mapRuleCondition == null) {
            this.mapRuleCondition = rule.mapRuleCondition;
        } else {
            this.mapRuleCondition.putAll(rule.mapRuleCondition);
        }
    }
}

