/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rule.check;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.rule.check.RuleBean;
import cn.com.yusys.yusp.rule.check.RuleComputer;
import cn.com.yusys.yusp.rule.check.RuleObject;
import cn.com.yusys.yusp.rule.dao.RuleDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class RuleHandle {
    private static final Logger logger = LoggerFactory.getLogger(RuleHandle.class);
    private static Map<String, String> authRoleMapping = new HashMap<String, String>();
    @Autowired
    private RuleDao ruleMapper;
    @Autowired
    private RuleComputer ruleComputer;
    @Autowired
    private RuleBean ruleBean;
    private static final String EVENT_TYPE = "event_type";
    private static final String EVENT_ID = "event_id";

    public IcspResultDto checkConCal(Map<String, Object> mapIn) throws Exception {
        Map data;
        HashMap mapHead = (HashMap)mapIn.get("header");
        if (mapHead == null) {
            mapHead = new HashMap();
        }
        if (!mapHead.containsKey("channel")) {
            // empty if block
        }
        if ((data = (Map)mapIn.get("data")) == null) {
            throw new IcspException("500", "\u62a5\u6587\u683c\u5f0f\u9519\u8bef!");
        }
        String serviceScene = (String)mapHead.get("scene");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String serviceCode = request.getServletPath();
        RuleObject ruleObject = this.ruleBean.mapper.getRuleObject(serviceScene, serviceCode, this.ruleBean);
        HashMap<String, Boolean> computeRet = new HashMap<String, Boolean>();
        if (ruleObject.isEmptyPrior()) {
            logger.debug("\u4ea4\u6613\u573a\u666f[{}]\u670d\u52a1\u7801[{}]\u63d0\u4ea4\u524d\u89c4\u5219\u4e3a\u7a7a", (Object)serviceScene, (Object)serviceCode);
        } else {
            List<Map> trueRules = this.computePriorRule(ruleObject, computeRet, mapHead, data);
            if (trueRules.isEmpty()) {
                logger.info("\u4ea4\u6613\u573a\u666f[{}]\u670d\u52a1\u7801[{}]\u63d0\u4ea4\u524d\u89c4\u5219\u8ba1\u7b97\u4e0d\u6210\u7acb", (Object)serviceScene, (Object)serviceCode);
            } else {
                ArrayList<Map> listAuthEvent = new ArrayList<Map>();
                for (Map rule : trueRules) {
                    if ("2".equals(rule.get(EVENT_TYPE))) {
                        Map info = this.ruleMapper.queryRefuseEvent((String)rule.get(EVENT_ID));
                        if (info == null) {
                            throw new IcspException("500", "\u62d2\u7edd\u53d1\u8d77");
                        }
                        throw new IcspException("500", (String)info.get("msg_content"));
                    }
                    listAuthEvent.add(rule);
                }
                if (!listAuthEvent.isEmpty()) {
                    String seq = (String)mapHead.get("seq");
                    if (seq == null || seq.isEmpty()) {
                        throw new IcspException("9", "\u5168\u5c40\u6d41\u6c34[header.seq]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    logger.info("\u4ea4\u6613\u573a\u666f[{}]\u670d\u52a1\u7801[{}]\u5168\u5c40\u6d41\u6c34[{}]\u9700\u8981\u6388\u6743", new Object[]{serviceScene, serviceCode, seq});
                    return this.doAuthRule(listAuthEvent, ruleObject, mapHead);
                }
            }
        }
        return IcspResultDto.success((Object)0);
    }

    public List<Map> computePriorRule(RuleObject rule, Map<String, Boolean> computeRet, Map inHead, Map inBody) {
        ArrayList<Map> trueEvent = new ArrayList<Map>();
        for (Map event : rule.getPriorEvent()) {
            String ruleId = (String)event.get("rule_id");
            Boolean ret = computeRet.get(ruleId);
            if (ret == null) {
                ret = this.ruleComputer.computeEntry(ruleId, rule, inHead, inBody, null);
                computeRet.put(ruleId, ret);
            }
            if (!ret.booleanValue()) continue;
            if ("2".equals(event.get(EVENT_TYPE))) {
                trueEvent.clear();
                trueEvent.add(event);
                return trueEvent;
            }
            trueEvent.add(event);
        }
        return trueEvent;
    }

    public IcspResultDto doAuthRule(List<Map> listAuthEvent, RuleObject ruleObject, Map header) {
        ArrayList<Map> listLocal = new ArrayList<Map>();
        ArrayList<Map> listRemote = new ArrayList<Map>();
        ArrayList<String> listRemoteId = new ArrayList<String>();
        boolean isCloseCenterAuth = false;
        for (Map map : listAuthEvent) {
            if ("1".equals(map.get("auth_type"))) {
                listLocal.add(map);
            } else if (isCloseCenterAuth && "3".equals(map.get("auth_type"))) {
                map.put("auth_role", authRoleMapping.get(map.get("auth_role")));
                listLocal.add(map);
            } else {
                listRemoteId.add((String)map.get("id"));
                listRemote.add(map);
            }
            map.put("auth_reason", ruleObject.getRuleDefine((String)map.get("rule_id")).get("rule_name"));
        }
        HashMap<String, ArrayList<Object>> out = new HashMap<String, ArrayList<Object>>();
        Object channel = header.get("channel");
        if (channel == null) {
            logger.warn("\u4ea4\u6613\u6e20\u9053[header.channel]\u6807\u5fd7\u4e3a\u7a7a");
            throw new IcspException("999", "\u4ea4\u6613\u6e20\u9053[header.channel]\u6807\u5fd7\u4e3a\u7a7a");
        }
        if ("YB".equals(channel)) {
            if (listLocal.isEmpty()) {
                return IcspResultDto.success((String)"80", (Object)"\u4ea4\u6613\u9700\u8981\u6388\u6743");
            }
            if (listRemoteId.isEmpty()) {
                out.put("authInfo", listLocal);
                return IcspResultDto.success((String)"81", (Object)"\u672c\u5730\u6388\u6743");
            }
        } else if ("YT".equals(channel)) {
            if (listLocal.isEmpty()) {
                return IcspResultDto.success((String)"80", (Object)"\u4ea4\u6613\u9700\u8981\u6388\u6743");
            }
            if (listRemoteId.isEmpty()) {
                out.put("authInfo", listLocal);
                return IcspResultDto.success((String)"81", (Object)"\u672c\u5730\u6388\u6743");
            }
        } else {
            logger.warn("\u5f53\u524d\u6e20\u9053[{}]\u4e0d\u652f\u6301\u6388\u6743\uff0c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f", channel);
            return IcspResultDto.success((String)"999", (Object)"\u5f53\u524d\u6e20\u9053[\" + channel + \"]\u4e0d\u652f\u6301\u6388\u6743");
        }
        if (!listRemote.isEmpty()) {
            IcspResultDto result = IcspResultDto.success((String)"3", (Object)"\u8fdc\u7a0b\u6388\u6743");
            out.put("authIds", listRemoteId);
            out.put("remoteAuthInfo", listRemote);
            result.setBody(out);
            return result;
        }
        return IcspResultDto.success((Object)0);
    }

    public static Map<String, String> getAuthRoleMapping() {
        return authRoleMapping;
    }

    static {
        authRoleMapping.put("0099", "T002");
        authRoleMapping.put("M001", "T002,T003");
        authRoleMapping.put("0006", "T002,T003");
        authRoleMapping.put("0007", "T002,T003");
        authRoleMapping.put("0023", "T002,T003");
        authRoleMapping.put("M002", "T002,T003,T005");
        authRoleMapping.put("M003", "T002,T003");
        authRoleMapping.put("M004", "T002");
    }
}

