/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.operation.bo.LogAdminSmBo;
import cn.com.yusys.yusp.operation.domain.query.LogAdminSmQuery;
import cn.com.yusys.yusp.operation.service.LogAdminSmService;
import cn.com.yusys.yusp.operation.vo.LogAdminSmVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logAdminSm"})
public class LogAdminSmController {
    private static final Logger logger = LoggerFactory.getLogger(LogAdminSmController.class);
    @Autowired
    private LogAdminSmService logAdminSmService;

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<LogAdminSmBo> request, HttpServletRequest httpServletRequest) throws Exception {
        LogAdminSmBo logAdminSm = (LogAdminSmBo)request.getBody();
        String clientIp = httpServletRequest.getHeader("x-forwarded-for");
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = httpServletRequest.getRemoteAddr();
        }
        logAdminSm.setLoginIp(clientIp);
        int result = this.logAdminSmService.create(logAdminSm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    public IcspResultDto<LogAdminSmVo> show(@RequestBody IcspRequest<LogAdminSmQuery> request) throws Exception {
        LogAdminSmQuery logAdminSm = (LogAdminSmQuery)request.getBody();
        LogAdminSmVo result = this.logAdminSmService.show(logAdminSm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    public IcspResultDto<List<LogAdminSmVo>> index(@RequestBody IcspRequest<LogAdminSmQuery> request) throws Exception {
        List<LogAdminSmVo> list = this.logAdminSmService.index(request.getQueryModel());
        return IcspResultDto.success(list);
    }

    @PostMapping(value={"/list"})
    public IcspResultDto<List<LogAdminSmVo>> list(@RequestBody IcspRequest<LogAdminSmQuery> request) throws Exception {
        List<LogAdminSmVo> list = this.logAdminSmService.list(request.getQueryModel());
        return IcspResultDto.success(list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<LogAdminSmBo> request) throws Exception {
        LogAdminSmBo logAdminSm = (LogAdminSmBo)request.getBody();
        int result = this.logAdminSmService.update(logAdminSm);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<LogAdminSmBo> request) throws Exception {
        LogAdminSmBo logAdminSm = (LogAdminSmBo)request.getBody();
        int result = this.logAdminSmService.delete(logAdminSm.getLogId());
        return IcspResultDto.success((Object)result);
    }
}

