/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.job.utils.utils;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.job.utils.config.XxlJobConfig;
import cn.com.yusys.yusp.job.utils.dto.XxlJobGroup;
import cn.com.yusys.yusp.job.utils.utils.GsonUtils;
import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class JobUtils {
    private static Logger logger = LoggerFactory.getLogger(JobUtils.class);
    public static final String GET_GROUP_ID_PATH = "/jobgroup/loadByAppName";
    public static final String ADD_JOB_PATH = "/jobinfo/add-no-limit";
    public static final String UPDATE_JOB_PATH = "/jobinfo/update-no-limit";
    public static final String REMOVE_JOB_PATH = "/jobinfo/remove-no-limit";

    public static String addJob(String jobId, String jobHandler, String cron, String params, String desc) {
        XxlJobConfig xxlJobConfig = (XxlJobConfig)SpringContextUtils.getBean(XxlJobConfig.class);
        int groupId = JobUtils.getGroupId(xxlJobConfig.getAppname());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", jobId);
        map.put("jobGroup", groupId);
        map.put("jobDesc", desc);
        map.put("executorRouteStrategy", "FIRST");
        map.put("scheduleType", "CRON");
        map.put("jobCron", cron);
        map.put("scheduleConf", cron);
        map.put("glueType", "BEAN");
        map.put("executorHandler", jobHandler);
        map.put("executorBlockStrategy", "SERIAL_EXECUTION");
        map.put("executorTimeout", 0);
        map.put("executorFailRetryCount", 0);
        map.put("author", "admin");
        map.put("glueRemark", "\u521d\u59cb\u5316");
        map.put("triggerStatus", 1);
        map.put("executorParam", params);
        map.put("misfireStrategy", "DO_NOTHING");
        String response = JobUtils.doPost(xxlJobConfig.getAdminAddresses() + ADD_JOB_PATH, GsonUtils.getJsonStr(map));
        logger.info(response);
        return response;
    }

    public static int getGroupId(String appName) {
        XxlJobConfig xxlJobConfig = (XxlJobConfig)SpringContextUtils.getBean(XxlJobConfig.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appname", appName);
        String response = JobUtils.doPost(xxlJobConfig.getAdminAddresses() + GET_GROUP_ID_PATH, GsonUtils.getJsonStr(map));
        ReturnT returnT = (ReturnT)GsonUtils.jsonToBean(response, new TypeToken<ReturnT<XxlJobGroup>>(){}.getType());
        return ((XxlJobGroup)returnT.getContent()).getId();
    }

    public static String updateJob(String jobId, String jobHandler, String cron, String params, String desc) {
        XxlJobConfig xxlJobConfig = (XxlJobConfig)SpringContextUtils.getBean(XxlJobConfig.class);
        int groupId = JobUtils.getGroupId(xxlJobConfig.getAppname());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", jobId);
        map.put("jobGroup", groupId);
        map.put("jobDesc", desc);
        map.put("executorRouteStrategy", "FIRST");
        map.put("jobCron", cron);
        map.put("glueType", "BEAN");
        map.put("executorHandler", jobHandler);
        map.put("executorBlockStrategy", "SERIAL_EXECUTION");
        map.put("executorTimeout", 0);
        map.put("executorFailRetryCount", 0);
        map.put("author", "admin");
        map.put("glueRemark", "\u521d\u59cb\u5316");
        map.put("triggerStatus", 1);
        map.put("executorParam", params);
        String response = JobUtils.doPost(xxlJobConfig.getAdminAddresses() + UPDATE_JOB_PATH, GsonUtils.getJsonStr(map));
        logger.info(response);
        return response;
    }

    public static String removeJob(String jobId) {
        XxlJobConfig xxlJobConfig = (XxlJobConfig)SpringContextUtils.getBean(XxlJobConfig.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", jobId);
        String response = JobUtils.doPost(xxlJobConfig.getAdminAddresses() + REMOVE_JOB_PATH, GsonUtils.getJsonStr(map));
        logger.info(response);
        return response;
    }

    public static String doPost(String url, String json) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
        return ((String)responseEntity.getBody()).toString();
    }

    public static void main(String[] args) {
        System.out.println(JobUtils.addJob("", "demoJobHandler", "0 * * * * ?", "", "test1"));
    }
}

