/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.job.utils.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class GsonUtils {
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("_[a-z]");
    private static final Pattern UNDERLINE_MARGIN_PATTERN = Pattern.compile("(margin)(_)(left|right|top|bottom)");
    private static final Pattern MINUS_MARGIN_PATTERN = Pattern.compile("(margin)(-)(left|right|top|bottom)");
    private static final Pattern UNDERLINE_BACKGROUND_PATTERN = Pattern.compile("(background)(_)(image|size|repeat|color)");
    private static final Pattern MINUS_BACKGROUND_PATTERN = Pattern.compile("(background)(-)(image|size|repeat|color)");

    public static JsonObject objectToJSON(Object obj) {
        Gson gson = new Gson();
        return (JsonObject)gson.toJsonTree(obj);
    }

    public static <T> T mergeObject(T sourceObject, T destObject) {
        JsonObject sourceJson = null;
        JsonObject destJson = null;
        if (sourceObject instanceof JsonObject) {
            sourceJson = (JsonObject)sourceObject;
            destJson = (JsonObject)destObject;
        } else {
            Gson gson = new Gson();
            sourceJson = gson.toJsonTree(sourceObject).getAsJsonObject();
            destJson = gson.toJsonTree(destObject).getAsJsonObject();
            gson = null;
        }
        Iterator iter = destJson.entrySet().iterator();
        Set set = sourceJson.entrySet();
        while (iter.hasNext()) {
            Map.Entry item = (Map.Entry)iter.next();
            String fieldName = (String)item.getKey();
            JsonElement obj = (JsonElement)item.getValue();
            if (!set.contains(fieldName) || null == obj) continue;
            sourceJson.add(fieldName, obj);
        }
        Class<?> cls = sourceObject.getClass();
        return (T)GsonUtils.jsonToBean((JsonElement)sourceJson, cls);
    }

    public static JsonObject excludesProperty(JsonObject jsonObj, String[] excludes) {
        for (String excludeName : excludes) {
            if (!jsonObj.has(excludeName)) continue;
            jsonObj.remove(excludeName);
        }
        return jsonObj;
    }

    public static JsonObject getCombineJson(JsonObject newJson, Object oldObject) {
        Gson gson = new Gson();
        JsonObject oldJson = (JsonObject)gson.toJsonTree(oldObject);
        gson = null;
        Iterator iter = newJson.entrySet().iterator();
        Set set = oldJson.entrySet();
        while (iter.hasNext()) {
            Map.Entry item = (Map.Entry)iter.next();
            String fieldName = (String)item.getKey();
            JsonElement obj = (JsonElement)item.getValue();
            if (!set.contains(fieldName)) continue;
            oldJson.add(fieldName, obj);
        }
        return oldJson;
    }

    public static List<String> getKeys(JsonObject json) {
        if (null == json) {
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        Iterator it = json.entrySet().iterator();
        while (it.hasNext()) {
            keyList.add((String)((Map.Entry)it.next()).getKey());
        }
        return keyList;
    }

    public static <T> T jsonToBean(String sourceJson, Type type) {
        Gson gson = new Gson();
        JsonParser jsonParser = new JsonParser();
        JsonElement jse = jsonParser.parse(sourceJson);
        Object obj = gson.fromJson(jse, type);
        gson = null;
        return (T)obj;
    }

    public static <T> T jsonToBean(JsonElement sourceJson, Type type) {
        Gson gson = new Gson();
        Object obj = gson.fromJson(sourceJson, type);
        gson = null;
        return (T)obj;
    }

    public static <T> T jsonToBean(String sourceJson, Class<T> sourceClass) {
        Gson gson = new Gson();
        Object obj = gson.fromJson(sourceJson, sourceClass);
        gson = null;
        return (T)obj;
    }

    public static <T> T jsonToBean(JsonElement sourceJson, Class<T> sourceClass) {
        Gson gson = new Gson();
        Object obj = gson.fromJson(sourceJson, sourceClass);
        gson = null;
        return (T)obj;
    }

    public static <T> T jsonToBean(String jsonStr, Class<T> sourceClass, String dateFormat) {
        if (StringUtils.isEmpty((Object)dateFormat)) {
            return GsonUtils.jsonToBean(jsonStr, sourceClass);
        }
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).create();
        Object obj = gson.fromJson(jsonStr, sourceClass);
        gson = null;
        return (T)obj;
    }

    public static <T> T jsonToBean(JsonElement sourceJson, Class<T> sourceClass, String dateFormat) {
        if (StringUtils.isEmpty((Object)dateFormat)) {
            return GsonUtils.jsonToBean(sourceJson, sourceClass);
        }
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).create();
        Object obj = gson.fromJson(sourceJson, sourceClass);
        gson = null;
        return (T)obj;
    }

    public static String getJsonStr(Object obj) {
        Gson gson = new Gson();
        String resultStr = gson.toJson(obj);
        gson = null;
        return resultStr;
    }

    public static String getJsonStrUnEscape(Object obj) {
        GsonBuilder gb = new GsonBuilder();
        gb.disableHtmlEscaping();
        return gb.create().toJson(obj);
    }

    public static JsonObject getJsonObject(String jsonStr) {
        JsonParser parser = new JsonParser();
        if (!StringUtils.isEmpty((Object)jsonStr)) {
            return parser.parse(jsonStr).getAsJsonObject();
        }
        return null;
    }

    public static JsonArray getJsonArray(String jsonStr) {
        JsonParser parser = new JsonParser();
        return parser.parse(jsonStr).getAsJsonArray();
    }

    public static JsonObject getHumpToUnderlineJsonObject(JsonObject sourceJson) {
        JsonObject destJson = GsonUtils.getHumpToUnderlineJsonElement((JsonElement)sourceJson).getAsJsonObject();
        return destJson;
    }

    public static JsonObject getUnderlineToHumpJsonObject(JsonObject sourceJson) {
        JsonObject destJson = GsonUtils.getUnderlineToHumpJsonElement((JsonElement)sourceJson).getAsJsonObject();
        return destJson;
    }

    public static JsonArray getHumpToUnderlineJsonArray(JsonArray sourceJson) {
        JsonArray destJson = GsonUtils.getHumpToUnderlineJsonElement((JsonElement)sourceJson).getAsJsonArray();
        return destJson;
    }

    public static JsonArray getUnderlineToHumpJsonArray(JsonArray sourceJson) {
        JsonArray destJson = GsonUtils.getUnderlineToHumpJsonElement((JsonElement)sourceJson).getAsJsonArray();
        return destJson;
    }

    public static JsonElement getUnderlineToHumpJsonElement(String sourceJsonStr) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(sourceJsonStr);
        return GsonUtils.getUnderlineToHumpJsonElement(jsonElement);
    }

    public static JsonElement getUnderlineToHumpJsonElement(JsonElement jsonElement) {
        return GsonUtils.getTranslateJsonElement(jsonElement, TranslateType.UNDERLINE_TO_HUMP);
    }

    public static JsonElement getHumpToUnderlineJsonElement(String sourceJsonStr) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(sourceJsonStr);
        return GsonUtils.getHumpToUnderlineJsonElement(jsonElement);
    }

    public static JsonElement getHumpToUnderlineJsonElement(JsonElement jsonElement) {
        return GsonUtils.getTranslateJsonElement(jsonElement, TranslateType.HUMP_TO_UNDERLINE);
    }

    private static JsonElement getTranslateJsonElement(JsonElement jsonElement, TranslateType type) {
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            JsonArray newJsonArray = new JsonArray();
            for (JsonElement item : jsonArray) {
                newJsonArray.add(GsonUtils.getTranslateJsonElement(item, type));
            }
            int oldJsonArraySize = jsonArray.size();
            for (int i = oldJsonArraySize - 1; i >= 0; --i) {
                jsonArray.remove(i);
            }
            jsonArray.addAll(newJsonArray);
        } else if (jsonElement instanceof JsonObject) {
            return GsonUtils.translate(jsonElement.getAsJsonObject(), type);
        }
        return jsonElement;
    }

    private static JsonObject translate(JsonObject sourceJson, TranslateType translateType) {
        JsonObject destJson = new JsonObject();
        for (Map.Entry jsonItem : sourceJson.entrySet()) {
            String fieldName = (String)jsonItem.getKey();
            JsonElement fieldValue = (JsonElement)jsonItem.getValue();
            if (fieldValue instanceof JsonObject) {
                fieldValue = GsonUtils.translate((JsonObject)fieldValue, translateType);
            } else if (fieldValue instanceof JsonArray) {
                JsonArray valueArray = (JsonArray)fieldValue;
                fieldValue = GsonUtils.translateJsonArray(valueArray, translateType);
            }
            switch (translateType) {
                case UNDERLINE_TO_HUMP: {
                    fieldName = GsonUtils.underLineToHumpField(fieldName);
                    break;
                }
                case HUMP_TO_UNDERLINE: {
                    fieldName = GsonUtils.humpToUderlineField(fieldName);
                    break;
                }
            }
            destJson.add(fieldName, fieldValue);
        }
        sourceJson = null;
        return destJson;
    }

    private static JsonArray translateJsonArray(JsonArray sourceJsonArray, TranslateType translateType) {
        JsonArray destJsonArray = new JsonArray();
        for (JsonElement valueItem : sourceJsonArray) {
            if (valueItem instanceof JsonObject) {
                destJsonArray.add((JsonElement)GsonUtils.translate(valueItem.getAsJsonObject(), translateType));
                continue;
            }
            if (valueItem instanceof JsonArray) {
                destJsonArray.add((JsonElement)GsonUtils.translateJsonArray(valueItem.getAsJsonArray(), translateType));
                continue;
            }
            destJsonArray.add(valueItem);
        }
        return destJsonArray;
    }

    private static String humpToUderlineField(String fieldName) {
        Matcher matcher = HUMP_PATTERN.matcher(fieldName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g = matcher.group();
            matcher.appendReplacement(sb, "_" + g.toLowerCase());
        }
        matcher.appendTail(sb);
        String tmpFieldName = sb.toString();
        matcher = UNDERLINE_MARGIN_PATTERN.matcher(tmpFieldName);
        tmpFieldName = matcher.replaceAll("$1-$3");
        matcher = UNDERLINE_BACKGROUND_PATTERN.matcher(tmpFieldName);
        tmpFieldName = matcher.replaceAll("$1-$3");
        return tmpFieldName;
    }

    private static String underLineToHumpField(String fieldName) {
        String tmpFieldName = fieldName;
        Matcher matcher = MINUS_MARGIN_PATTERN.matcher(tmpFieldName);
        tmpFieldName = matcher.replaceAll("$1_$3");
        matcher = MINUS_BACKGROUND_PATTERN.matcher(tmpFieldName);
        tmpFieldName = matcher.replaceAll("$1_$3");
        matcher = UNDERLINE_PATTERN.matcher(tmpFieldName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g = matcher.group();
            if (g.length() != 2) continue;
            matcher.appendReplacement(sb, g.substring(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static enum TranslateType {
        UNDERLINE_TO_HUMP,
        HUMP_TO_UNDERLINE;

    }
}

