/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.job.utils.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CronUtils {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    public static String getCronByDefaultFormat(String dateStr) {
        Date date = CronUtils.unifyDate(DEFAULT_DATE_FORMAT, dateStr);
        StringBuilder sb = new StringBuilder();
        String space = " ";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        sb.append(calendar.get(13)).append(space).append(calendar.get(12)).append(space).append(calendar.get(11)).append(space).append(calendar.get(5)).append(space).append(calendar.get(2) + 1).append(space).append("?").append(space).append(calendar.get(1));
        return sb.toString();
    }

    public static String getCron(String dateStr, String dateFormatStr) {
        Date date = CronUtils.unifyDate(dateFormatStr, dateStr);
        StringBuilder sb = new StringBuilder();
        String space = " ";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        sb.append(calendar.get(13)).append(space).append(calendar.get(12)).append(space).append(calendar.get(11)).append(space).append(calendar.get(5)).append(space).append(calendar.get(2) + 1).append(space).append("?").append(space).append(calendar.get(1));
        return sb.toString();
    }

    public static String createLoopCronExpression(int rate, int cycle) {
        String cron = "";
        switch (rate) {
            case 0: {
                cron = "0/" + cycle + " * * * * ?";
                break;
            }
            case 1: {
                cron = "0 0/" + cycle + " * * * ?";
                break;
            }
            case 2: {
                cron = "0 0 0/" + cycle + " * * ?";
                break;
            }
            case 3: {
                cron = "0 0 0 1/" + cycle + " * ?";
                break;
            }
            case 4: {
                cron = "0 0 0 1 1/" + cycle + " ? ";
                break;
            }
            case 5: {
                cron = "0 0 " + cycle + "  * * ?";
                break;
            }
            default: {
                cron = "0/1 * * * * ?";
            }
        }
        return cron;
    }

    public static Date unifyDate(String sFormat, String sDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(sFormat);
        Date d = null;
        try {
            sdf.setLenient(false);
            d = sdf.parse(sDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    public static void main(String[] args) {
        String dateStr = "2021-11-16";
        System.out.println(CronUtils.getCronByDefaultFormat(dateStr));
    }
}

