/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.job.utils.client;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.job.utils.client.JobGroupClient;
import cn.com.yusys.yusp.job.utils.client.JobInfoClient;
import cn.com.yusys.yusp.job.utils.config.XxlJobConfig;
import cn.com.yusys.yusp.job.utils.dto.XxlJobGroup;
import cn.com.yusys.yusp.job.utils.dto.XxlJobInfo;
import cn.com.yusys.yusp.job.utils.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobClient {
    private static Logger logger = LoggerFactory.getLogger(JobClient.class);
    @Autowired
    JobGroupClient jobGroupClient;
    @Autowired
    JobInfoClient jobInfoClient;

    public String addJob(String jobId, String jobHandler, String cron, String params, String desc) {
        XxlJobConfig xxlJobConfig = (XxlJobConfig)SpringContextUtils.getBean(XxlJobConfig.class);
        int groupId = this.getGroupId(xxlJobConfig.getAppname());
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setId(jobId);
        xxlJobInfo.setJobGroup(groupId);
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorRouteStrategy("ROUND");
        xxlJobInfo.setScheduleType("CRON");
        xxlJobInfo.setScheduleConf(cron);
        xxlJobInfo.setGlueType("BEAN");
        xxlJobInfo.setExecutorHandler(jobHandler);
        xxlJobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        xxlJobInfo.setExecutorTimeout(0);
        xxlJobInfo.setExecutorFailRetryCount(0);
        xxlJobInfo.setAuthor("admin");
        xxlJobInfo.setGlueRemark("\u521d\u59cb\u5316");
        xxlJobInfo.setTriggerStatus(1);
        xxlJobInfo.setExecutorParam(params);
        xxlJobInfo.setMisfireStrategy("DO_NOTHING");
        ReturnT<String> returnT = null;
        try {
            returnT = this.jobInfoClient.addNoLimit(xxlJobInfo);
            logger.info("\u6dfb\u52a0\u5b9a\u65f6\u5668\u8fd4\u56de\u7ed3\u679c:{}", (Object)GsonUtils.getJsonStr(returnT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnT != null ? (String)returnT.getContent() : "";
    }

    public int getGroupId(String appName) {
        ReturnT<XxlJobGroup> returnT = null;
        XxlJobGroup xxlJobGroup = new XxlJobGroup();
        xxlJobGroup.setAppname(appName);
        try {
            returnT = this.jobGroupClient.loadByAppName(xxlJobGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((XxlJobGroup)returnT.getContent()).getId();
    }

    public String updateJob(String jobId, String jobHandler, String cron, String params, String desc) {
        XxlJobConfig xxlJobConfig = (XxlJobConfig)SpringContextUtils.getBean(XxlJobConfig.class);
        int groupId = this.getGroupId(xxlJobConfig.getAppname());
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setId(jobId);
        xxlJobInfo.setJobGroup(groupId);
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorRouteStrategy("ROUND");
        xxlJobInfo.setScheduleType("CRON");
        xxlJobInfo.setScheduleConf(cron);
        xxlJobInfo.setGlueType("BEAN");
        xxlJobInfo.setExecutorHandler(jobHandler);
        xxlJobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        xxlJobInfo.setExecutorTimeout(0);
        xxlJobInfo.setExecutorFailRetryCount(0);
        xxlJobInfo.setAuthor("admin");
        xxlJobInfo.setGlueRemark("\u521d\u59cb\u5316");
        xxlJobInfo.setTriggerStatus(1);
        xxlJobInfo.setExecutorParam(params);
        xxlJobInfo.setMisfireStrategy("DO_NOTHING");
        ReturnT<String> returnT = null;
        try {
            returnT = this.jobInfoClient.updateNoLimit(xxlJobInfo);
            logger.info("\u66f4\u65b0\u5b9a\u65f6\u5668\u8fd4\u56de\u7ed3\u679c:{}", (Object)GsonUtils.getJsonStr(returnT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnT != null ? (String)returnT.getContent() : "";
    }

    public String removeJob(String jobId) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setId(jobId);
        ReturnT<String> returnT = null;
        try {
            returnT = this.jobInfoClient.removeNoLimit(xxlJobInfo);
            logger.info("\u5220\u9664\u5b9a\u65f6\u5668\u8fd4\u56de\u7ed3\u679c:{}", (Object)GsonUtils.getJsonStr(returnT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnT != null ? (String)returnT.getContent() : "";
    }
}

