/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.risk.serviec;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.head.ReqAppHead;
import cn.com.yusys.yusp.common.bsp.head.ReqSysHead;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.mid.common.MidReqLocalHead;
import cn.com.yusys.yusp.mid.common.MidRespLocalHead;
import cn.com.yusys.yusp.mid.common.NcbsServer;
import cn.com.yusys.yusp.mid.common.NeciServer;
import cn.com.yusys.yusp.mid.constants.BspRespChanMidCode;
import cn.com.yusys.yusp.mid.dao.ChanRiskEventDao;
import cn.com.yusys.yusp.mid.dao.ChanRiskRuleDao;
import cn.com.yusys.yusp.mid.domain.entity.ChanRiskEventEntity;
import cn.com.yusys.yusp.mid.service.T05002000004_05_ReqBody;
import cn.com.yusys.yusp.mid.service.T05002000004_05_RespBody;
import cn.com.yusys.yusp.mid.service.T05002000004_05_RespBodyArray_CheckInfo;
import cn.com.yusys.yusp.mid.service.T11003000001_62_BspResp;
import cn.com.yusys.yusp.mid.service.T11003000001_62_ReqBody;
import cn.com.yusys.yusp.mid.service.T11003000001_62_RespBody;
import cn.com.yusys.yusp.mid.service.T11003000001_62_RespBodyArray_TARGET_CUST_ARRAY;
import cn.com.yusys.yusp.mid.utils.SeqNoUtil;
import cn.com.yusys.yusp.mid.utils.ThreadPoolUtils;
import cn.com.yusys.yusp.risk.annotation.RiskCheck;
import cn.com.yusys.yusp.risk.vo.RiskParamVo;
import cn.com.yusys.yusp.risk.vo.RiskResultVo;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class RiskService {
    @Autowired
    private NeciServer neciServer;
    @Autowired
    private NcbsServer ncbsServer;
    @Autowired
    private ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(RiskService.class);
    @Autowired
    private SeqNoUtil seqNoUtil;
    @Autowired
    private ChanRiskEventDao chanRiskEventDao;
    @Value(value="${chan.riskTime:15}")
    private int riskTime;
    @Autowired
    private ChanRiskRuleDao chanRiskRuleDao;

    public BspResp<MidRespLocalHead, T05002000004_05_RespBody> checkRis(BspReq<MidReqLocalHead, T05002000004_05_ReqBody> request) throws Exception {
        T11003000001_62_RespBody t11003000001_62_respBody;
        List targetCustArrays;
        MidRespLocalHead midRespLocalHead = new MidRespLocalHead();
        BeanUtils.beanCopy((Object)request.getLOCAL_HEAD(), (Object)midRespLocalHead);
        ReqSysHead sysHead = request.getSYS_HEAD();
        ReqAppHead appHead = request.getAPP_HEAD();
        T05002000004_05_ReqBody t05002000004_05_reqBody = (T05002000004_05_ReqBody)request.getBODY();
        String clientNo = t05002000004_05_reqBody.getCLIENT_NO();
        String operationType = t05002000004_05_reqBody.getOPERATION_TYPE();
        String cardNo = t05002000004_05_reqBody.getCARD_NO();
        String globalId = t05002000004_05_reqBody.getGLOBAL_ID();
        String globalType = t05002000004_05_reqBody.getGLOBAL_TYPE();
        String clientName = t05002000004_05_reqBody.getCLIENT_NAME();
        T05002000004_05_RespBody respBody = new T05002000004_05_RespBody();
        List list = new ArrayList();
        respBody.setCHECK_INFO(list);
        if (StringUtils.isEmpty((CharSequence)clientNo) && StringUtils.isEmpty((CharSequence)cardNo) && StringUtils.isEmpty((CharSequence)globalId) && StringUtils.isEmpty((CharSequence)clientName) && StringUtils.isEmpty((CharSequence)t05002000004_05_reqBody.getWORK_PHONE()) && StringUtils.isEmpty((CharSequence)t05002000004_05_reqBody.getMOBILE()) && StringUtils.isEmpty((CharSequence)t05002000004_05_reqBody.getREG_ADDR()) && StringUtils.isEmpty((CharSequence)t05002000004_05_reqBody.getBUS_SITE_ADDR())) {
            respBody.setCHECK_INFO(list);
            return BspResp.success(null, (Object)respBody);
        }
        if (StringUtils.isEmpty((CharSequence)operationType)) {
            return BspResp.failure((String)"NGCSM000001", (String)"OPERATION_TYPE\uff1a\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object)midRespLocalHead, null);
        }
        if (StringUtils.isEmpty((CharSequence)t05002000004_05_reqBody.getTRANCODE())) {
            t05002000004_05_reqBody.setTRANCODE("M9999");
        }
        String code = "";
        T11003000001_62_ReqBody t11003000001_62_reqBody = null;
        if (StringUtils.nonEmpty((CharSequence)clientNo)) {
            t11003000001_62_reqBody = new T11003000001_62_ReqBody();
            t11003000001_62_reqBody.setQUERY_MODE("1");
            t11003000001_62_reqBody.setCUSTOMER_ID(clientNo);
        } else if (StringUtils.nonEmpty((CharSequence)globalId)) {
            t11003000001_62_reqBody = new T11003000001_62_ReqBody();
            t11003000001_62_reqBody.setQUERY_MODE("3");
            t11003000001_62_reqBody.setGLOBAL_ID(globalId);
            t11003000001_62_reqBody.setGLOBAL_TYPE(globalType);
        }
        T11003000001_62_BspResp t11003000001_62_bspResp = null;
        if (t11003000001_62_reqBody != null) {
            t11003000001_62_bspResp = this.neciServer.getT11003000001_62_BspResp(sysHead, appHead, (MidReqLocalHead)request.getLOCAL_HEAD(), t11003000001_62_reqBody);
        }
        if (t11003000001_62_bspResp != null && BspRespChanMidCode.SUCCESS.getCode().equals(t11003000001_62_bspResp.getCode()) && CollectionUtils.nonEmpty((Collection)(targetCustArrays = (t11003000001_62_respBody = t11003000001_62_bspResp.getBODY()).getTARGET_CUST_ARRAY()))) {
            for (T11003000001_62_RespBodyArray_TARGET_CUST_ARRAY targetCustArray : targetCustArrays) {
                if ("1".equals(targetCustArray.getCUST_CLASS())) {
                    t05002000004_05_reqBody.setIsPublic("N");
                    break;
                }
                if (!"2".equals(targetCustArray.getCUST_CLASS())) continue;
                t05002000004_05_reqBody.setIsPublic("Y");
                break;
            }
        }
        RiskParamVo riskParamVo = new RiskParamVo();
        ConcurrentHashMap<String, Object> params = new ConcurrentHashMap<String, Object>();
        HashSet<String> codeMap = new HashSet<String>();
        String[] operationTypes = operationType.split(",");
        List chekeType = this.chanRiskRuleDao.listIsEnable(operationTypes);
        HashMap errorMap = new HashMap();
        ArrayList<String> checkRosters = new ArrayList<String>();
        ArrayList<String> dowJonesList = new ArrayList<String>();
        ArrayList<String> checkAccountNums = new ArrayList<String>();
        for (String operationCode : chekeType) {
            if (operationCode.equals("caseAcctList") || operationCode.equals("caseOtherAcctList") || operationCode.equals("suspiciousList") || operationCode.equals("unitPerList") || operationCode.equals("lostPromiseCompany") || operationCode.equals("overdueCertificate") || operationCode.equals("noReceiptAndPayment") || operationCode.equals("onlyReceiveNotPay") || operationCode.equals("nonCounterProhibited") || operationCode.equals("counterSuspList") || operationCode.equals("noDealAcctList") || operationCode.equals("withDrawalPause") || operationCode.equals("privateNonCounter") || operationCode.equals("cashActiveAbnormal") || operationCode.equals("telFrandWarn")) {
                codeMap.add("checkRoster");
                checkRosters.add(operationCode);
                continue;
            }
            if (operationCode.equals("naturalPerson") || operationCode.equals("financialDirector") || operationCode.equals("controllingShareholder") || operationCode.equals("beneficiary") || operationCode.equals("crossAppointment") || operationCode.equals("customerPhone") || operationCode.equals("differentUserPhone") || operationCode.equals("publicAddr") || operationCode.equals("bankTel")) {
                codeMap.add("checkRoster");
                checkRosters.add(operationCode);
                continue;
            }
            if (operationCode.equals("dowJonesForb") || operationCode.equals("dowJonesWarn") || operationCode.equals("selfFocusList")) {
                codeMap.add("dowJones");
                dowJonesList.add(operationCode);
                continue;
            }
            if (operationCode.equals("cardCounts") || operationCode.equals("cardNum")) {
                codeMap.add("checkAccountNum");
                checkAccountNums.add(operationCode);
                continue;
            }
            codeMap.add(operationCode);
        }
        errorMap.put("checkRoster", checkRosters);
        errorMap.put("dowJones", dowJonesList);
        errorMap.put("checkAccountNum", checkAccountNums);
        riskParamVo.setCode(codeMap);
        params.put("errorMap", errorMap);
        params.put("operationType", org.apache.commons.lang3.StringUtils.join((Iterable)chekeType, (String)","));
        params.put("t05002000004_05_reqBody", t05002000004_05_reqBody);
        params.put("reqSysHead", request.getSYS_HEAD());
        params.put("reqAppHead", request.getAPP_HEAD());
        params.put("midReqLocalHead", request.getLOCAL_HEAD());
        riskParamVo.setParams(params);
        List<RiskResultVo> riskResultVo = this.check(riskParamVo);
        if (riskResultVo != null) {
            String listStr = JSON.toJSONString(riskResultVo);
            list = JSON.parseArray((String)listStr, T05002000004_05_RespBodyArray_CheckInfo.class);
            respBody.setCHECK_INFO(list);
        }
        return BspResp.success((Object)midRespLocalHead, (Object)respBody);
    }

    public List<RiskResultVo> check(final RiskParamVo riskParamVo) throws InterruptedException {
        final ArrayList<RiskResultVo> list = new ArrayList<RiskResultVo>();
        final HashSet code = riskParamVo.getCode();
        Reflections reflections = new Reflections("cn.com.yusys.yusp.risk.check", new Scanner[0]);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(Component.class);
        T05002000004_05_ReqBody reqBody = (T05002000004_05_ReqBody)riskParamVo.getParams().get("t05002000004_05_reqBody");
        final String tranCode = reqBody.getTRANCODE();
        final ConcurrentHashMap resultMap = new ConcurrentHashMap();
        final Map errorMap = (Map)riskParamVo.getParams().get("errorMap");
        ExecutorService executorService = ThreadPoolUtils.getInstance((int)15);
        if (executorService.isShutdown()) {
            executorService = ThreadPoolUtils.getInstance((int)15);
        }
        for (final Class clazz : typesAnnotatedWith) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        Method[] methods;
                        for (Method method : methods = clazz.getDeclaredMethods()) {
                            if (!method.isAnnotationPresent(RiskCheck.class)) continue;
                            RiskCheck annotation = method.getAnnotation(RiskCheck.class);
                            RiskService.this.seqNoUtil.createComsumerSeqNo();
                            String wayCode = annotation.WayCode();
                            if (!StringUtils.nonEmpty((CharSequence)wayCode) || !code.contains(wayCode)) continue;
                            try {
                                Object classInstance = RiskService.this.applicationContext.getBean(clazz);
                                boolean falge = (Boolean)method.invoke(classInstance, riskParamVo.getParams(), list);
                                resultMap.put(wayCode, falge);
                            }
                            catch (Exception e) {
                                RiskService.this.setError(code, errorMap, list, wayCode, tranCode);
                                logger.info(e.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.info(e.getMessage());
                    }
                }
            };
            executorService.submit(task);
        }
        executorService.shutdown();
        executorService.awaitTermination(this.riskTime, TimeUnit.SECONDS);
        Map<String, String> mapName = this.getRiskName();
        for (String key : code) {
            Object obj = resultMap.get(key);
            if ("publicTransfer".equals(key) || "privateTransfer".equals(key) || "privateCust".equals(key) || "publicCust".equals(key) || "overheadAccount".equals(key) || "cardReportLoss".equals(key) || obj != null) continue;
            RiskResultVo riskResultVo = new RiskResultVo();
            riskResultVo.setRESULT_STATUS("3");
            String name = mapName.get(key);
            riskResultVo.setRISK_NAME(name);
            riskResultVo.setDEAL_RESULT_DESC("\u8d85\u65f6");
            riskResultVo.setBLOCK_TYPE("02");
            riskResultVo.setCLIENT_RISK_LEVEL("1");
            list.add(riskResultVo);
        }
        return list;
    }

    public Map<String, String> getRiskName() {
        ConcurrentHashMap<String, String> mapName = new ConcurrentHashMap<String, String>();
        mapName.put("checkRoster", "\u98ce\u63a7\u7efc\u5408\u67e5\u8be2");
        mapName.put("dowJones", "\u7279\u6b8a\u540d\u5355\u67e5\u8be2");
        mapName.put("nqcsList", "\u67e5\u63a7\u5e73\u53f0\u540d\u5355\u67e5\u8be2");
        mapName.put("amllList", "\u53cd\u6d17\u94b1\u540d\u5355\u67e5\u8be2");
        mapName.put("queryIllegalComp", "\u4f01\u4e1a\u8054\u7f51\u6838\u67e5\u540d\u5355\u67e5\u8be2");
        mapName.put("corpAge", "\u6570\u636e\u4e2d\u53f0\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2");
        mapName.put("checkToDayReached", "\u5185\u90e8\u8d26\u6237\u4ea4\u6613\u5386\u53f2\u67e5\u8be2");
        mapName.put("agentPay", "\u4e2a\u4eba\u8d26\u6237\u529e\u7406\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u67e5\u8be2");
        mapName.put("unitDoor", "\u4ee3\u529e\u4eba\u4fe1\u606f\u67e5\u8be2");
        mapName.put("queryFrequent", "\u67dc\u5458\u9891\u7e41\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f");
        mapName.put("checkAccountNum", "\u5ba2\u6237\u5f00\u5361\u6570\u91cf\u67e5\u8be2");
        mapName.put("corporateBull", "\u5bf9\u516c\u8d26\u6237\u591a\u5934\u5f00\u6237\u67e5\u8be2");
        return mapName;
    }

    public void setError(HashSet code, Map<String, List<String>> errorMap, List<RiskResultVo> list, String wayCode, String tranCode) {
        List<String> errorList = errorMap.get(wayCode);
        ChanRiskEventEntity entity = null;
        RiskResultVo vo = null;
        if (CollectionUtils.nonEmpty(errorList)) {
            for (String key : errorList) {
                entity = this.chanRiskEventDao.getBlockType(key, tranCode);
                vo = new RiskResultVo();
                vo.setBLOCK_TYPE(entity.getBlockType());
                vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
                vo.setRISK_NAME(entity.getEventName());
                vo.setRISK_POSITION(entity.getRiskPosition());
                vo.setRESULT_STATUS("4");
                vo.setDEAL_RESULT_DESC("\u5f02\u5e38");
                list.add(vo);
            }
        } else {
            entity = this.chanRiskEventDao.getBlockType(wayCode, tranCode);
            if ("queryIllegalComp".equals(wayCode)) {
                vo = new RiskResultVo();
                vo.setRESULT_STATUS("3");
                vo.setRISK_NAME(entity.getEventName());
                vo.setDEAL_RESULT_DESC("\u8d85\u65f6");
                vo.setBLOCK_TYPE("02");
                vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
                list.add(vo);
            } else {
                vo = new RiskResultVo();
                vo.setBLOCK_TYPE(entity.getBlockType());
                vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
                vo.setRISK_NAME(entity.getEventName());
                vo.setRISK_POSITION(entity.getRiskPosition());
                vo.setRESULT_STATUS("4");
                vo.setDEAL_RESULT_DESC("\u5f02\u5e38");
                list.add(vo);
            }
        }
        code.remove(wayCode);
    }
}

