/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.risk.check.customet;

import cn.com.yusys.yusp.common.bsp.head.ReqAppHead;
import cn.com.yusys.yusp.common.bsp.head.ReqSysHead;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.mid.common.EdwoServer;
import cn.com.yusys.yusp.mid.common.MidReqLocalHead;
import cn.com.yusys.yusp.mid.common.NeciServer;
import cn.com.yusys.yusp.mid.constants.BspRespChanMidCode;
import cn.com.yusys.yusp.mid.dao.ChanRiskEventDao;
import cn.com.yusys.yusp.mid.domain.entity.ChanRiskEventEntity;
import cn.com.yusys.yusp.mid.service.T05002000004_05_ReqBody;
import cn.com.yusys.yusp.mid.service.T11003000001_84_BspResp;
import cn.com.yusys.yusp.mid.service.T11003000001_84_ReqBody;
import cn.com.yusys.yusp.mid.service.T11003000001_84_RespBody;
import cn.com.yusys.yusp.mid.service.T11003000001_84_RespBodyArray_CLIENT_ARRAY;
import cn.com.yusys.yusp.mid.utils.AgeUtil;
import cn.com.yusys.yusp.risk.annotation.RiskCheck;
import cn.com.yusys.yusp.risk.vo.RiskResultVo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerInfoCheck {
    @Autowired
    private ChanRiskEventDao chanRiskEventDao;
    @Autowired
    EdwoServer edwoServer;
    @Autowired
    private NeciServer neciServer;

    @RiskCheck(WayCode="corpAge", WayName="\u7b97\u68c0\u67e5\u5f53\u65e5\u5e74\u5ea6\u4e0e\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7684\u51fa\u751f\u5e74\u5ea6\u5dee\u8ddd\uff0c\u5c0f\u4e8e25\u6216\u8005\u5927\u4e8e65")
    public boolean checkCorpAge(Map<String, Object> map, List<RiskResultVo> list) throws Exception {
        boolean flage;
        ReqSysHead reqSysHead = (ReqSysHead)map.get("reqSysHead");
        ReqAppHead reqAppHead = (ReqAppHead)map.get("reqAppHead");
        MidReqLocalHead midReqLocalHead = (MidReqLocalHead)map.get("midReqLocalHead");
        T05002000004_05_ReqBody reqBody = (T05002000004_05_ReqBody)map.get("t05002000004_05_reqBody");
        reqAppHead.setTOTAL_NUM("10");
        reqAppHead.setCURRENT_NUM("1");
        T11003000001_84_ReqBody t11003000001_84_reqBody = new T11003000001_84_ReqBody();
        if (StringUtils.nonEmpty((CharSequence)reqBody.getCLIENT_NO())) {
            t11003000001_84_reqBody.setCLIENT_NO(reqBody.getCLIENT_NO());
        } else {
            t11003000001_84_reqBody.setGLOBAL_ID(reqBody.getGLOBAL_ID());
            t11003000001_84_reqBody.setGLOBAL_TYPE(reqBody.getGLOBAL_TYPE());
        }
        T11003000001_84_BspResp bspResp = this.edwoServer.getT11003000001_84_bspResp(reqSysHead, reqAppHead, midReqLocalHead, t11003000001_84_reqBody);
        int num = 0;
        List arrays = null;
        if (BspRespChanMidCode.SUCCESS.getCode().equals(bspResp.getCode())) {
            flage = true;
            T11003000001_84_RespBody t11003000001_84_respBody = bspResp.getBODY();
            if (t11003000001_84_respBody != null) {
                arrays = t11003000001_84_respBody.getCLIENT_ARRAY();
            }
            int age = 0;
            if (arrays != null) {
                T11003000001_84_RespBodyArray_CLIENT_ARRAY array = (T11003000001_84_RespBodyArray_CLIENT_ARRAY)arrays.get(0);
                String ageStr = array.getAGE();
                String birthDate = array.getBIRTH_DATE();
                if (StringUtils.nonEmpty((CharSequence)birthDate)) {
                    SimpleDateFormat sft = new SimpleDateFormat("yyyyMMdd");
                    Date date = sft.parse(birthDate);
                    age = AgeUtil.getAgeByBirth((Date)date);
                } else if (StringUtils.nonEmpty((CharSequence)ageStr)) {
                    age = Integer.parseInt(ageStr);
                }
            }
            if (age < 25 || age > 65) {
                num = 1;
            }
        } else {
            flage = false;
        }
        if (arrays != null && num > 0) {
            String tranCode = reqBody.getTRANCODE();
            ChanRiskEventEntity entity = this.chanRiskEventDao.getBlockType("corpAge", tranCode);
            if (entity == null) {
                return flage;
            }
            RiskResultVo vo = new RiskResultVo();
            vo.setBLOCK_TYPE(entity.getBlockType());
            vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
            vo.setRISK_NAME(entity.getEventName());
            vo.setRISK_POSITION(entity.getRiskPosition());
            vo.setRESULT_STATUS("1");
            vo.setDEAL_RESULT_DESC(entity.getEventSts());
            list.add(vo);
        } else {
            RiskResultVo vo = new RiskResultVo();
            vo.setBLOCK_TYPE("02");
            vo.setCLIENT_RISK_LEVEL("1");
            vo.setRISK_NAME("\u5355\u4f4d\u5ba2\u6237\u6cd5\u5b9a\u4ee3\u8868\u4eba/\u5355\u4f4d\u8d1f\u8d23\u4eba\u5e74\u7eaa\u504f\u5927\u6216\u504f\u5c0f");
            vo.setRISK_POSITION("1");
            vo.setRESULT_STATUS("1");
            vo.setDEAL_RESULT_DESC("\u67e5\u65e0\u5ba2\u6237\u5e74\u9f84\u4fe1\u606f");
            list.add(vo);
        }
        return flage;
    }
}

