/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.risk.check.accountnum;

import cn.com.yusys.yusp.common.bsp.head.ReqAppHead;
import cn.com.yusys.yusp.common.bsp.head.ReqSysHead;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.mid.common.MidReqLocalHead;
import cn.com.yusys.yusp.mid.common.NcbsServer;
import cn.com.yusys.yusp.mid.constants.BspRespChanMidCode;
import cn.com.yusys.yusp.mid.dao.ChanRiskEventDao;
import cn.com.yusys.yusp.mid.domain.entity.ChanRiskEventEntity;
import cn.com.yusys.yusp.mid.service.T05002000004_05_ReqBody;
import cn.com.yusys.yusp.mid.service.T07003000001_45_BspResp;
import cn.com.yusys.yusp.mid.service.T07003000001_45_ReqBody;
import cn.com.yusys.yusp.mid.service.T07003000001_45_RespBody;
import cn.com.yusys.yusp.mid.service.T11003000007_73_BspResp;
import cn.com.yusys.yusp.mid.service.T11003000007_73_ReqBody;
import cn.com.yusys.yusp.mid.service.T11003000007_73_RespBody;
import cn.com.yusys.yusp.mid.service.T11003000007_73_RespBody_ACCT_ARRAY;
import cn.com.yusys.yusp.risk.annotation.RiskCheck;
import cn.com.yusys.yusp.risk.vo.RiskResultVo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountNumCheck {
    @Autowired
    private ChanRiskEventDao chanRiskEventDao;
    @Autowired
    NcbsServer ncbsServer;

    @RiskCheck(WayCode="checkAccountNum", WayName="\u68c0\u67e5\u6570\u91cf")
    public boolean checkAccountNum(Map<String, Object> map, List<RiskResultVo> list) {
        boolean flage;
        ReqSysHead reqSysHead = (ReqSysHead)map.get("reqSysHead");
        ReqAppHead reqAppHead = (ReqAppHead)map.get("reqAppHead");
        MidReqLocalHead midReqLocalHead = (MidReqLocalHead)map.get("midReqLocalHead");
        T05002000004_05_ReqBody reqBody = (T05002000004_05_ReqBody)map.get("t05002000004_05_reqBody");
        T07003000001_45_ReqBody t07003000001_45_ReqBody = new T07003000001_45_ReqBody();
        t07003000001_45_ReqBody.setCLIENT_NO(reqBody.getCLIENT_NO());
        t07003000001_45_ReqBody.setBASE_ACCT_NO(reqBody.getCARD_NO());
        t07003000001_45_ReqBody.setCCY(reqBody.getCCY());
        t07003000001_45_ReqBody.setDOCUMENT_TYPE(reqBody.getGLOBAL_TYPE());
        t07003000001_45_ReqBody.setDOCUMENT_ID(reqBody.getGLOBAL_ID());
        T07003000001_45_BspResp bspResp = this.ncbsServer.getT07003000001_45_BspResp(reqSysHead, reqAppHead, midReqLocalHead, t07003000001_45_ReqBody);
        T07003000001_45_RespBody respBody = null;
        if (BspRespChanMidCode.SUCCESS.getCode().equals(bspResp.getCode())) {
            respBody = bspResp.getBODY();
            flage = true;
        } else {
            flage = false;
        }
        String operationType = (String)map.get("operationType");
        if (respBody != null) {
            RiskResultVo vo;
            ChanRiskEventEntity entity;
            String numStr = null;
            int cardNum = 0;
            String tranCode = reqBody.getTRANCODE();
            if (operationType.contains("cardCounts") && (cardNum = Integer.parseInt(numStr = respBody.getSETTLE_ACCT_NUM())) > 4) {
                entity = this.chanRiskEventDao.getBlockType("cardCounts", tranCode);
                if (entity == null) {
                    return flage;
                }
                vo = new RiskResultVo();
                vo.setBLOCK_TYPE(entity.getBlockType());
                vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
                vo.setRISK_NAME(entity.getEventName());
                vo.setRISK_POSITION(entity.getRiskPosition());
                vo.setRESULT_STATUS("1");
                vo.setDEAL_RESULT_DESC(entity.getEventSts());
                list.add(vo);
            }
            if (operationType.contains("cardNum") && (cardNum = Integer.parseInt(numStr = respBody.getSETTLE_ACCT_NUM())) >= 10) {
                entity = this.chanRiskEventDao.getBlockType("cardNum", tranCode);
                if (entity == null) {
                    return flage;
                }
                vo = new RiskResultVo();
                vo.setBLOCK_TYPE(entity.getBlockType());
                vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
                vo.setRISK_NAME(entity.getEventName());
                vo.setRISK_POSITION(entity.getRiskPosition());
                vo.setRESULT_STATUS("1");
                vo.setDEAL_RESULT_DESC(entity.getEventSts());
                list.add(vo);
            }
        }
        return flage;
    }

    @RiskCheck(WayCode="corporateBull", WayName="\u540c\u4e00\u5ba2\u6237\u5f00\u7acb4\u5f20\u4ee5\u4e0a\uff08\u542b\uff09\u501f\u8bb0\u5361")
    public boolean checkCorporateBull(Map<String, Object> map, List<RiskResultVo> list) throws Exception {
        boolean flage;
        ReqSysHead reqSysHead = (ReqSysHead)map.get("reqSysHead");
        ReqAppHead reqAppHead = (ReqAppHead)map.get("reqAppHead");
        MidReqLocalHead midReqLocalHead = (MidReqLocalHead)map.get("midReqLocalHead");
        T05002000004_05_ReqBody reqBody = (T05002000004_05_ReqBody)map.get("t05002000004_05_reqBody");
        T11003000007_73_ReqBody t11003000007_73_reqBody = new T11003000007_73_ReqBody();
        if (StringUtils.nonEmpty((CharSequence)reqBody.getCLIENT_NO())) {
            t11003000007_73_reqBody.setCLIENT_NO(reqBody.getCLIENT_NO());
        } else {
            t11003000007_73_reqBody.setDOCUMENT_ID(reqBody.getGLOBAL_ID());
            t11003000007_73_reqBody.setDOCUMENT_TYPE(reqBody.getGLOBAL_TYPE());
        }
        T11003000007_73_BspResp bspResp = this.ncbsServer.getT11003000007_73_BspResp(reqSysHead, reqAppHead, midReqLocalHead, t11003000007_73_reqBody);
        T11003000007_73_RespBody respBody = null;
        if (BspRespChanMidCode.SUCCESS.getCode().equals(bspResp.getCode())) {
            respBody = bspResp.getBODY();
            flage = true;
        } else {
            flage = false;
        }
        Integer num = 0;
        String tranCode = reqBody.getTRANCODE();
        if (respBody != null && CollectionUtils.nonEmpty((Collection)respBody.getACCT_ARRAY())) {
            List acctArrays = respBody.getACCT_ARRAY();
            String status = null;
            for (T11003000007_73_RespBody_ACCT_ARRAY acctArray : acctArrays) {
                status = acctArray.getACCT_STATUS();
                if (!"C".equals(status) && acctArray.getPROD_TYPE().startsWith("120")) {
                    num = num + 1;
                }
                if (num != 3) continue;
                break;
            }
        }
        if (num >= 3) {
            ChanRiskEventEntity entity = this.chanRiskEventDao.getBlockType("corporateBull", tranCode);
            if (entity == null) {
                return flage;
            }
            RiskResultVo vo = new RiskResultVo();
            vo.setBLOCK_TYPE(entity.getBlockType());
            vo.setCLIENT_RISK_LEVEL(entity.getRiskLevel());
            vo.setRISK_NAME(entity.getEventName());
            vo.setRISK_POSITION(entity.getRiskPosition());
            vo.setRESULT_STATUS("1");
            vo.setDEAL_RESULT_DESC(entity.getEventSts());
            list.add(vo);
        }
        return flage;
    }
}

