/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.service;

import cn.com.yusys.yusp.common.bsp.head.RetInfo;
import cn.com.yusys.yusp.mid.constants.BspRespChanMidCode;
import cn.com.yusys.yusp.mid.constants.UnifiedMod;
import cn.com.yusys.yusp.mid.service.ChanUnifiedInterpretationService;
import cn.com.yusys.yusp.mid.vo.channel.ChanUnifiedInterpretationVo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CodeMsgServer {
    @Autowired
    private ChanUnifiedInterpretationService unifiedService;
    private String code;
    private String msgContent;

    public void setCode(String modName) {
        ChanUnifiedInterpretationVo vo = this.unifiedService.getByModName(modName);
        if (vo != null) {
            this.code = vo.getCode();
            this.msgContent = vo.getMsgContent();
        } else {
            BspRespChanMidCode bspRespChanMidCode = BspRespChanMidCode.getChanMidSystemName((String)modName);
            this.code = bspRespChanMidCode.getCode();
            this.msgContent = bspRespChanMidCode.getDesc();
        }
    }

    public List<RetInfo> getSuccesRets() {
        ArrayList<RetInfo> ret = new ArrayList<RetInfo>();
        RetInfo retInfo = new RetInfo();
        ChanUnifiedInterpretationVo vo = this.unifiedService.getByModName(UnifiedMod.SUCCESS.getName());
        if (vo != null) {
            retInfo.setRET_CODE(vo.getCode());
            retInfo.setRET_MSG(vo.getMsgContent());
        } else {
            BspRespChanMidCode bspRespChanMidCode = BspRespChanMidCode.getChanMidSystemName((String)UnifiedMod.SUCCESS.getName());
            retInfo.setRET_CODE(bspRespChanMidCode.getCode());
            retInfo.setRET_MSG(bspRespChanMidCode.getDesc());
        }
        ret.add(retInfo);
        return ret;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }
}

