/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.flow;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.head.ReqSysHead;
import cn.com.yusys.yusp.common.bsp.head.RespSysHead;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.LableType;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.mid.common.MidReqLocalHead;
import cn.com.yusys.yusp.mid.common.MidRespLocalHead;
import cn.com.yusys.yusp.mid.constants.BspRespChanMidSystem;
import cn.com.yusys.yusp.mid.dao.ChanBankTransferInfoDao;
import cn.com.yusys.yusp.mid.domain.entity.ChanBankTransferInfoEntity;
import cn.com.yusys.yusp.mid.log.annotation.FlowLog;
import cn.com.yusys.yusp.mid.service.T03002000024_04_ReqBody;
import cn.com.yusys.yusp.mid.service.T03002000024_04_RespBody;
import cn.com.yusys.yusp.mid.utils.SeqNoUtil;
import cn.com.yusys.yusp.service.CodeMsgServer;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.util.StringUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@CataLog(nodeType=ActionNodeType.BIZ, value="flow/T03002000024_04_Flow", async=false, lableType=LableType.MS)
public class T03002000024_04_Flow {
    @Autowired
    private ChanBankTransferInfoDao chanBankTransferInfoDao;
    @Autowired
    private CodeMsgServer codeMsgServer;
    @Autowired
    private SeqNoUtil seqNoUtil;
    private static final Logger logger = LoggerFactory.getLogger(T03002000024_04_Flow.class);

    @Logic(description="\u884c\u5185\u8f6c\u8d26\u843d\u5730\u6807\u5fd7 \u573a\u666f\u780103002000024 \u670d\u52a1\u7801 04", transaction=true)
    @FlowLog(description="\u884c\u5185\u8f6c\u8d26\u843d\u5730\u6807\u5fd7", serviceCode="03002000024", serviceScene="04", primaryKeyBelongClass=T03002000024_04_Flow.class)
    public BspResp<MidRespLocalHead, T03002000024_04_RespBody> T03002000024_04_Flow(@LogicParam(description="\u62a5\u6587") BspReq<MidReqLocalHead, T03002000024_04_ReqBody> request) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        BspResp resultResp = new BspResp();
        MidRespLocalHead midRespLocalHead = new MidRespLocalHead();
        T03002000024_04_RespBody respBody = new T03002000024_04_RespBody();
        Map bodyMpap = (Map)request.getBODY();
        Map midMap = (Map)request.getLOCAL_HEAD();
        String jsonString = JSON.toJSONString((Object)bodyMpap);
        ReqSysHead reqSysHead = request.getSYS_HEAD();
        T03002000024_04_ReqBody reqBody = (T03002000024_04_ReqBody)JSON.parseObject((String)jsonString, T03002000024_04_ReqBody.class);
        jsonString = JSON.toJSONString((Object)midMap);
        MidReqLocalHead midReqLocalHead = (MidReqLocalHead)JSON.parseObject((String)jsonString, MidReqLocalHead.class);
        BeanUtils.beanCopy((Object)midReqLocalHead, (Object)midRespLocalHead);
        try {
            ChanBankTransferInfoEntity chanBankTransferInfoEntity = new ChanBankTransferInfoEntity();
            chanBankTransferInfoEntity.setTransferId(StringUtils.getUUID());
            chanBankTransferInfoEntity.setFromAcctNo(reqBody.getFROM_ACCT_NO());
            chanBankTransferInfoEntity.setPayPwd(reqBody.getPAY_PASSWORD());
            chanBankTransferInfoEntity.setToAcctNo(reqBody.getTO_ACCT_NO());
            chanBankTransferInfoEntity.setToAcctSerialNo(reqBody.getTO_ACCT_SERIAL_NO());
            chanBankTransferInfoEntity.setToAcctName(reqBody.getTO_ACCT_NAME());
            String transfer_amt = reqBody.getTRANS_AMT();
            Double transferAmt = 0.0;
            if (StringUtil.isNotEmpty((String)transfer_amt)) {
                transferAmt = Double.valueOf(transfer_amt);
            }
            chanBankTransferInfoEntity.setTransferAmt(transferAmt);
            chanBankTransferInfoEntity.setCcy(reqBody.getCCY());
            chanBankTransferInfoEntity.setUsage(reqBody.getUSAGE());
            chanBankTransferInfoEntity.setPostscript(reqBody.getPOSTSCRIPT());
            chanBankTransferInfoEntity.setBeBornReason(reqBody.getBE_BORN_REASON());
            chanBankTransferInfoEntity.setPayeeMobile(reqBody.getPAYEE_MOBILE());
            chanBankTransferInfoEntity.setClientType(reqBody.getCUSTOMER_TYPE());
            chanBankTransferInfoEntity.setNextDayAcctFlag(reqBody.getNEXT_DAY_ACCT_FLAG());
            chanBankTransferInfoEntity.setSmartFlag(reqBody.getSMART_FLAG());
            chanBankTransferInfoEntity.setCreateDt(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
            chanBankTransferInfoEntity.setEntrustDt(reqBody.getCONSIGN_DATE());
            chanBankTransferInfoEntity.setTradeDt(reqSysHead.getTRAN_DATE());
            chanBankTransferInfoEntity.setOrgCode(reqBody.getOPEN_ACCT_BRANCH_ID());
            String seqNo = this.seqNoUtil.createComsumerSeqNo();
            seqNo = seqNo.substring(5);
            chanBankTransferInfoEntity.setTradeSeq(seqNo);
            chanBankTransferInfoEntity.setTransferSts("-1");
            chanBankTransferInfoEntity.setBusinType(reqBody.getCHANNEL_TYPE());
            chanBankTransferInfoEntity.setNetSeqNo(reqSysHead.getCONSUMER_SEQ_NO());
            int num = this.chanBankTransferInfoDao.insert(chanBankTransferInfoEntity);
            if (num <= 0) {
                return BspResp.failure((String)"MID000003", (String)(BspRespChanMidSystem.NCBS_SYSTEM.getSystemCode() + "\u65b0\u589e\u884c\u5185\u8f6c\u8d26\u843d\u5730\u6807\u8bc6\u5931\u8d25"), (Object)midRespLocalHead, null);
            }
            respBody.setACCT_CCY(chanBankTransferInfoEntity.getCcy());
            respBody.setCLIENT_ACCT_NO(chanBankTransferInfoEntity.getFromAcctNo());
            respBody.setOTH_ACCT_SEQ_NO(chanBankTransferInfoEntity.getToAcctSerialNo());
            respBody.setACCT_SERIAL_NO(chanBankTransferInfoEntity.getFromAcctNo());
            respBody.setOTH_ACCT_CCY(chanBankTransferInfoEntity.getCcy());
            respBody.setOTH_CLIENT_ACCT_NO(chanBankTransferInfoEntity.getToAcctNo());
            respBody.setCREATE_DT(chanBankTransferInfoEntity.getCreateDt());
            respBody.setENTRUST_DT(chanBankTransferInfoEntity.getEntrustDt());
            respBody.setTRADE_DT(chanBankTransferInfoEntity.getTradeDt());
            respBody.setUSER_ID(chanBankTransferInfoEntity.getUserId());
            respBody.setUSER_FLOW(chanBankTransferInfoEntity.getUserFlow());
            respBody.setTRADE_SEQ(chanBankTransferInfoEntity.getTradeSeq());
            respBody.setTRANSFER_STS(chanBankTransferInfoEntity.getTransferSts());
            respBody.setBUSIN_TYPE(chanBankTransferInfoEntity.getBusinType());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return BspResp.failure((String)"MID-999999", (String)e.getMessage());
        }
        resultResp.setBODY((Object)respBody);
        resultResp.setLOCAL_HEAD((Object)midRespLocalHead);
        RespSysHead resultHead = resultResp.getSYS_HEAD();
        resultResp.setLOCAL_HEAD((Object)midRespLocalHead);
        resultHead.setRET(this.codeMsgServer.getSuccesRets());
        resultResp.setBODY((Object)respBody);
        return resultResp;
    }
}

