/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.mid.dao.ChanSSealCardInfoDao;
import cn.com.yusys.yusp.mid.dao.SealCardInfoDao;
import cn.com.yusys.yusp.mid.domain.entity.ChanSSealCardInfoEntity;
import cn.com.yusys.yusp.mid.domain.entity.OperGoodsInfoEntity;
import cn.com.yusys.yusp.mid.domain.entity.SealCardInfoEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/seal-card"})
@Api(value="\u5370\u9274\u5361")
public class SealCardController {
    private static final Logger logger = LoggerFactory.getLogger(SealCardController.class);
    @Autowired
    private SealCardInfoDao sealCardInfoDao;
    @Autowired
    private ChanSSealCardInfoDao chanSSealCardInfoDao;

    @PostMapping(value={"/transfer"})
    @ApiOperation(value="\u5370\u9274\u5361")
    public IcspResultDto<Integer> transfer(@RequestBody IcspRequest<OperGoodsInfoEntity> request) throws Exception {
        List chanSealCardList = this.chanSSealCardInfoDao.queryAllByLimit();
        if (CollectionUtils.isEmpty((Collection)chanSealCardList)) {
            return IcspResultDto.failure((String)"500", (String)"chan_s_seal_card\u5370\u9274\u5361\u6570\u636e\u4e3a\u7a7a");
        }
        Map<String, String> branch = SealCardController.getBranch();
        for (ChanSSealCardInfoEntity chanSSealCardInfoEntity : chanSealCardList) {
            SealCardInfoEntity sealCardInfoEntity = new SealCardInfoEntity();
            sealCardInfoEntity.setVoucherNo(chanSSealCardInfoEntity.getVouNo());
            sealCardInfoEntity.setBaseAcctNo(chanSSealCardInfoEntity.getUnitAcct());
            sealCardInfoEntity.setUserId(branch.get(chanSSealCardInfoEntity.getRegOrg()));
            sealCardInfoEntity.setCreateDate(StringUtils.nonEmpty((CharSequence)chanSSealCardInfoEntity.getRegDate()) ? chanSSealCardInfoEntity.getRegDate().replaceAll("-", "") : null);
            sealCardInfoEntity.setAcctName(chanSSealCardInfoEntity.getAcctName());
            sealCardInfoEntity.setOrgId(chanSSealCardInfoEntity.getRegOrg());
            sealCardInfoEntity.setVoucherStatus(SealCardController.statusTrans(chanSSealCardInfoEntity.getStatus()));
            try {
                this.sealCardInfoDao.insert(sealCardInfoEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return IcspResultDto.success((Object)1);
    }

    public static Map<String, String> getBranch() throws Exception {
        ClassPathResource fileRource = new ClassPathResource("yjk.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileRource.getInputStream()));
        HashMap<String, String> reMap = new HashMap<String, String>();
        String str = null;
        while ((str = bufferedReader.readLine()) != null) {
            System.out.println(str);
            String[] split = str.split(",");
            reMap.put(split[0], split[1]);
        }
        bufferedReader.close();
        return reMap;
    }

    public static String statusTrans(String s) {
        if (StringUtils.nonEmpty((CharSequence)s)) {
            if ("1".equals(s)) {
                return "ACT";
            }
            if ("2".equals(s)) {
                return "DES";
            }
            if ("3".equals(s)) {
                return "CAN";
            }
            return "";
        }
        return "";
    }
}

