/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.mid.bo.channel.ChanProgListBo;
import cn.com.yusys.yusp.mid.constants.enums.ChanEnums;
import cn.com.yusys.yusp.mid.domain.query.ChanProgListQuery;
import cn.com.yusys.yusp.mid.service.ChanProgListService;
import cn.com.yusys.yusp.mid.vo.channel.ChanProgListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/prog-list"})
@Api(tags={"ProgListAdminController"}, description="\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406")
public class ProgListAdminController {
    private static final Logger logger = LoggerFactory.getLogger(ProgListAdminController.class);
    @Autowired
    private ChanProgListService chanProgListService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ChanProgListBo> request) throws Exception {
        ChanProgListBo chanProgListBo = (ChanProgListBo)request.getBody();
        int result = this.chanProgListService.create(chanProgListBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<ChanProgListVo> show(@RequestBody IcspRequest<ChanProgListQuery> request) throws Exception {
        ChanProgListVo result = this.chanProgListService.show((ChanProgListQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanProgListVo>> index(@RequestBody IcspRequest<ChanProgListQuery> request) throws Exception {
        if (((ChanProgListQuery)request.getBody()).getThrowChan().length == 0) {
            ((ChanProgListQuery)request.getBody()).setThrowChan(null);
        }
        List list = this.chanProgListService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanProgListVo>> list(@RequestBody IcspRequest<ChanProgListQuery> request) throws Exception {
        List list = this.chanProgListService.list(request.getQueryModel());
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ChanProgListBo> request) throws Exception {
        int result = this.chanProgListService.update((ChanProgListBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6e20\u9053\u8282\u76ee\u5355\u7ba1\u7406")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ChanProgListBo> request) throws Exception {
        int result = this.chanProgListService.delete(((ChanProgListBo)request.getBody()).getProgId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/commit-approve"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838")
    public IcspResultDto<Integer> commitApprove(@RequestBody IcspRequest<List<ChanProgListBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProgListService.changeSts((List)request.getBody(), ChanEnums.PROG_STATUS_UNCHECKED.getCode());
        return resultDto;
    }

    @PostMapping(value={"/approve-pass"})
    @ApiOperation(value="\u5ba1\u6838\u901a\u8fc7")
    public IcspResultDto<Integer> approvePass(@RequestBody IcspRequest<List<ChanProgListBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProgListService.changeSts((List)request.getBody(), ChanEnums.PROG_STATUS_CHECKED.getCode());
        return resultDto;
    }

    @PostMapping(value={"/approve-reject"})
    @ApiOperation(value="\u5ba1\u6838\u62d2\u7edd")
    public IcspResultDto<Integer> approveReject(@RequestBody IcspRequest<List<ChanProgListBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProgListService.changeSts((List)request.getBody(), ChanEnums.PROG_STATUS_REJECT.getCode());
        return resultDto;
    }

    @PostMapping(value={"/on-shelf"})
    @ApiOperation(value="\u4e0a\u67b6")
    public IcspResultDto<Integer> onShelf(@RequestBody IcspRequest<List<ChanProgListBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProgListService.changeSts((List)request.getBody(), ChanEnums.PROG_STATUS_ONSHELF.getCode());
        return resultDto;
    }

    @PostMapping(value={"/off-shelf"})
    @ApiOperation(value="\u4e0b\u67b6")
    public IcspResultDto<Integer> offShelf(@RequestBody IcspRequest<List<ChanProgListBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProgListService.changeSts((List)request.getBody(), ChanEnums.PROG_STATUS_OFFSHELF.getCode());
        return resultDto;
    }
}

