/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.mid.bo.product.ChanProductRuleBo;
import cn.com.yusys.yusp.mid.constants.enums.ProductEnums;
import cn.com.yusys.yusp.mid.domain.query.ChanProductRuleQuery;
import cn.com.yusys.yusp.mid.service.ChanProductRuleService;
import cn.com.yusys.yusp.mid.vo.product.ChanProductRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/product-rule"})
@Api(tags={"ProductRuleAdminController"}, description="\u4ea7\u54c1\u89c4\u5219")
public class ProductRuleAdminController {
    private static final Logger logger = LoggerFactory.getLogger(ProductRuleAdminController.class);
    @Autowired
    private ChanProductRuleService chanProductRuleService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u4ea7\u54c1\u89c4\u5219")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ChanProductRuleBo> request) throws Exception {
        int result = this.chanProductRuleService.create((ChanProductRuleBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u4ea7\u54c1\u89c4\u5219\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<ChanProductRuleVo> show(@RequestBody IcspRequest<ChanProductRuleQuery> request) throws Exception {
        ChanProductRuleVo result = this.chanProductRuleService.show((ChanProductRuleQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u4ea7\u54c1\u89c4\u5219\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanProductRuleVo>> index(@RequestBody IcspRequest<ChanProductRuleQuery> request) throws Exception {
        List list = this.chanProductRuleService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u4ea7\u54c1\u89c4\u5219\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanProductRuleVo>> list(@RequestBody IcspRequest<ChanProductRuleQuery> request) throws Exception {
        List list = this.chanProductRuleService.list(request.getQueryModel());
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u4ea7\u54c1\u89c4\u5219")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ChanProductRuleBo> request) throws Exception {
        int result = this.chanProductRuleService.delete(((ChanProductRuleBo)request.getBody()).getRuleId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/maintain"})
    @ApiOperation(value="\u4ea7\u54c1\u89c4\u5219\u7ef4\u62a4")
    public IcspResultDto<Integer> maintain(@RequestBody IcspRequest<ChanProductRuleBo> request) throws Exception {
        int result = this.chanProductRuleService.maintain((ChanProductRuleBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/commit-approve"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838")
    public IcspResultDto<Integer> commitApprove(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_ON_SHELF_STATUS_UNCHECKED.getCode());
        return resultDto;
    }

    @PostMapping(value={"/approve-pass"})
    @ApiOperation(value="\u5ba1\u6838\u901a\u8fc7")
    public IcspResultDto<Integer> approvePass(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_ON_SHELF_STATUS_CHECKED.getCode());
        return resultDto;
    }

    @PostMapping(value={"/approve-reject"})
    @ApiOperation(value="\u5ba1\u6838\u62d2\u7edd")
    public IcspResultDto<Integer> approveReject(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_ON_SHELF_STATUS_REJECT.getCode());
        return resultDto;
    }

    @PostMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03")
    public IcspResultDto<Integer> publish(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_STATUS_PUBLISH.getCode());
        return resultDto;
    }

    @PostMapping(value={"/cancel-publish"})
    @ApiOperation(value="\u53d6\u6d88\u53d1\u5e03")
    public IcspResultDto<Integer> cancelPublish(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_STATUS_CANCELPUBLISH.getCode());
        return resultDto;
    }

    @PostMapping(value={"/on-shelf"})
    @ApiOperation(value="\u4e0a\u67b6")
    public IcspResultDto<Integer> onShelf(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_ON_SHELF_STATUS_ONSHELF.getCode());
        return resultDto;
    }

    @PostMapping(value={"/off-shelf"})
    @ApiOperation(value="\u4e0b\u67b6")
    public IcspResultDto<Integer> offShelf(@RequestBody IcspRequest<List<ChanProductRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanProductRuleService.changeSts((List)request.getBody(), ProductEnums.RULE_ON_SHELF_STATUS_OFFSHELF.getCode());
        return resultDto;
    }
}

