/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.job.mid.utils.GsonUtils;
import cn.com.yusys.yusp.mid.bo.product.ChanProductPackBo;
import cn.com.yusys.yusp.mid.bo.product.ChanProductPackNotifyBo;
import cn.com.yusys.yusp.mid.domain.query.ChanProductPackQuery;
import cn.com.yusys.yusp.mid.domain.query.ChanProductRuleQuery;
import cn.com.yusys.yusp.mid.dto.ChanProductPackDto;
import cn.com.yusys.yusp.mid.dto.ChanProductPackMappingDto;
import cn.com.yusys.yusp.mid.dto.PackGroupDto;
import cn.com.yusys.yusp.mid.dto.PackProductDto;
import cn.com.yusys.yusp.mid.service.ChanFundInfoService;
import cn.com.yusys.yusp.mid.service.ChanProductInfoService;
import cn.com.yusys.yusp.mid.service.ChanProductPackService;
import cn.com.yusys.yusp.mid.vo.product.ChanProductPackVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/product-pack"})
@Api(tags={"ProductPackAdminController"}, description="\u4ea7\u54c1\u5305\u88c5")
public class ProductPackAdminController {
    private static final Logger logger = LoggerFactory.getLogger(ProductPackAdminController.class);
    @Autowired
    private ChanProductPackService chanProductPackService;
    @Autowired
    private ChanProductInfoService chanProductInfoService;
    @Autowired
    private ChanFundInfoService chanFundInfoService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u4ea7\u54c1\u5305\u88c5")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ChanProductPackBo> request) throws Exception {
        int result = this.chanProductPackService.create((ChanProductPackBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u4ea7\u54c1\u5305\u88c5\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<ChanProductPackDto> show(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        ChanProductPackDto result = this.chanProductPackService.show((ChanProductPackQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u4ea7\u54c1\u5305\u88c5\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<PackProductDto>> index(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        if (((ChanProductPackQuery)request.getBody()).getObjSts() != null && ((ChanProductPackQuery)request.getBody()).getObjSts().length == 0) {
            ((ChanProductPackQuery)request.getBody()).setObjSts(null);
        }
        List list = this.chanProductPackService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u4ea7\u54c1\u5305\u88c5\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanProductPackVo>> list(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        List list = this.chanProductPackService.list(request.getQueryModel());
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u4ea7\u54c1\u5305\u88c5")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ChanProductPackBo> request) throws Exception {
        int result = this.chanProductPackService.update((ChanProductPackBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u4ea7\u54c1\u5305\u88c5")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ChanProductPackBo> request) throws Exception {
        int result = this.chanProductPackService.delete(((ChanProductPackBo)request.getBody()).getPackId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/maintain"})
    @ApiOperation(value="\u4ea7\u54c1\u5305\u88c5\u7ef4\u62a4")
    public IcspResultDto<Integer> maintain(@RequestBody IcspRequest<ChanProductPackBo> request) throws Exception {
        int result = this.chanProductPackService.maintain((ChanProductPackBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index-product-group"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u7d44\u5408\u7522\u54c1")
    public IcspResultDto<List<PackGroupDto>> indexProductGroup(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        List result = this.chanProductPackService.indexProductGroup(request.getQueryModel());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show-product-group"})
    @ApiOperation(value="\u5355\u4e2a\u67e5\u8be2\u6240\u6709\u7d44\u5408\u7522\u54c1")
    public IcspResultDto<PackGroupDto> showProductGroup(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        PackGroupDto result = this.chanProductPackService.showProductGroup(request.getQueryModel());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/update-product-group"})
    @ApiOperation(value="\u66f4\u65b0\u7d44\u5408\u7522\u54c1")
    public IcspResultDto<Integer> updateProductGroup(@RequestBody IcspRequest<PackGroupDto> request) throws Exception {
        int result = this.chanProductPackService.updateProductGroup((PackGroupDto)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/create-product-group"})
    @ApiOperation(value="\u65b0\u589e\u7d44\u5408\u7522\u54c1")
    public IcspResultDto<Integer> createProductGroup(@RequestBody IcspRequest<ChanProductPackBo> request) throws Exception {
        int result = this.chanProductPackService.createProductGroup((ChanProductPackBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/choose-product"})
    @ApiOperation(value="\u9009\u62e9\u6dfb\u52a0\u4ea7\u54c1")
    public IcspResultDto<List<ChanProductPackMappingDto>> chooseProduct(@RequestBody IcspRequest<ChanProductRuleQuery> request) throws Exception {
        List result = this.chanProductPackService.chooseProduct(request.getQueryModel());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/choose-product-no-group"})
    @ApiOperation(value="\u9009\u62e9\u4ea7\u54c1-\u4e0d\u5305\u542b\u7ec4\u5408\u4ea7\u54c1")
    public IcspResultDto<List<ChanProductPackMappingDto>> chooseProductNoGroup(@RequestBody IcspRequest<ChanProductRuleQuery> request) throws Exception {
        List result = this.chanProductPackService.chooseProductNoGroup(request.getQueryModel());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete-product-group"})
    @ApiOperation(value="\u5220\u9664\u7ec4\u5408\u4ea7\u54c1")
    public IcspResultDto<Integer> deleteProductGroup(@RequestBody IcspRequest<PackGroupDto> request) throws Exception {
        int result = this.chanProductPackService.delete(((PackGroupDto)request.getBody()).getPackId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index-product"})
    @ApiOperation(value="\u4ea7\u54c1\u67e5\u8be2")
    public IcspResultDto<List<PackProductDto>> indexProduct(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        return this.chanProductPackService.indexProduct(request.getQueryModel());
    }

    @PostMapping(value={"/index-cust-group-product"})
    @ApiOperation(value="\u672a\u5173\u8054\u8425\u9500\u4ea7\u54c1\u67e5\u8be2")
    public IcspResultDto<List<PackProductDto>> indexCustGroupProduct(@RequestBody IcspRequest<ChanProductPackQuery> request) throws Exception {
        List result = this.chanProductPackService.indexCustGroupProduct(request.getQueryModel());
        return IcspResultDto.success((Object)result, (long)result.size());
    }

    @PostMapping(value={"/update-rule-sts"})
    @ApiOperation(value="\u53d1\u5e03\u4ea7\u54c1")
    public IcspResultDto<Integer> updateRuleSts(@RequestBody IcspRequest<PackProductDto> request) throws Exception {
        int result = this.chanProductPackService.updateRuleSts((PackProductDto)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/update-pack-sts"})
    @ApiOperation(value="\u4e0b\u67b6\u7f16\u8f91")
    public IcspResultDto<Integer> updatePackSts(@RequestBody IcspRequest<PackProductDto> request) throws Exception {
        int result = this.chanProductPackService.updatePackSts((PackProductDto)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/notify-sync"})
    @ApiOperation(value="\u4ea7\u54c1\u901a\u77e5\u540c\u6b65")
    public IcspResultDto<Boolean> notifySync(@RequestBody IcspRequest<ChanProductPackNotifyBo> request) throws Exception {
        boolean flag = false;
        logger.info("\u4ea7\u54c1\u901a\u77e5\u540c\u6b65\uff1a{}", (Object)GsonUtils.getJsonStr((Object)request.getBody()));
        ChanProductPackNotifyBo chanProductPackNotifyBo = (ChanProductPackNotifyBo)request.getBody();
        if (chanProductPackNotifyBo == null) {
            return IcspResultDto.failure((String)"MID000001", (String)"ChanProductPackNotifyBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tranCode = chanProductPackNotifyBo.getTranCode();
        String productCode = chanProductPackNotifyBo.getProductCode();
        if (StringUtils.isEmpty((CharSequence)tranCode)) {
            return IcspResultDto.failure((String)"MID000001", (String)"tranCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)productCode)) {
            return IcspResultDto.failure((String)"MID000001", (String)"productCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("T222".equals(tranCode)) {
            flag = this.chanProductInfoService.syncByCode(productCode);
        } else if ("T220".equals(tranCode)) {
            flag = this.chanFundInfoService.syncByCode(productCode);
        }
        return IcspResultDto.success((Object)flag);
    }
}

