/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.mid.bo.cust.ChanCustGroupMappingBo;
import cn.com.yusys.yusp.mid.domain.query.ChanCustGroupMappingQuery;
import cn.com.yusys.yusp.mid.domain.vo.FileUploadDTO;
import cn.com.yusys.yusp.mid.service.ChanCustGroupMappingService;
import cn.com.yusys.yusp.mid.utils.ExcelUtils;
import cn.com.yusys.yusp.mid.vo.cust.ChanCustGroupMappingVo;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/admin/import"})
@Api(tags={"ImportCustController"}, description="\u5ba2\u6237\u5bfc\u5165")
public class ImportCustController {
    @Autowired
    private ChanCustGroupMappingService chanCustGroupMappingService;
    private static final Logger logger = LoggerFactory.getLogger(ImportCustController.class);

    @PostMapping(value={"/cust-mapping"})
    public IcspResultDto<String> importCustMapping(@Valid @ModelAttribute FileUploadDTO fileUploadDTO) throws Exception {
        MultipartFile file = fileUploadDTO.getFile();
        String custGroupId = fileUploadDTO.getCustGroupId();
        Integer success = 0;
        Integer fail = 0;
        Integer total = 0;
        int num = 0;
        ArrayList<List> not = new ArrayList<List>();
        try {
            if (!ExcelUtils.validateExcel((String)file.getOriginalFilename())) {
                return IcspResultDto.failure((String)"500", (String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            }
            List importExcelData = ExcelUtils.getUploadExcelData((MultipartFile)file);
            if (importExcelData != null && importExcelData.size() > 0) {
                ChanCustGroupMappingQuery chanCustGroupMappingQuery = new ChanCustGroupMappingQuery();
                chanCustGroupMappingQuery.setCustGroupId(custGroupId);
                ChanCustGroupMappingBo chanCustGroupMappingBo = null;
                String custId = null;
                String custName = null;
                String globalType = null;
                String globalId = null;
                String custType = null;
                List list = null;
                total = importExcelData.size() - 1;
                for (int i = 1; i < importExcelData.size(); ++i) {
                    Integer n;
                    Integer n2;
                    Integer n3;
                    list = (List)importExcelData.get(i);
                    custId = (String)list.get(0);
                    custName = (String)list.get(1);
                    globalType = (String)list.get(2);
                    globalId = (String)list.get(3);
                    custType = (String)list.get(4);
                    if (StringUtils.isEmpty((CharSequence)custId) || StringUtils.isEmpty((CharSequence)custName) || StringUtils.isEmpty((CharSequence)globalType) || StringUtils.isEmpty((CharSequence)globalId) || StringUtils.isEmpty((CharSequence)custType)) {
                        logger.error("\u5ba2\u6237\u5bfc\u5165\uff0c\u7f3a\u5931\u5fc5\u586b\u9879");
                        n3 = fail;
                        n2 = fail = Integer.valueOf(fail + 1);
                        continue;
                    }
                    if (!ImportCustController.isNum(custId)) {
                        logger.error("\u5ba2\u6237\u5bfc\u5165\uff0c\u5ba2\u6237\u53f7\u4e0d\u5408\u6cd5\uff1a{}", (Object)custId);
                        n3 = fail;
                        n2 = fail = Integer.valueOf(fail + 1);
                        continue;
                    }
                    if (!ImportCustController.isNumAndAlphabet(globalId)) {
                        logger.error("\u5ba2\u6237\u5bfc\u5165\uff0c\u8bc1\u4ef6\u53f7\u4e0d\u5408\u6cd5\uff1a{}", (Object)globalId);
                        n3 = fail;
                        n2 = fail = Integer.valueOf(fail + 1);
                        continue;
                    }
                    chanCustGroupMappingQuery.setCustId(custId);
                    chanCustGroupMappingQuery.setCustGroupId(custGroupId);
                    ChanCustGroupMappingVo custGroupMappingVo = this.chanCustGroupMappingService.getChanCustGroupMapping(chanCustGroupMappingQuery);
                    chanCustGroupMappingBo = new ChanCustGroupMappingBo();
                    chanCustGroupMappingBo.setCustGroupId(custGroupId);
                    chanCustGroupMappingBo.setCustId(custId);
                    chanCustGroupMappingBo.setCustName(custName);
                    chanCustGroupMappingBo.setCustType(custType);
                    chanCustGroupMappingBo.setGlobalId(globalId);
                    chanCustGroupMappingBo.setGlobalType(globalType);
                    if (custGroupMappingVo == null) {
                        num = this.chanCustGroupMappingService.create(chanCustGroupMappingBo);
                    } else {
                        chanCustGroupMappingBo.setCustGroupId(custGroupMappingVo.getCustGroupId());
                        num = this.chanCustGroupMappingService.update(chanCustGroupMappingBo);
                    }
                    if (num > 0) {
                        n2 = success;
                        n = success = Integer.valueOf(success + 1);
                        continue;
                    }
                    n2 = fail;
                    n = fail = Integer.valueOf(fail + 1);
                    not.add(list);
                }
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        String msg = "\u5bfc\u5165\u5b8c\u6210\uff01\u603b\u6570\uff1a" + total + "\uff0c\u6210\u529f\u5bfc\u5165\uff1a" + success + "\uff0c\u5931\u8d25\uff1a" + fail;
        if (num == 0) {
            return IcspResultDto.failure((String)"100", (String)"\u5bfc\u5165\u5931\u8d25");
        }
        return IcspResultDto.successMsg((String)msg);
    }

    public static boolean isNum(String str) {
        Pattern pattern = Pattern.compile("^-?[0-9]+");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumAndAlphabet(String str) {
        Pattern pattern = Pattern.compile("^-?[A-Za-z0-9]+");
        return pattern.matcher(str).matches();
    }
}

