/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.mid.bo.ChanCardInfoBo;
import cn.com.yusys.yusp.mid.bo.ChanUnionPayOrgBo;
import cn.com.yusys.yusp.mid.domain.query.ChanCardInfoQuery;
import cn.com.yusys.yusp.mid.domain.query.ChanUnionPayOrgQuery;
import cn.com.yusys.yusp.mid.domain.vo.FileUploadDTO;
import cn.com.yusys.yusp.mid.service.ChanCardInfoService;
import cn.com.yusys.yusp.mid.service.ChanUnionPayOrgService;
import cn.com.yusys.yusp.mid.utils.ExcelUtils;
import cn.com.yusys.yusp.mid.vo.ChanCardInfoVo;
import cn.com.yusys.yusp.mid.vo.ChanUnionPayOrgVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/admin/import"})
public class ImporCardInfoController {
    private static final Logger logger = LoggerFactory.getLogger(ImporCardInfoController.class);
    @Autowired
    private ChanCardInfoService chanCardInfoService;
    @Autowired
    private ChanUnionPayOrgService chanUnionPayOrgService;
    public static final int INIT_ROW = 4;

    @PostMapping(value={"/card-info"})
    public IcspResultDto<String> importCardInfo(@Valid @ModelAttribute FileUploadDTO fileUploadDTO) throws Exception {
        MultipartFile file = fileUploadDTO.getFile();
        Integer success = 0;
        Integer fail = 0;
        Integer total = 0;
        int num = 0;
        ArrayList<List> not = new ArrayList<List>();
        try {
            if (!ExcelUtils.validateExcel((String)file.getOriginalFilename())) {
                return IcspResultDto.failure((String)"500", (String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            }
            List importExcelData = ExcelUtils.getUploadExcelData((MultipartFile)file);
            if (CollectionUtils.nonEmpty((Collection)importExcelData) && importExcelData.size() > 4) {
                ChanCardInfoQuery chanCardInfoQuery = new ChanCardInfoQuery();
                ChanCardInfoBo chanCardInfoBo = null;
                String cardBin = null;
                String orgNo = null;
                String bkNo = null;
                String cardLen = null;
                String cardType = null;
                String cardName = null;
                String bkName = null;
                String contrWord = null;
                String bkAndOrgNo = null;
                List list = null;
                total = importExcelData.size() - 4;
                for (int i = 4; i < importExcelData.size(); ++i) {
                    Integer n;
                    Integer n2;
                    Integer n3;
                    list = (List)importExcelData.get(i);
                    bkAndOrgNo = (String)list.get(0);
                    if (StringUtils.isEmpty((CharSequence)bkAndOrgNo)) {
                        Integer n4 = fail;
                        n3 = fail = Integer.valueOf(fail + 1);
                        continue;
                    }
                    String[] bkAndOrgNoArr = bkAndOrgNo.split("\\(");
                    cardBin = (String)list.get(13);
                    orgNo = bkAndOrgNoArr[1].substring(0, bkAndOrgNoArr[1].length() - 2);
                    cardLen = (String)list.get(8);
                    cardType = (String)list.get(15);
                    cardName = (String)list.get(1);
                    bkName = bkAndOrgNoArr[0];
                    if (StringUtils.isEmpty((CharSequence)cardBin) || StringUtils.isEmpty((CharSequence)orgNo) || StringUtils.isEmpty((CharSequence)cardLen) || StringUtils.isEmpty((CharSequence)cardType) || StringUtils.isEmpty((CharSequence)cardName) || StringUtils.isEmpty((CharSequence)bkName)) {
                        n3 = fail;
                        n2 = fail = Integer.valueOf(fail + 1);
                        continue;
                    }
                    chanCardInfoBo = new ChanCardInfoBo();
                    chanCardInfoBo.setCardBin(cardBin);
                    chanCardInfoBo.setOrgNo(orgNo);
                    chanCardInfoBo.setBkNo(bkNo);
                    chanCardInfoBo.setCardLen(cardLen);
                    chanCardInfoBo.setCardType(cardType);
                    chanCardInfoBo.setCardName(cardName);
                    chanCardInfoBo.setBkName(bkName);
                    chanCardInfoBo.setContrWord(contrWord);
                    chanCardInfoQuery.setCardBin(cardBin);
                    ChanCardInfoVo chanCardInfoVo = this.chanCardInfoService.show(chanCardInfoQuery);
                    if (chanCardInfoVo != null) {
                        n2 = fail;
                        n = fail = Integer.valueOf(fail + 1);
                        not.add(list);
                        continue;
                    }
                    num = this.chanCardInfoService.create(chanCardInfoBo);
                    if (num > 0) {
                        n2 = success;
                        n = success = Integer.valueOf(success + 1);
                        ChanUnionPayOrgQuery chanUnionPayOrgQuery = new ChanUnionPayOrgQuery();
                        chanUnionPayOrgQuery.setOrgId(orgNo);
                        ChanUnionPayOrgVo chanUnionPayOrgVo = this.chanUnionPayOrgService.show(chanUnionPayOrgQuery);
                        if (chanUnionPayOrgVo != null) continue;
                        ChanUnionPayOrgBo chanUnionPayOrgBo = new ChanUnionPayOrgBo();
                        chanUnionPayOrgBo.setOrgId(orgNo);
                        chanUnionPayOrgBo.setOrgCode(orgNo);
                        chanUnionPayOrgBo.setOrgName(bkName);
                        this.chanUnionPayOrgService.create(chanUnionPayOrgBo);
                        continue;
                    }
                    n2 = fail;
                    n = fail = Integer.valueOf(fail + 1);
                    not.add(list);
                }
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        if (num == 0) {
            return IcspResultDto.failure((String)"100", (String)"\u5bfc\u5165\u5931\u8d25");
        }
        String msg = "\u5bfc\u5165\u5b8c\u6210\uff01\u603b\u6570\uff1a" + total + "\uff0c\u6210\u529f\u5bfc\u5165\uff1a" + success + "\uff0c\u5931\u8d25\uff1a" + fail;
        return IcspResultDto.successMsg((String)msg);
    }
}

