/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.mid.bo.ChanCouponInfoBo;
import cn.com.yusys.yusp.mid.constants.enums.CouponEnums;
import cn.com.yusys.yusp.mid.domain.query.ChanCouponInfoQuery;
import cn.com.yusys.yusp.mid.service.ChanCouponInfoService;
import cn.com.yusys.yusp.mid.vo.ChanCouponInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/chan-coupon-info"})
@Api(value="\u5361\u5238\u4fe1\u606f")
public class CouponInfoAdminController {
    private static final Logger logger = LoggerFactory.getLogger(CouponInfoAdminController.class);
    @Autowired
    private ChanCouponInfoService chanCouponInfoService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u5361\u5238\u4fe1\u606f")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ChanCouponInfoBo> request) throws Exception {
        ChanCouponInfoBo chanCouponInfoBo = (ChanCouponInfoBo)request.getBody();
        int result = this.chanCouponInfoService.create(chanCouponInfoBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u5361\u5238\u4fe1\u606f\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<ChanCouponInfoVo> show(@RequestBody IcspRequest<ChanCouponInfoQuery> request) throws Exception {
        ChanCouponInfoVo result = this.chanCouponInfoService.show((ChanCouponInfoQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u5361\u5238\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanCouponInfoVo>> index(@RequestBody IcspRequest<ChanCouponInfoQuery> request) throws Exception {
        List list = this.chanCouponInfoService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5361\u5238\u4fe1\u606f\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanCouponInfoVo>> list(@RequestBody IcspRequest<ChanCouponInfoQuery> request) throws Exception {
        List list = this.chanCouponInfoService.list(request.getQueryModel());
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5361\u5238\u4fe1\u606f")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ChanCouponInfoBo> request) throws Exception {
        ChanCouponInfoBo chanCouponInfoBo = (ChanCouponInfoBo)request.getBody();
        int result = this.chanCouponInfoService.update(chanCouponInfoBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5361\u5238\u4fe1\u606f")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ChanCouponInfoBo> request) throws Exception {
        ChanCouponInfoBo chanCouponInfoBo = (ChanCouponInfoBo)request.getBody();
        int result = this.chanCouponInfoService.delete(chanCouponInfoBo.getCouponId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/commit-approve"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838")
    public IcspResultDto<Integer> commitApprove(@RequestBody IcspRequest<List<ChanCouponInfoBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanCouponInfoService.changeSts((List)request.getBody(), CouponEnums.STATUS_UNCHECKED.getCode());
        return resultDto;
    }

    @PostMapping(value={"/approve-pass"})
    @ApiOperation(value="\u5ba1\u6838\u901a\u8fc7")
    public IcspResultDto<Integer> approvePass(@RequestBody IcspRequest<List<ChanCouponInfoBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanCouponInfoService.changeSts((List)request.getBody(), CouponEnums.STATUS_CHECKED.getCode());
        return resultDto;
    }

    @PostMapping(value={"/approve-reject"})
    @ApiOperation(value="\u5ba1\u6838\u62d2\u7edd")
    public IcspResultDto<Integer> approveReject(@RequestBody IcspRequest<List<ChanCouponInfoBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanCouponInfoService.changeSts((List)request.getBody(), CouponEnums.STATUS_REJECT.getCode());
        return resultDto;
    }

    @PostMapping(value={"/enable"})
    @ApiOperation(value="\u542f\u7528")
    public IcspResultDto<Integer> enable(@RequestBody IcspRequest<List<ChanCouponInfoBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanCouponInfoService.changeSts((List)request.getBody(), CouponEnums.STATUS_ENABLE.getCode());
        return resultDto;
    }

    @PostMapping(value={"/unable"})
    @ApiOperation(value="\u505c\u7528")
    public IcspResultDto<Integer> unable(@RequestBody IcspRequest<List<ChanCouponInfoBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanCouponInfoService.changeSts((List)request.getBody(), CouponEnums.STATUS_UNABLE.getCode());
        return resultDto;
    }
}

