/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.mid.bo.ChanRiskRuleBo;
import cn.com.yusys.yusp.mid.constants.enums.ChanEnums;
import cn.com.yusys.yusp.mid.domain.query.ChanRiskRuleQuery;
import cn.com.yusys.yusp.mid.service.ChanRiskRuleService;
import cn.com.yusys.yusp.mid.vo.ChanRiskRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/chan-risk-rule"})
@Api(tags={"ChanRiskRuleResource"}, description="\u98ce\u9669\u89c4\u5219\u914d\u7f6e")
public class ChanRiskRuleController {
    private static final Logger logger = LoggerFactory.getLogger(ChanRiskRuleController.class);
    @Autowired
    private ChanRiskRuleService chanRiskRuleService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u98ce\u9669\u89c4\u5219\u914d\u7f6e")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ChanRiskRuleBo> request) throws Exception {
        int result = this.chanRiskRuleService.create((ChanRiskRuleBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u98ce\u9669\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<ChanRiskRuleVo> show(@RequestBody IcspRequest<ChanRiskRuleQuery> request) throws Exception {
        ChanRiskRuleVo result = this.chanRiskRuleService.show((ChanRiskRuleQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u98ce\u9669\u89c4\u5219\u914d\u7f6e\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanRiskRuleVo>> index(@RequestBody IcspRequest<ChanRiskRuleQuery> request) throws Exception {
        List list = this.chanRiskRuleService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u98ce\u9669\u89c4\u5219\u914d\u7f6e\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanRiskRuleVo>> list(@RequestBody IcspRequest<ChanRiskRuleQuery> request) throws Exception {
        List list = this.chanRiskRuleService.list(request.getQueryModel());
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u98ce\u9669\u89c4\u5219\u914d\u7f6e")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ChanRiskRuleBo> request) throws Exception {
        int result = this.chanRiskRuleService.update((ChanRiskRuleBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u98ce\u9669\u89c4\u5219\u914d\u7f6e")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ChanRiskRuleBo> request) throws Exception {
        int result = this.chanRiskRuleService.delete(((ChanRiskRuleBo)request.getBody()).getRuleId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/unable"})
    @ApiOperation(value="\u505c\u7528")
    public IcspResultDto<Integer> unable(@RequestBody IcspRequest<List<ChanRiskRuleBo>> request) throws Exception {
        IcspResultDto resultDto = this.chanRiskRuleService.changeSts((List)request.getBody(), ChanEnums.STATUS_UNABLE.getCode());
        return resultDto;
    }

    @PostMapping(value={"/list-delete"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u98ce\u9669\u89c4\u5219\u914d\u7f6e")
    public IcspResultDto<Integer> batchDelete(@RequestBody IcspRequest<Map<String, String[]>> request) throws Exception {
        String[] ruleIds = (String[])((Map)request.getBody()).get("ruleIds");
        int result = this.chanRiskRuleService.batchDelete(ruleIds);
        return IcspResultDto.success((Object)result);
    }
}

