/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.mid.bo.ChanOrderByHandBo;
import cn.com.yusys.yusp.mid.bo.ChanOrderInfoBo;
import cn.com.yusys.yusp.mid.domain.query.ChanOrderInfoQuery;
import cn.com.yusys.yusp.mid.service.ChanOrderInfoService;
import cn.com.yusys.yusp.mid.vo.ChanOrderInfoVo;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/order-info"})
@Api(value="\u8ba2\u5355\u4fe1\u606f")
public class ChanOrderInfoAdminController {
    private static final Logger logger = LoggerFactory.getLogger(ChanOrderInfoAdminController.class);
    @Autowired
    private ChanOrderInfoService chanOrderInfoService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u65b0\u589e\u8ba2\u5355\u4fe1\u606f")
    public IcspResultDto<Integer> create(@RequestBody IcspRequest<ChanOrderInfoBo> request) throws Exception {
        ChanOrderInfoBo chanOrderInfoBo = (ChanOrderInfoBo)request.getBody();
        int result = this.chanOrderInfoService.create(chanOrderInfoBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/show"})
    @ApiOperation(value="\u8ba2\u5355\u4fe1\u606f\u4fe1\u606f\u67e5\u8be2")
    public IcspResultDto<ChanOrderInfoVo> show(@RequestBody IcspRequest<ChanOrderInfoQuery> request) throws Exception {
        ChanOrderInfoVo result = this.chanOrderInfoService.show((ChanOrderInfoQuery)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/index"})
    @ApiOperation(value="\u8ba2\u5355\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanOrderInfoVo>> index(@RequestBody IcspRequest<ChanOrderInfoQuery> request) throws Exception {
        QueryModel queryModel = request.getQueryModel();
        ChanOrderInfoQuery query = (ChanOrderInfoQuery)queryModel.getCondition();
        if (StringUtil.isNotEmpty((String)query.getCreateDt())) {
            Date date = DateUtils.parseDate((String)query.getCreateDt(), (String)"yyyy-MM-dd");
            date = DateUtils.addDay((Date)date, (int)1);
            String createEnd = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd");
            query.setCreateEndDt(createEnd);
        }
        List list = this.chanOrderInfoService.index(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u8ba2\u5355\u4fe1\u606f\u4e0d\u5206\u9875\u67e5\u8be2")
    public IcspResultDto<List<ChanOrderInfoVo>> list(@RequestBody IcspRequest<ChanOrderInfoQuery> request) throws Exception {
        List list = this.chanOrderInfoService.list(request.getQueryModel());
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u4fe1\u606f")
    public IcspResultDto<Integer> update(@RequestBody IcspRequest<ChanOrderInfoBo> request) throws Exception {
        ChanOrderInfoBo chanOrderInfoBo = (ChanOrderInfoBo)request.getBody();
        int result = this.chanOrderInfoService.update(chanOrderInfoBo);
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u8ba2\u5355\u4fe1\u606f")
    public IcspResultDto<Integer> delete(@RequestBody IcspRequest<ChanOrderInfoBo> request) throws Exception {
        ChanOrderInfoBo chanOrderInfoBo = (ChanOrderInfoBo)request.getBody();
        int result = this.chanOrderInfoService.delete(chanOrderInfoBo.getOrderId());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/createOrder"})
    @ApiOperation(value="\u624b\u5de5\u6d3e\u5355")
    public IcspResultDto<Integer> createOrder(@RequestBody IcspRequest<ChanOrderByHandBo> request) throws Exception {
        int result = this.chanOrderInfoService.createOrder((ChanOrderByHandBo)request.getBody());
        return IcspResultDto.success((Object)result);
    }

    @PostMapping(value={"/prefill"})
    @ApiOperation(value="\u9884\u586b\u5355")
    public UUID prefill(@RequestBody IcspRequest<ChanOrderInfoBo> request) throws Exception {
        UUID result = UUID.randomUUID();
        return result;
    }
}

