/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mid.admin.aspect;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.dto.def.Menu;
import cn.com.yusys.yusp.common.dto.def.MenuContr;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.util.IcspSessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.mid.bo.channel.ChanAdminFlowInfoBo;
import cn.com.yusys.yusp.mid.dao.AdminSmMenuDao;
import cn.com.yusys.yusp.mid.dao.ChanAdminFlowInfoDao;
import cn.com.yusys.yusp.mid.domain.entity.AdminSmMenuEntity;
import cn.com.yusys.yusp.mid.domain.entity.ChanAdminFlowInfoEntity;
import cn.com.yusys.yusp.mid.utils.AuthUtils;
import cn.com.yusys.yusp.mid.utils.RedisCacheUtil;
import cn.com.yusys.yusp.mid.utils.SecurityUtils;
import cn.com.yusys.yusp.mid.utils.SeqNoUtil;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class TradeCommitAspect {
    @Autowired
    private SeqNoUtil seqNoUtil;
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private AdminSmMenuDao adminSmMenuDao;
    @Autowired
    private ChanAdminFlowInfoDao chanAdminFlowInfoDao;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="execution( * cn.com.yusys.yusp.mid.admin.controller.*.*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.OperGoodsController.*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.ChanMonitoringInfoController.transfer*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.Impor*.*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.ProgListAdminController*.*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.BaseInfoAdminController*.*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.InfoPushAdminController*.*(..)) && !execution(* cn.com.yusys.yusp.mid.admin.controller.SealCardController.*(..))) ")
    public void commitAuth() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Around(value="commitAuth()")
    public Object check(ProceedingJoinPoint joinPoint) throws Throwable {
        String totalSize;
        String pageSize;
        String interfaceUrl = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getRequestURI();
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0) {
            this.logger.info(interfaceUrl + " \u62a5\u6587\u4e3a\u7a7a\uff0c\u6821\u9a8c\u5931\u8d25.....");
            throw new IcspException("404", "\u62a5\u6587\u4e3a\u7a7a\uff0c\u6821\u9a8c\u5931\u8d25.....");
        }
        boolean isPortalInterface = true;
        Object arg = args[0];
        IcspRequest request = new IcspRequest();
        if (arg instanceof IcspRequest) {
            request = (IcspRequest)arg;
        } else {
            this.logger.info(interfaceUrl + " \u62a5\u6587\u975e\u6cd5\u6237\u8bf7\u6c42\u5934\u6216\u8005\u683c\u5f0f\u9519\u8bef.....");
            isPortalInterface = false;
        }
        if (isPortalInterface && request.getTradeHead() != null && StringUtils.nonEmpty((CharSequence)request.getTradeHead().getMenuId())) {
            MenuContr redisMD;
            this.logger.info("\u8fdb\u5165\u5207\u9762\uff0c\u5b89\u5168\u6821\u9a8c.....");
            String token = SecurityUtils.getCurrentUserToken();
            if (token == null) {
                this.logger.info(interfaceUrl + " token\u4e3a\u7a7a\uff0c\u6821\u9a8c\u5931\u8d25.....");
                throw new IcspException("404", "token\u4e3a\u7a7a\uff0c\u6821\u9a8c\u5931\u8d25.....");
            }
            Map parsedTokenMap = AuthUtils.getParsedAccessTokenMap();
            String accessToken = AuthUtils.getCurrentUserToken((Map)parsedTokenMap);
            this.logger.info("accessToken=" + accessToken);
            String userId = IcspSessionUtils.getUserId();
            if (!parsedTokenMap.get("user_id").equals(userId)) {
                this.logger.info(interfaceUrl + " \u5f53\u524d\u767b\u9646\u67dc\u5458\u4e0etoken\u5339\u914d\u5931\u8d25.....");
                throw new IcspException("500", "\u5f53\u524d\u767b\u9646\u67dc\u5458\u4e0etoken\u5339\u914d\u5931\u8d25.....");
            }
            String sysId = "mid";
            String menuId = request.getTradeHead().getMenuId();
            AdminSmMenuEntity adminSmMenuEntity = this.adminSmMenuDao.selectByMenuId(menuId);
            if (adminSmMenuEntity != null && sysId.equals(adminSmMenuEntity.getSysId()) && (redisMD = this.redisCacheUtil.getRedisMD(sysId, accessToken)) != null) {
                boolean menuAuth = false;
                String funcId = null;
                for (Menu menu : redisMD.getMenu()) {
                    if (!menu.getMenuId().equals(menuId)) continue;
                    menuAuth = true;
                    funcId = menu.getFuncId();
                    break;
                }
                if (!menuAuth) {
                    this.logger.info(interfaceUrl + " \u5f53\u524d\u767b\u9646\u67dc\u5458\u65e0\u6b64\u83dc\u5355\u6743\u9650.....");
                    throw new IcspException("500", "\u5f53\u524d\u767b\u9646\u67dc\u5458\u65e0\u6b64\u83dc\u5355\u6743\u9650.....");
                }
            }
        } else {
            this.logger.info(interfaceUrl + " \u62a5\u6587\u4e3a\u7a7a\uff0c\u6821\u9a8c\u5931\u8d25\u62a5\u6587\u975e\u6cd5\u6237\u8bf7\u6c42\u5934\u6216\u8005\u683c\u5f0f\u9519\u8bef.....");
            throw new IcspException("404", "\u62a5\u6587\u975e\u6cd5\u6237\u8bf7\u6c42\u5934\u6216\u8005\u683c\u5f0f\u9519\u8bef.....");
        }
        this.logger.info("\u6821\u9a8c\u7ed3\u675f.....");
        Object proceed = joinPoint.proceed();
        String[] url = interfaceUrl.split("/");
        String optionType = url[url.length - 1];
        optionType = "show".equals(optionType) || "index".equals(optionType) || "list".equals(optionType) ? "1" : ("create".equals(optionType) ? "2" : ("update".equals(optionType) ? "3" : ("delete".equals(optionType) ? "4" : "5")));
        IcspResultDto proceed1 = (IcspResultDto)proceed;
        String seqNo = this.seqNoUtil.createComsumerSeqNo();
        seqNo = seqNo.substring(5);
        ChanAdminFlowInfoBo chanAdminFlowInfoBo = new ChanAdminFlowInfoBo();
        chanAdminFlowInfoBo.setFlowId(seqNo);
        chanAdminFlowInfoBo.setTradeCode(request.getTradeHead().getTradeCode());
        chanAdminFlowInfoBo.setTradeName(request.getTradeHead().getTradeName());
        chanAdminFlowInfoBo.setOrgId(request.getTradeHead().getOrgId());
        chanAdminFlowInfoBo.setUserId(request.getTradeHead().getUserId());
        chanAdminFlowInfoBo.setOptionType(optionType);
        if (StringUtils.nonEmpty((CharSequence)request.getTradeHead().getMenuId())) {
            chanAdminFlowInfoBo.setMenuId(request.getTradeHead().getMenuId());
        }
        if (StringUtils.nonEmpty((CharSequence)request.getTradeHead().getWorkDate())) {
            chanAdminFlowInfoBo.setWorkDate(request.getTradeHead().getWorkDate());
        }
        chanAdminFlowInfoBo.setSysDt(DateUtils.getCurrDateTimeStr());
        String pageNum = String.valueOf(request.getSysHead().getPageNum());
        if (StringUtils.nonEmpty((CharSequence)pageNum)) {
            chanAdminFlowInfoBo.setPageNum(pageNum);
        }
        if (StringUtils.nonEmpty((CharSequence)(pageSize = String.valueOf(request.getSysHead().getPageSize())))) {
            chanAdminFlowInfoBo.setPageSize(pageSize);
        }
        if (StringUtils.nonEmpty((CharSequence)proceed1.getHead().getResponseDate())) {
            chanAdminFlowInfoBo.setResponseDate(proceed1.getHead().getResponseDate());
        }
        if (StringUtils.nonEmpty((CharSequence)proceed1.getHead().getResponseCode())) {
            chanAdminFlowInfoBo.setResponseCode(proceed1.getHead().getResponseCode());
        }
        if (StringUtils.nonEmpty((CharSequence)proceed1.getHead().getResponseMes())) {
            chanAdminFlowInfoBo.setResponseMes(proceed1.getHead().getResponseMes());
        }
        if (StringUtils.nonEmpty((CharSequence)(totalSize = String.valueOf(proceed1.getHead().getTotalSize())))) {
            chanAdminFlowInfoBo.setTotalSize(totalSize);
        }
        ChanAdminFlowInfoEntity chanAdminFlowInfoEntity = new ChanAdminFlowInfoEntity();
        BeanUtils.beanCopy((Object)chanAdminFlowInfoBo, (Object)chanAdminFlowInfoEntity);
        int flage = this.chanAdminFlowInfoDao.insert(chanAdminFlowInfoEntity);
        return proceed;
    }
}

