/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rocketmq.templete;

import cn.com.yusys.yusp.rocketmq.autoconfigure.RocketEnhanceProperties;
import cn.com.yusys.yusp.rocketmq.domain.BaseMessage;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.StringUtils;

public class RocketMQEnhanceTemplate {
    private static final Logger log = LoggerFactory.getLogger(RocketMQEnhanceTemplate.class);
    private final RocketMQTemplate template;
    @Resource
    private RocketEnhanceProperties rocketEnhanceProperties;

    public RocketMQTemplate getTemplate() {
        return this.template;
    }

    public String buildDestination(String topic, String tag) {
        topic = this.reBuildTopic(topic);
        return topic + ":" + tag;
    }

    private String reBuildTopic(String topic) {
        if (this.rocketEnhanceProperties.isEnabledIsolation() && StringUtils.hasText((String)this.rocketEnhanceProperties.getEnvironment())) {
            return topic + "_" + this.rocketEnhanceProperties.getEnvironment();
        }
        return topic;
    }

    public <T extends BaseMessage> void send(String topic, String tag, T message) {
        this.send(this.buildDestination(topic, tag), message);
    }

    public <T extends BaseMessage> void send(String destination, T message) {
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        this.template.send((Object)destination, sendMessage);
        log.info("[{}]\u5f02\u6b65\u6d88\u606f[{}]", (Object)destination, JSONObject.toJSON(message));
    }

    public <T extends BaseMessage> SendResult syncSend(String topic, String tag, T message) {
        return this.syncSend(this.buildDestination(topic, tag), message);
    }

    public <T extends BaseMessage> SendResult syncSend(String destination, T message) {
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        SendResult sendResult = this.template.syncSend(destination, sendMessage);
        log.info("[{}]\u540c\u6b65\u6d88\u606f[{}]\u53d1\u9001\u7ed3\u679c[{}]", new Object[]{destination, JSONObject.toJSON(message), JSONObject.toJSON((Object)sendResult)});
        return sendResult;
    }

    public <T extends BaseMessage> SendResult delaySend(String topic, String tag, T message, int delayLevel) {
        return this.delaySend(this.buildDestination(topic, tag), message, delayLevel);
    }

    public <T extends BaseMessage> SendResult delaySend(String destination, T message, int delayLevel) {
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        SendResult sendResult = this.template.syncSend(destination, sendMessage, 3000L, delayLevel);
        log.info("[{}]\u5ef6\u8fdf\u7b49\u7ea7[{}]\u6d88\u606f[{}]\u53d1\u9001\u7ed3\u679c[{}]", new Object[]{destination, delayLevel, JSONObject.toJSON(message), JSONObject.toJSON((Object)sendResult)});
        return sendResult;
    }

    @Autowired
    public RocketMQEnhanceTemplate(RocketMQTemplate template) {
        this.template = template;
    }
}

