/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rocketmq.handler;

import cn.com.yusys.yusp.rocketmq.constant.EnhanceMessageConstant;
import cn.com.yusys.yusp.rocketmq.domain.BaseMessage;
import cn.com.yusys.yusp.rocketmq.templete.RocketMQEnhanceTemplate;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnhanceMessageHandler<T extends BaseMessage> {
    private static final Logger log = LoggerFactory.getLogger(EnhanceMessageHandler.class);
    private static final int MAX_RETRY_TIMES = 3;
    private static final int DELAY_LEVEL = EnhanceMessageConstant.FIVE_SECOND;
    @Resource
    private RocketMQEnhanceTemplate rocketMQEnhanceTemplate;

    protected abstract void handleMessage(T var1) throws Exception;

    protected abstract void handleMaxRetriesExceeded(T var1);

    protected boolean filter(T message) {
        return false;
    }

    protected abstract boolean isRetry();

    protected abstract boolean throwException();

    protected int getMaxRetryTimes() {
        return 3;
    }

    protected int getDelayLevel() {
        return DELAY_LEVEL;
    }

    public void dispatchMessage(T message) {
        block5: {
            log.info("\u6d88\u8d39\u8005\u6536\u5230\u6d88\u606f[{}]", JSONObject.toJSON(message));
            if (this.filter(message)) {
                log.info("\u6d88\u606fid{}\u4e0d\u6ee1\u8db3\u6d88\u8d39\u6761\u4ef6\uff0c\u5df2\u8fc7\u6ee4\u3002", (Object)((BaseMessage)message).getKey());
                return;
            }
            if (((BaseMessage)message).getRetryTimes() > this.getMaxRetryTimes()) {
                this.handleMaxRetriesExceeded(message);
                return;
            }
            try {
                long now = System.currentTimeMillis();
                this.handleMessage(message);
                long costTime = System.currentTimeMillis() - now;
                log.info("\u6d88\u606f{}\u6d88\u8d39\u6210\u529f\uff0c\u8017\u65f6[{}ms]", (Object)((BaseMessage)message).getKey(), (Object)costTime);
            }
            catch (Exception e) {
                log.error("\u6d88\u606f{}\u6d88\u8d39\u5f02\u5e38", (Object)((BaseMessage)message).getKey(), (Object)e);
                if (this.throwException()) {
                    throw new RuntimeException(e);
                }
                if (!this.isRetry()) break block5;
                this.handleRetry(message);
            }
        }
    }

    protected void handleRetry(T message) {
        SendResult sendResult;
        RocketMQMessageListener annotation = this.getClass().getAnnotation(RocketMQMessageListener.class);
        if (annotation == null) {
            return;
        }
        String messageSource = ((BaseMessage)message).getSource();
        if (!messageSource.startsWith(EnhanceMessageConstant.RETRY_PREFIX)) {
            ((BaseMessage)message).setSource(EnhanceMessageConstant.RETRY_PREFIX + messageSource);
        }
        ((BaseMessage)message).setRetryTimes(((BaseMessage)message).getRetryTimes() + 1);
        try {
            sendResult = this.rocketMQEnhanceTemplate.delaySend(annotation.topic(), annotation.selectorExpression(), message, this.getDelayLevel());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (sendResult.getSendStatus() != SendStatus.SEND_OK) {
            throw new RuntimeException("\u91cd\u8bd5\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }
}

