/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rocketmq.autoconfigure;

import cn.com.yusys.yusp.rocketmq.autoconfigure.EnvironmentIsolationConfig;
import cn.com.yusys.yusp.rocketmq.autoconfigure.RocketEnhanceProperties;
import cn.com.yusys.yusp.rocketmq.templete.RocketMQEnhanceTemplate;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;

@Configuration
@EnableConfigurationProperties(value={RocketEnhanceProperties.class})
public class RocketMQEnhanceAutoConfiguration {
    @Bean
    public RocketMQEnhanceTemplate rocketMQEnhanceTemplate(RocketMQTemplate rocketMQTemplate) {
        return new RocketMQEnhanceTemplate(rocketMQTemplate);
    }

    @Bean
    @Primary
    public RocketMQMessageConverter enhanceRocketMQMessageConverter() {
        RocketMQMessageConverter converter = new RocketMQMessageConverter();
        CompositeMessageConverter compositeMessageConverter = (CompositeMessageConverter)converter.getMessageConverter();
        List messageConverterList = compositeMessageConverter.getConverters();
        for (MessageConverter messageConverter : messageConverterList) {
            if (!(messageConverter instanceof MappingJackson2MessageConverter)) continue;
            MappingJackson2MessageConverter jackson2MessageConverter = (MappingJackson2MessageConverter)messageConverter;
            ObjectMapper objectMapper = jackson2MessageConverter.getObjectMapper();
            objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        }
        return converter;
    }

    @Bean
    @ConditionalOnProperty(name={"rocketmq.enhance.enabledIsolation"}, havingValue="true")
    public EnvironmentIsolationConfig environmentSetup(RocketEnhanceProperties rocketEnhanceProperties) {
        return new EnvironmentIsolationConfig(rocketEnhanceProperties);
    }
}

