/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.rocketmq.autoconfigure;

import cn.com.yusys.yusp.rocketmq.autoconfigure.RocketEnhanceProperties;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.StringUtils;

public class EnvironmentIsolationConfig
implements BeanPostProcessor {
    private RocketEnhanceProperties rocketEnhanceProperties;

    public EnvironmentIsolationConfig(RocketEnhanceProperties rocketEnhanceProperties) {
        this.rocketEnhanceProperties = rocketEnhanceProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DefaultRocketMQListenerContainer) {
            DefaultRocketMQListenerContainer container = (DefaultRocketMQListenerContainer)bean;
            if (this.rocketEnhanceProperties.isEnabledIsolation() && StringUtils.hasText((String)this.rocketEnhanceProperties.getEnvironment())) {
                container.setTopic(String.join((CharSequence)"_", container.getTopic(), this.rocketEnhanceProperties.getEnvironment()));
            }
            return container;
        }
        return bean;
    }
}

