/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    public static String digestMD5(byte[] bytes) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        byte[] result = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < result.length; ++i) {
            String s = Integer.toHexString(0xFF & result[i]);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        String res = sb.toString();
        return res;
    }

    public static String digestMD5(File file) throws IOException, NoSuchAlgorithmException {
        String res = null;
        try (FileInputStream is = new FileInputStream(file);){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[4096];
            int length = 0;
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                md.update(buffer, 0, length);
            }
            byte[] result = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < result.length; ++i) {
                String s = Integer.toHexString(0xFF & result[i]);
                if (s.length() < 2) {
                    sb.append('0');
                }
                sb.append(s);
            }
            res = sb.toString();
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("build.properties");
        String md5 = MD5Util.digestMD5(file);
        System.out.println("1.md5=" + md5);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            int len = -1;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)in).read(buffer)) != -1) {
                byteOut.write(buffer, 0, len);
            }
            md5 = MD5Util.digestMD5(byteOut.toByteArray());
            System.out.println("2.md5=" + md5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

