/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class GZIPUtil {
    private static final int BUFFER_SIZE = 0x100000;

    public static byte[] zip(byte[] content, int off, int len) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(out);
        gzipOut.write(content, off, len);
        gzipOut.close();
        return out.toByteArray();
    }

    public static byte[] unzip(byte[] content, int pos, int len) throws IOException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(content, pos, len);
        GZIPInputStream zipIn = new GZIPInputStream(byteIn);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(len);
        byte[] buff = new byte[0x100000];
        int length = 0;
        while ((length = zipIn.read(buff)) != -1) {
            byteOut.write(buff, 0, length);
        }
        zipIn.close();
        byte[] res = byteOut.toByteArray();
        return res;
    }

    public static void zipFiles(File[] srcFiles, File zipFile, File relativeFile) throws IOException {
        GZIPUtil.zipFiles(srcFiles, zipFile, "", relativeFile);
    }

    public static void zipFiles(File[] srcFiles, File zipFile, String comment, File relativeFile) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile));){
            GZIPUtil.zipFiles(srcFiles, out, comment, relativeFile);
        }
    }

    public static void zipFiles(File[] srcFiles, OutputStream out, File relativeFile) throws IOException {
        GZIPUtil.zipFiles(srcFiles, out, "", relativeFile);
    }

    public static void zipFiles(File[] srcFiles, OutputStream out, String comment, File relativeFile) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            if (srcFiles != null && srcFiles.length > 0) {
                HashSet<String> includeFilePaths = new HashSet<String>();
                for (int i = 0; i < srcFiles.length; ++i) {
                    String absolutePath = srcFiles[i].getAbsolutePath();
                    includeFilePaths.add(absolutePath);
                }
                File[] files = relativeFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!GZIPUtil.containsPath(files[i].getAbsolutePath(), includeFilePaths)) continue;
                    GZIPUtil.zipEntry(files[i], zipOut, "", includeFilePaths);
                }
            }
            zipOut.setComment(comment);
        }
    }

    private static void zipFiles(File[] srcFiles, File relativeFile, ZipOutputStream zipOut) throws IOException {
        if (srcFiles != null && srcFiles.length > 0) {
            HashSet<String> includeFilePaths = new HashSet<String>();
            for (int i = 0; i < srcFiles.length; ++i) {
                String absolutePath = srcFiles[i].getAbsolutePath();
                includeFilePaths.add(absolutePath);
            }
            File[] files = relativeFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!GZIPUtil.containsPath(files[i].getAbsolutePath(), includeFilePaths)) continue;
                GZIPUtil.zipEntry(files[i], zipOut, "", includeFilePaths);
            }
        }
    }

    public static void zipFiles4Dirs(List<ZipDirNode> zipDirNodes, OutputStream out, String comment) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            int size = zipDirNodes.size();
            for (int i = 0; i < size; ++i) {
                ZipDirNode node = zipDirNodes.get(i);
                GZIPUtil.zipFiles(node.srcFiles, node.relativeFile, zipOut);
            }
            zipOut.setComment(comment);
        }
    }

    public static void zipDirectory(File srcDir, File targetFile, String comment) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(targetFile);
            GZIPUtil.zipDirectory(srcDir, out, comment);
            out.flush();
        }
        catch (Exception e) {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void zipDirectory(File srcDir, OutputStream out, String comment) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            GZIPUtil.zipEntry(srcDir, zipOut, "", null);
            zipOut.setComment(comment);
        }
    }

    private static boolean containsPath(String path, Set<String> includeFilePaths) {
        for (String key : includeFilePaths) {
            int index = key.indexOf(path);
            if (index != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipEntry(File srcFile, ZipOutputStream zipOut, String rootPath, Set<String> includeFilePaths) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        if (rootPath != null && rootPath.length() > 0) {
            sb.append(rootPath);
            sb.append("/");
        }
        sb.append(srcFile.getName());
        String path = sb.toString();
        if (srcFile.isDirectory()) {
            File[] fileList = srcFile.listFiles();
            GZIPUtil.forFile(fileList, zipOut, path, includeFilePaths);
        } else {
            String absolutePath;
            if (includeFilePaths != null && includeFilePaths.size() > 0 && !includeFilePaths.contains(absolutePath = srcFile.getAbsolutePath())) {
                return;
            }
            boolean flag = false;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));){
                zipOut.putNextEntry(new ZipEntry(path));
                flag = true;
                int len = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1) {
                    zipOut.write(buffer, 0, len);
                }
                zipOut.flush();
            }
            finally {
                if (flag) {
                    zipOut.closeEntry();
                }
            }
        }
    }

    public static void forFile(File[] fileList, ZipOutputStream zipOut, String path, Set<String> includeFilePaths) throws IOException {
        for (File file : fileList) {
            GZIPUtil.zipEntry(file, zipOut, path, includeFilePaths);
        }
    }

    public static void unzipFile(File srcFile, File folder, String encoding) throws IOException {
        try (ZipFile zipFile = new ZipFile(srcFile, encoding);){
            Enumeration e = zipFile.getEntries();
            ZipEntry entry = null;
            while (e.hasMoreElements()) {
                entry = (ZipEntry)e.nextElement();
                File entryFile = new File(folder, entry.getName());
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                File parentFile = entryFile.getParentFile();
                if (!parentFile.isDirectory()) {
                    parentFile.mkdirs();
                }
                InputStream zipIn = zipFile.getInputStream(entry);
                BufferedInputStream in = new BufferedInputStream(zipIn);
                Throwable throwable = null;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile));
                    Throwable throwable2 = null;
                    try {
                        byte[] buffer = new byte[0x100000];
                        int len = -1;
                        while ((len = ((InputStream)in).read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                        ((OutputStream)out).flush();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            zipFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void unzipFile(InputStream in, File folder) throws ZipException, IOException {
        ZipInputStream zipIn = new ZipInputStream(in);
        java.util.zip.ZipEntry entry = null;
        while ((entry = zipIn.getNextEntry()) != null) {
            File entryFile = new File(folder, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            File parentFile = entryFile.getParentFile();
            if (!parentFile.isDirectory()) {
                parentFile.mkdirs();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile));
            Throwable throwable = null;
            try {
                byte[] buffer = new byte[0x100000];
                int len = -1;
                while ((len = zipIn.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                ((OutputStream)out).flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)out).close();
            }
        }
    }

    public class ZipDirNode {
        public File[] srcFiles;
        public File relativeFile;
    }
}

