/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.utils;

import cn.com.yusys.yusp.common.utils.StringUtilEx;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN = "yyyyMMdd";
    public static final String REASON = "\u683c\u5f0f\u5316\u8f6c\u6362\u65e5\u671f\u5931\u8d25";

    public static String format(Date date) {
        return DateUtil.format(date, DATE_PATTERN);
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }

    public static String getAllTime14() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public static String getAllTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return sdf.format(new Date());
    }

    public static String getFormatDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_PATTERN);
        return sdf.format(new Date());
    }

    public static String getFormatDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN);
        return sdf.format(new Date());
    }

    public static String getFormatTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        return sdf.format(new Date());
    }

    public static String getDateFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String getDefaultFormat(Date date) {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
        return df.format(date);
    }

    public static Date getStringTime1(String dateStr) throws Exception {
        if (StringUtilEx.isNullOrEmpty(dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
            return date;
        }
        catch (ParseException var4) {
            throw new RuntimeException(REASON);
        }
    }

    public static Date getStringTime2(String dateStr, String sdfstr) throws Exception {
        if (StringUtilEx.isNullOrEmpty(dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(sdfstr);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
            return date;
        }
        catch (ParseException var5) {
            throw new RuntimeException(REASON);
        }
    }

    public static Date getStringTime1(String dateStr, String datepater) throws Exception {
        if (StringUtilEx.isNullOrEmpty(dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(datepater);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
            return date;
        }
        catch (ParseException var5) {
            throw new RuntimeException(REASON);
        }
    }

    public static String getDateString() {
        StringBuffer dateStr = new StringBuffer();
        Calendar now = Calendar.getInstance();
        Integer year = now.get(1);
        dateStr.append(year);
        Integer month = now.get(2) + 1;
        if (month.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(month);
        } else {
            dateStr.append(month);
        }
        Integer day = now.get(5);
        if (day.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(day);
        } else {
            dateStr.append(day);
        }
        return dateStr.toString();
    }

    public static String getTimeString() {
        StringBuffer dateStr = new StringBuffer();
        Calendar now = Calendar.getInstance();
        Integer hour = now.get(11);
        if (hour.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(hour);
        } else {
            dateStr.append(hour);
        }
        Integer minute = now.get(12);
        if (minute.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(minute);
        } else {
            dateStr.append(minute);
        }
        return dateStr.toString();
    }

    public static String dataToString(Date DateStr) throws ParseException {
        String date = new SimpleDateFormat(DATE_TIME_PATTERN).format(DateStr);
        return date;
    }

    public static Date stingTODate(String dateStr) throws ParseException {
        Date date = null;
        if (dateStr != null && !dateStr.equals("")) {
            if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
                dateStr = dateStr + " 00:00";
            } else {
                if (!dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}")) {
                    return null;
                }
                dateStr = dateStr + ":00";
            }
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_TIME_PATTERN);
        date = format.parse(dateStr);
        return date;
    }

    public static Date stingTODate(String dateStr, String arg) throws ParseException {
        if (dateStr != null && !dateStr.equals("")) {
            SimpleDateFormat format = new SimpleDateFormat(arg);
            Date date = format.parse(dateStr);
            return date;
        }
        return null;
    }

    public static Date sqlToUntil(java.sql.Date sqlData) {
        Date untilDate = new Date(sqlData.getTime());
        return untilDate;
    }

    public static java.sql.Date untilToSql(Date utilData) {
        java.sql.Date sqllDate = new java.sql.Date(utilData.getTime());
        return sqllDate;
    }

    public static Date getDateByCount(String startDate, int yearCount, int monthCount, int dayCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(new SimpleDateFormat(PATTERN).parse(startDate).getTime()));
        if (yearCount > 0) {
            calendar.add(1, yearCount);
        }
        if (monthCount != 0) {
            calendar.add(2, monthCount);
        }
        if (dayCount != 0) {
            calendar.add(5, dayCount);
        }
        return calendar.getTime();
    }

    public static void main(String[] args) throws ParseException {
        System.out.println("" + DateUtil.getDateByCount("20140129", 0, 0, 100));
    }

    public static Long getRemainingdays(String startDate, String endDate) throws Exception {
        try {
            long start = new SimpleDateFormat(PATTERN).parse(startDate).getTime();
            long end = new SimpleDateFormat(PATTERN).parse(endDate).getTime();
            long day = (end - start) / 1000L / 60L / 60L / 24L;
            return day;
        }
        catch (Exception var8) {
            logger.error(var8.getMessage(), (Throwable)var8);
            return 0L;
        }
    }

    public static String format(String datesrc, String srcFormat, String toFormat) {
        Date srcdate;
        SimpleDateFormat sdf = new SimpleDateFormat(srcFormat);
        try {
            srcdate = sdf.parse(datesrc);
        }
        catch (ParseException var6) {
            throw new RuntimeException(REASON);
        }
        sdf.applyPattern(toFormat);
        return sdf.format(srcdate);
    }

    public static Long getDateSpaceNew(String date) throws Exception {
        String newdate = DateUtil.getDateString().replace("-", "");
        return DateUtil.getRemainingdays(date, newdate);
    }

    public static Date addYearAndMonthAndDay(Date date, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, year);
        calendar.add(2, month);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static String formatDateTimeByDef() {
        return DateUtil.formatDate(DATE_TIME_PATTERN);
    }

    public static String formatDate(String pattern) {
        return DateUtil.formatDate(new Date(), pattern);
    }

    public static String formatDate(Date date, String pattern) {
        return Objects.nonNull(date) ? new SimpleDateFormat(pattern, Locale.CHINA).format(date) : null;
    }
}

