/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.exception;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483647)
public class PlusExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(PlusExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResultDto<Object> handleException(Exception e) {
        String message = e.getMessage();
        if (this.isWorkFlowException(e)) {
            log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aWorkflowException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
            return ResultDto.error((String)"500", (String)message);
        }
        String language = LocaleContextHolder.getLocale().toString().toLowerCase();
        String msg = "\u7cfb\u7edf\u4e1a\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
        if (!"zh_cn".equals(language)) {
            msg = "System is busy, please retry again later!";
        }
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        return ResultDto.error((String)"500", (String)msg);
    }

    private boolean isWorkFlowException(Exception e) {
        if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
            return false;
        }
        return "WorkflowException".equals(e.getClass().getSimpleName()) || "TransformException".equals(e.getClass().getSimpleName());
    }

    @ExceptionHandler(value={BizException.class})
    public ResultDto<Object> handleBizException(BizException e) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aBizException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        return StringUtils.isEmpty((CharSequence)e.getErrorCode()) ? ResultDto.error((String)e.getMessage()) : ResultDto.error((String)e.getErrorCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultDto<Object> handleValidationExceptions(MethodArgumentNotValidException ex) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aMethodArgumentNotValidException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)ex);
        String defaultMessage = ((ObjectError)ex.getBindingResult().getAllErrors().get(0)).getDefaultMessage();
        assert (defaultMessage != null);
        String[] split = defaultMessage.split("&");
        if (split.length > 1) {
            return ResultDto.error((String)split[0], (String)split[1]);
        }
        return ResultDto.error((String)"400", (String)ex.getBindingResult().getAllErrors().stream().map(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            String code = error.getCode();
            return fieldName + ": " + errorMessage + ":" + code;
        }).collect(Collectors.joining()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResultDto<Object> handleConstraintViolationExceptions(ConstraintViolationException ex) {
        log.error("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\uff1aConstraintViolationException, \u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)ex);
        return ResultDto.error((String)"400", (String)ex.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(",")));
    }
}

