/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.client;

import feign.Logger;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignConfig
implements RequestInterceptor {
    public void apply(RequestTemplate template) {
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if (!"accept-language".equals(name.toLowerCase())) continue;
                String values = request.getHeader(name);
                template.header(name, new String[]{values});
            }
        }
    }

    @Bean
    Logger.Level feignLevel() {
        return Logger.Level.FULL;
    }
}

