/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mq.guard.config;

import cn.com.yusys.yusp.mq.guard.config.RabbitMQTemplateGuard;
import cn.com.yusys.yusp.mq.guard.service.IMqRecordService;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class RabbitMQConfig {
    @Autowired
    IMqRecordService mqSendRecordService;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Primary
    @Bean
    public RabbitTemplate rabbitTemplate(RabbitTemplateConfigurer configurer, ConnectionFactory connectionFactory) {
        RabbitMQTemplateGuard template = new RabbitMQTemplateGuard(this.applicationName, this.mqSendRecordService);
        configurer.configure((RabbitTemplate)template, connectionFactory);
        return template;
    }

    @Bean
    Queue dlqQueue() {
        return QueueBuilder.durable((String)"DLQ_QUEUE").build();
    }
}

