/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mq.guard;

import cn.com.yusys.yusp.mq.guard.entity.MqRecord;
import cn.com.yusys.yusp.mq.guard.service.IMqRecordService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DLQMsgListener {
    private static final Logger log = LoggerFactory.getLogger(DLQMsgListener.class);
    @Autowired
    private IMqRecordService mqSendRecordService;

    @RabbitListener(queues={"DLQ_QUEUE"})
    public void dlqQueueMsg(Message message) {
        MessageProperties messageProperties = message.getMessageProperties();
        List xDeathHeader = messageProperties.getXDeathHeader();
        for (Map map : xDeathHeader) {
            MqRecord mqRecord = new MqRecord();
            mqRecord.setRecordId(UUID.randomUUID().toString());
            mqRecord.setMqExchange((String)map.get("exchange"));
            mqRecord.setQueue((String)map.get("queue"));
            List routingKey = (List)map.get("routing-keys");
            mqRecord.setRoutingKey((String)routingKey.get(0));
            mqRecord.setReason((String)map.get("reason"));
            mqRecord.setMsgBody(new String(message.getBody(), StandardCharsets.UTF_8));
            mqRecord.setState("2");
            mqRecord.setRetryTime(0);
            mqRecord.setCreateTime(LocalDateTime.now());
            mqRecord.setDoAction("1");
            this.mqSendRecordService.save(mqRecord);
        }
    }
}

