/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.esb.process;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.propagation.TraceContext;
import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import cn.com.yusys.yusp.commons.context.header.process.MessageProcessor;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.esb.head.channel.csp.CSPReqAppHead;
import cn.com.yusys.yusp.esb.head.pub.EsbReqHeader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class MessageProcessorImpl
implements MessageProcessor {
    private String APP_HEAD_KEY = "AppHead";
    private String HEAD_KEY = "Head";

    public void processIn(Object in) {
        this.initContext(this.traceContext(new ContextHolder()));
        if (in == null) {
            return;
        }
        if (in instanceof Map) {
            Object param;
            Map params = (Map)in;
            if (params.get(this.APP_HEAD_KEY) != null) {
                param = params.get(this.APP_HEAD_KEY);
                CSPReqAppHead sysHead = (CSPReqAppHead)ObjectMapperUtils.instance().convertValue(param, TypeFactory.defaultInstance().constructType(CSPReqAppHead.class));
                ContextHolder.putContext((Object)sysHead);
            }
            if (params.get(this.HEAD_KEY) != null) {
                param = params.get(this.HEAD_KEY);
                EsbReqHeader tradeHead = (EsbReqHeader)ObjectMapperUtils.instance().convertValue(param, TypeFactory.defaultInstance().constructType(EsbReqHeader.class));
                ContextHolder.putContext((Object)tradeHead);
            }
        }
    }

    void initContext(TraceContext traceContext) {
        CurrentTraceContext currentTraceContext = ThreadLocalCurrentTraceContext.create();
        currentTraceContext.newScope(traceContext);
        Tracing.newBuilder().currentTraceContext(currentTraceContext).build();
    }

    TraceContext traceContext(Object extra) {
        return TraceContext.newBuilder().traceId(10L).spanId(101L).addExtra(extra).build();
    }
}

