/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.esb.head.pub;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.RandomUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.esb.EsbConfig;
import cn.com.yusys.yusp.esb.config.EsbProperties;
import cn.com.yusys.yusp.esb.entity.EsbRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class EsbReqHeader {
    private static final Logger log = LoggerFactory.getLogger(EsbReqHeader.class);
    private String SvcCd;
    private String SvcScn;
    private String CnlTp;
    private String CnsmrSysId;
    private String CnsmrSeqNo;
    private String SrcCnsmrSysId;
    private String GlblSeqNo;
    private String TxnDt;
    private String TxnTm;
    private String CnsmrSvrId;
    private String FileFlg;
    private String FileNm;
    private String SvcVerNo;
    private String TmlNo;
    private String BrchNo;
    private String TlrNo;
    @JsonIgnore
    private EsbProperties esbProperties;

    public EsbReqHeader() {
    }

    private String createSeq() {
        String sequence = "";
        try {
            sequence = SequenceUtils.getSequence((String)"ESBSEQ");
        }
        catch (Exception e) {
            sequence = String.format("F165%s%s", DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATETIME_COMPACT), RandomUtils.randomString((int)12));
            log.error("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38", (Throwable)e);
        }
        return sequence;
    }

    public EsbReqHeader init(EsbRequest request) {
        String sequence = this.createSeq();
        String sysId = this.esbProperties.getSysId();
        Class<?> clazz = request.getBody().getClass();
        EsbConfig esbConfig = clazz.getAnnotation(EsbConfig.class);
        this.setSvcCd(esbConfig.SvcCd());
        this.setSvcScn(esbConfig.SvcScn());
        this.setFileFlg(Optional.ofNullable(this.getFileFlg()).orElse("0"));
        this.setCnsmrSeqNo(sequence);
        this.setTxnDt(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        this.setTxnTm(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT));
        this.setSrcCnsmrSysId(sysId);
        this.setGlblSeqNo(sequence);
        this.setCnsmrSysId(sysId);
        this.setCnlTp(Optional.ofNullable(this.getCnlTp()).orElse(""));
        this.setCnsmrSvrId(Optional.ofNullable(this.getCnsmrSvrId()).orElse(""));
        this.setFileNm(Optional.ofNullable(this.getFileNm()).orElse(""));
        this.setSvcVerNo(Optional.ofNullable(this.getSvcVerNo()).orElse(""));
        this.setBrchNo(Optional.ofNullable(this.getBrchNo()).orElse(""));
        this.setTlrNo(Optional.ofNullable(this.getTlrNo()).orElse(""));
        this.setTmlNo(Optional.ofNullable(this.getTmlNo()).orElse(""));
        return this;
    }

    EsbReqHeader(String SvcCd, String SvcScn, String CnlTp, String CnsmrSysId, String CnsmrSeqNo, String SrcCnsmrSysId, String GlblSeqNo, String TxnDt, String TxnTm, String CnsmrSvrId, String FileFlg, String FileNm, String SvcVerNo, String TmlNo, String BrchNo, String TlrNo, EsbProperties esbProperties) {
        this.SvcCd = SvcCd;
        this.SvcScn = SvcScn;
        this.CnlTp = CnlTp;
        this.CnsmrSysId = CnsmrSysId;
        this.CnsmrSeqNo = CnsmrSeqNo;
        this.SrcCnsmrSysId = SrcCnsmrSysId;
        this.GlblSeqNo = GlblSeqNo;
        this.TxnDt = TxnDt;
        this.TxnTm = TxnTm;
        this.CnsmrSvrId = CnsmrSvrId;
        this.FileFlg = FileFlg;
        this.FileNm = FileNm;
        this.SvcVerNo = SvcVerNo;
        this.TmlNo = TmlNo;
        this.BrchNo = BrchNo;
        this.TlrNo = TlrNo;
        this.esbProperties = esbProperties;
    }

    public static EsbReqHeaderBuilder builder() {
        return new EsbReqHeaderBuilder();
    }

    public String getSvcCd() {
        return this.SvcCd;
    }

    public String getSvcScn() {
        return this.SvcScn;
    }

    public String getCnlTp() {
        return this.CnlTp;
    }

    public String getCnsmrSysId() {
        return this.CnsmrSysId;
    }

    public String getCnsmrSeqNo() {
        return this.CnsmrSeqNo;
    }

    public String getSrcCnsmrSysId() {
        return this.SrcCnsmrSysId;
    }

    public String getGlblSeqNo() {
        return this.GlblSeqNo;
    }

    public String getTxnDt() {
        return this.TxnDt;
    }

    public String getTxnTm() {
        return this.TxnTm;
    }

    public String getCnsmrSvrId() {
        return this.CnsmrSvrId;
    }

    public String getFileFlg() {
        return this.FileFlg;
    }

    public String getFileNm() {
        return this.FileNm;
    }

    public String getSvcVerNo() {
        return this.SvcVerNo;
    }

    public String getTmlNo() {
        return this.TmlNo;
    }

    public String getBrchNo() {
        return this.BrchNo;
    }

    public String getTlrNo() {
        return this.TlrNo;
    }

    public EsbProperties getEsbProperties() {
        return this.esbProperties;
    }

    public void setSvcCd(String SvcCd) {
        this.SvcCd = SvcCd;
    }

    public void setSvcScn(String SvcScn) {
        this.SvcScn = SvcScn;
    }

    public void setCnlTp(String CnlTp) {
        this.CnlTp = CnlTp;
    }

    public void setCnsmrSysId(String CnsmrSysId) {
        this.CnsmrSysId = CnsmrSysId;
    }

    public void setCnsmrSeqNo(String CnsmrSeqNo) {
        this.CnsmrSeqNo = CnsmrSeqNo;
    }

    public void setSrcCnsmrSysId(String SrcCnsmrSysId) {
        this.SrcCnsmrSysId = SrcCnsmrSysId;
    }

    public void setGlblSeqNo(String GlblSeqNo) {
        this.GlblSeqNo = GlblSeqNo;
    }

    public void setTxnDt(String TxnDt) {
        this.TxnDt = TxnDt;
    }

    public void setTxnTm(String TxnTm) {
        this.TxnTm = TxnTm;
    }

    public void setCnsmrSvrId(String CnsmrSvrId) {
        this.CnsmrSvrId = CnsmrSvrId;
    }

    public void setFileFlg(String FileFlg) {
        this.FileFlg = FileFlg;
    }

    public void setFileNm(String FileNm) {
        this.FileNm = FileNm;
    }

    public void setSvcVerNo(String SvcVerNo) {
        this.SvcVerNo = SvcVerNo;
    }

    public void setTmlNo(String TmlNo) {
        this.TmlNo = TmlNo;
    }

    public void setBrchNo(String BrchNo) {
        this.BrchNo = BrchNo;
    }

    public void setTlrNo(String TlrNo) {
        this.TlrNo = TlrNo;
    }

    @JsonIgnore
    public void setEsbProperties(EsbProperties esbProperties) {
        this.esbProperties = esbProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsbReqHeader)) {
            return false;
        }
        EsbReqHeader other = (EsbReqHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$SvcCd = this.getSvcCd();
        String other$SvcCd = other.getSvcCd();
        if (this$SvcCd == null ? other$SvcCd != null : !this$SvcCd.equals(other$SvcCd)) {
            return false;
        }
        String this$SvcScn = this.getSvcScn();
        String other$SvcScn = other.getSvcScn();
        if (this$SvcScn == null ? other$SvcScn != null : !this$SvcScn.equals(other$SvcScn)) {
            return false;
        }
        String this$CnlTp = this.getCnlTp();
        String other$CnlTp = other.getCnlTp();
        if (this$CnlTp == null ? other$CnlTp != null : !this$CnlTp.equals(other$CnlTp)) {
            return false;
        }
        String this$CnsmrSysId = this.getCnsmrSysId();
        String other$CnsmrSysId = other.getCnsmrSysId();
        if (this$CnsmrSysId == null ? other$CnsmrSysId != null : !this$CnsmrSysId.equals(other$CnsmrSysId)) {
            return false;
        }
        String this$CnsmrSeqNo = this.getCnsmrSeqNo();
        String other$CnsmrSeqNo = other.getCnsmrSeqNo();
        if (this$CnsmrSeqNo == null ? other$CnsmrSeqNo != null : !this$CnsmrSeqNo.equals(other$CnsmrSeqNo)) {
            return false;
        }
        String this$SrcCnsmrSysId = this.getSrcCnsmrSysId();
        String other$SrcCnsmrSysId = other.getSrcCnsmrSysId();
        if (this$SrcCnsmrSysId == null ? other$SrcCnsmrSysId != null : !this$SrcCnsmrSysId.equals(other$SrcCnsmrSysId)) {
            return false;
        }
        String this$GlblSeqNo = this.getGlblSeqNo();
        String other$GlblSeqNo = other.getGlblSeqNo();
        if (this$GlblSeqNo == null ? other$GlblSeqNo != null : !this$GlblSeqNo.equals(other$GlblSeqNo)) {
            return false;
        }
        String this$TxnDt = this.getTxnDt();
        String other$TxnDt = other.getTxnDt();
        if (this$TxnDt == null ? other$TxnDt != null : !this$TxnDt.equals(other$TxnDt)) {
            return false;
        }
        String this$TxnTm = this.getTxnTm();
        String other$TxnTm = other.getTxnTm();
        if (this$TxnTm == null ? other$TxnTm != null : !this$TxnTm.equals(other$TxnTm)) {
            return false;
        }
        String this$CnsmrSvrId = this.getCnsmrSvrId();
        String other$CnsmrSvrId = other.getCnsmrSvrId();
        if (this$CnsmrSvrId == null ? other$CnsmrSvrId != null : !this$CnsmrSvrId.equals(other$CnsmrSvrId)) {
            return false;
        }
        String this$FileFlg = this.getFileFlg();
        String other$FileFlg = other.getFileFlg();
        if (this$FileFlg == null ? other$FileFlg != null : !this$FileFlg.equals(other$FileFlg)) {
            return false;
        }
        String this$FileNm = this.getFileNm();
        String other$FileNm = other.getFileNm();
        if (this$FileNm == null ? other$FileNm != null : !this$FileNm.equals(other$FileNm)) {
            return false;
        }
        String this$SvcVerNo = this.getSvcVerNo();
        String other$SvcVerNo = other.getSvcVerNo();
        if (this$SvcVerNo == null ? other$SvcVerNo != null : !this$SvcVerNo.equals(other$SvcVerNo)) {
            return false;
        }
        String this$TmlNo = this.getTmlNo();
        String other$TmlNo = other.getTmlNo();
        if (this$TmlNo == null ? other$TmlNo != null : !this$TmlNo.equals(other$TmlNo)) {
            return false;
        }
        String this$BrchNo = this.getBrchNo();
        String other$BrchNo = other.getBrchNo();
        if (this$BrchNo == null ? other$BrchNo != null : !this$BrchNo.equals(other$BrchNo)) {
            return false;
        }
        String this$TlrNo = this.getTlrNo();
        String other$TlrNo = other.getTlrNo();
        if (this$TlrNo == null ? other$TlrNo != null : !this$TlrNo.equals(other$TlrNo)) {
            return false;
        }
        EsbProperties this$esbProperties = this.getEsbProperties();
        EsbProperties other$esbProperties = other.getEsbProperties();
        return !(this$esbProperties == null ? other$esbProperties != null : !((Object)this$esbProperties).equals(other$esbProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsbReqHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $SvcCd = this.getSvcCd();
        result = result * 59 + ($SvcCd == null ? 43 : $SvcCd.hashCode());
        String $SvcScn = this.getSvcScn();
        result = result * 59 + ($SvcScn == null ? 43 : $SvcScn.hashCode());
        String $CnlTp = this.getCnlTp();
        result = result * 59 + ($CnlTp == null ? 43 : $CnlTp.hashCode());
        String $CnsmrSysId = this.getCnsmrSysId();
        result = result * 59 + ($CnsmrSysId == null ? 43 : $CnsmrSysId.hashCode());
        String $CnsmrSeqNo = this.getCnsmrSeqNo();
        result = result * 59 + ($CnsmrSeqNo == null ? 43 : $CnsmrSeqNo.hashCode());
        String $SrcCnsmrSysId = this.getSrcCnsmrSysId();
        result = result * 59 + ($SrcCnsmrSysId == null ? 43 : $SrcCnsmrSysId.hashCode());
        String $GlblSeqNo = this.getGlblSeqNo();
        result = result * 59 + ($GlblSeqNo == null ? 43 : $GlblSeqNo.hashCode());
        String $TxnDt = this.getTxnDt();
        result = result * 59 + ($TxnDt == null ? 43 : $TxnDt.hashCode());
        String $TxnTm = this.getTxnTm();
        result = result * 59 + ($TxnTm == null ? 43 : $TxnTm.hashCode());
        String $CnsmrSvrId = this.getCnsmrSvrId();
        result = result * 59 + ($CnsmrSvrId == null ? 43 : $CnsmrSvrId.hashCode());
        String $FileFlg = this.getFileFlg();
        result = result * 59 + ($FileFlg == null ? 43 : $FileFlg.hashCode());
        String $FileNm = this.getFileNm();
        result = result * 59 + ($FileNm == null ? 43 : $FileNm.hashCode());
        String $SvcVerNo = this.getSvcVerNo();
        result = result * 59 + ($SvcVerNo == null ? 43 : $SvcVerNo.hashCode());
        String $TmlNo = this.getTmlNo();
        result = result * 59 + ($TmlNo == null ? 43 : $TmlNo.hashCode());
        String $BrchNo = this.getBrchNo();
        result = result * 59 + ($BrchNo == null ? 43 : $BrchNo.hashCode());
        String $TlrNo = this.getTlrNo();
        result = result * 59 + ($TlrNo == null ? 43 : $TlrNo.hashCode());
        EsbProperties $esbProperties = this.getEsbProperties();
        result = result * 59 + ($esbProperties == null ? 43 : ((Object)$esbProperties).hashCode());
        return result;
    }

    public String toString() {
        return "EsbReqHeader(SvcCd=" + this.getSvcCd() + ", SvcScn=" + this.getSvcScn() + ", CnlTp=" + this.getCnlTp() + ", CnsmrSysId=" + this.getCnsmrSysId() + ", CnsmrSeqNo=" + this.getCnsmrSeqNo() + ", SrcCnsmrSysId=" + this.getSrcCnsmrSysId() + ", GlblSeqNo=" + this.getGlblSeqNo() + ", TxnDt=" + this.getTxnDt() + ", TxnTm=" + this.getTxnTm() + ", CnsmrSvrId=" + this.getCnsmrSvrId() + ", FileFlg=" + this.getFileFlg() + ", FileNm=" + this.getFileNm() + ", SvcVerNo=" + this.getSvcVerNo() + ", TmlNo=" + this.getTmlNo() + ", BrchNo=" + this.getBrchNo() + ", TlrNo=" + this.getTlrNo() + ", esbProperties=" + this.getEsbProperties() + ")";
    }

    public static class EsbReqHeaderBuilder {
        private String SvcCd;
        private String SvcScn;
        private String CnlTp;
        private String CnsmrSysId;
        private String CnsmrSeqNo;
        private String SrcCnsmrSysId;
        private String GlblSeqNo;
        private String TxnDt;
        private String TxnTm;
        private String CnsmrSvrId;
        private String FileFlg;
        private String FileNm;
        private String SvcVerNo;
        private String TmlNo;
        private String BrchNo;
        private String TlrNo;
        private EsbProperties esbProperties;

        EsbReqHeaderBuilder() {
        }

        public EsbReqHeaderBuilder SvcCd(String SvcCd) {
            this.SvcCd = SvcCd;
            return this;
        }

        public EsbReqHeaderBuilder SvcScn(String SvcScn) {
            this.SvcScn = SvcScn;
            return this;
        }

        public EsbReqHeaderBuilder CnlTp(String CnlTp) {
            this.CnlTp = CnlTp;
            return this;
        }

        public EsbReqHeaderBuilder CnsmrSysId(String CnsmrSysId) {
            this.CnsmrSysId = CnsmrSysId;
            return this;
        }

        public EsbReqHeaderBuilder CnsmrSeqNo(String CnsmrSeqNo) {
            this.CnsmrSeqNo = CnsmrSeqNo;
            return this;
        }

        public EsbReqHeaderBuilder SrcCnsmrSysId(String SrcCnsmrSysId) {
            this.SrcCnsmrSysId = SrcCnsmrSysId;
            return this;
        }

        public EsbReqHeaderBuilder GlblSeqNo(String GlblSeqNo) {
            this.GlblSeqNo = GlblSeqNo;
            return this;
        }

        public EsbReqHeaderBuilder TxnDt(String TxnDt) {
            this.TxnDt = TxnDt;
            return this;
        }

        public EsbReqHeaderBuilder TxnTm(String TxnTm) {
            this.TxnTm = TxnTm;
            return this;
        }

        public EsbReqHeaderBuilder CnsmrSvrId(String CnsmrSvrId) {
            this.CnsmrSvrId = CnsmrSvrId;
            return this;
        }

        public EsbReqHeaderBuilder FileFlg(String FileFlg) {
            this.FileFlg = FileFlg;
            return this;
        }

        public EsbReqHeaderBuilder FileNm(String FileNm) {
            this.FileNm = FileNm;
            return this;
        }

        public EsbReqHeaderBuilder SvcVerNo(String SvcVerNo) {
            this.SvcVerNo = SvcVerNo;
            return this;
        }

        public EsbReqHeaderBuilder TmlNo(String TmlNo) {
            this.TmlNo = TmlNo;
            return this;
        }

        public EsbReqHeaderBuilder BrchNo(String BrchNo) {
            this.BrchNo = BrchNo;
            return this;
        }

        public EsbReqHeaderBuilder TlrNo(String TlrNo) {
            this.TlrNo = TlrNo;
            return this;
        }

        @JsonIgnore
        public EsbReqHeaderBuilder esbProperties(EsbProperties esbProperties) {
            this.esbProperties = esbProperties;
            return this;
        }

        public EsbReqHeader build() {
            return new EsbReqHeader(this.SvcCd, this.SvcScn, this.CnlTp, this.CnsmrSysId, this.CnsmrSeqNo, this.SrcCnsmrSysId, this.GlblSeqNo, this.TxnDt, this.TxnTm, this.CnsmrSvrId, this.FileFlg, this.FileNm, this.SvcVerNo, this.TmlNo, this.BrchNo, this.TlrNo, this.esbProperties);
        }

        public String toString() {
            return "EsbReqHeader.EsbReqHeaderBuilder(SvcCd=" + this.SvcCd + ", SvcScn=" + this.SvcScn + ", CnlTp=" + this.CnlTp + ", CnsmrSysId=" + this.CnsmrSysId + ", CnsmrSeqNo=" + this.CnsmrSeqNo + ", SrcCnsmrSysId=" + this.SrcCnsmrSysId + ", GlblSeqNo=" + this.GlblSeqNo + ", TxnDt=" + this.TxnDt + ", TxnTm=" + this.TxnTm + ", CnsmrSvrId=" + this.CnsmrSvrId + ", FileFlg=" + this.FileFlg + ", FileNm=" + this.FileNm + ", SvcVerNo=" + this.SvcVerNo + ", TmlNo=" + this.TmlNo + ", BrchNo=" + this.BrchNo + ", TlrNo=" + this.TlrNo + ", esbProperties=" + this.esbProperties + ")";
        }
    }
}

