/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.esb.config;

import cn.com.yusys.yusp.esb.AbstractAppHead;
import cn.com.yusys.yusp.esb.EsbChannel;
import cn.com.yusys.yusp.esb.IEsbAppHead;
import cn.com.yusys.yusp.esb.RegisterAppHead;
import cn.com.yusys.yusp.esb.config.EsbProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Configuration
@Component
@EnableConfigurationProperties(value={EsbProperties.class})
public class EsbAppHeadResourceResolver
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String RESOURCE_PATTERN = "/**/*.class";
    private final List<AbstractAppHead> appHeads = new ArrayList<AbstractAppHead>();
    private final Map<String, AbstractAppHead> appHeadsMap = new HashMap<String, AbstractAppHead>();
    @Autowired
    private EsbProperties esbProperties;
    @Autowired
    private ApplicationContext applicationContext;

    public List<AbstractAppHead> getAllAppHeads() {
        return this.appHeads;
    }

    public AbstractAppHead getAppHead(String channel) {
        return this.appHeadsMap.get(channel);
    }

    public void afterPropertiesSet() throws Exception {
        Map annotatedBeans = this.applicationContext.getBeansWithAnnotation(SpringBootApplication.class);
        Class<?> mainClazz = annotatedBeans.values().toArray()[0].getClass();
        SpringBootApplication springBootApplication = mainClazz.getAnnotation(SpringBootApplication.class);
        String[] packages = springBootApplication.scanBasePackages();
        if (packages.length > 0) {
            for (int i = 0; i < packages.length; ++i) {
                this.doScanPackageResource(packages[i]);
            }
        } else {
            String path = ClassUtils.getPackageName(mainClazz);
            this.doScanPackageResource(path);
        }
    }

    private void doScanPackageResource(String path) throws Exception {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)path) + "/**/*.class";
        Resource[] resources = resourcePatternResolver.getResources(pattern);
        CachingMetadataReaderFactory readerfactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        HashMap granterMap = new HashMap();
        for (Resource resource : resources) {
            MetadataReader reader = readerfactory.getMetadataReader(resource);
            String classname = reader.getClassMetadata().getClassName();
            try {
                Class<?> clazz = Class.forName(classname);
                EsbChannel esbChannel = clazz.getAnnotation(EsbChannel.class);
                if (null == esbChannel || !AbstractAppHead.class.isAssignableFrom(clazz)) continue;
                granterMap.put(esbChannel.value(), clazz);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.registAppHead(granterMap);
    }

    private void registAppHead(Map<String, Class<?>> appHeadMap) {
        appHeadMap.forEach((esbChannel, clazz) -> {
            Class[] paramsTypes = new Class[]{EsbProperties.class, String.class};
            try {
                AbstractAppHead appHead = (AbstractAppHead)clazz.getDeclaredConstructor(paramsTypes).newInstance(this.esbProperties, esbChannel);
                this.appHeads.add(appHead);
                this.appHeadsMap.put((String)esbChannel, appHead);
            }
            catch (Throwable e) {
                this.log.error("appHead regist failed," + clazz.getSimpleName(), e);
            }
        });
    }

    @Bean
    public IEsbAppHead appHead() {
        return new RegisterAppHead(this.getAllAppHeads());
    }
}

