/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.esb;

import cn.com.yusys.yusp.esb.ResultMsg;
import cn.com.yusys.yusp.esb.config.EsbProperties;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    @Autowired
    private EsbProperties esbProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultMsg doPost(String executeUrl, Map<String, String> heads, String sendData) {
        int CONNCT_TIMEOUT = this.esbProperties.getConnctTimeout();
        int SOCKET_TIMEOUT = this.esbProperties.getSocketTimeout();
        sendData = Optional.ofNullable(sendData).orElse("");
        heads = Optional.ofNullable(heads).orElse(Collections.emptyMap());
        log.info("HTTP\u8bf7\u6c42\u5730\u5740:{}", (Object)executeUrl);
        log.info("HTTP\u8bf7\u6c42\u62a5\u6587: \n {}", (Object)sendData);
        byte[] data = sendData.getBytes();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNCT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(config).build();
        ResultMsg resp = new ResultMsg();
        CloseableHttpResponse response = null;
        URI uri = URI.create(executeUrl);
        HttpPost post = new HttpPost(uri);
        ByteArrayEntity reqEntity = new ByteArrayEntity(data);
        post.setEntity((HttpEntity)reqEntity);
        if (null != heads) {
            Set<Map.Entry<String, String>> set = heads.entrySet();
            for (Map.Entry<String, String> entry : set) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        HttpEntity entity = null;
        boolean flag = false;
        try {
            response = client.execute((HttpUriRequest)post);
            int code = response.getStatusLine().getStatusCode();
            if (200 == code) {
                flag = true;
            }
            Header[] headers = response.getAllHeaders();
            entity = response.getEntity();
            byte[] respData = null;
            if (null != entity) {
                respData = EntityUtils.toByteArray((HttpEntity)entity);
            }
            resp = new ResultMsg(flag, code, new String(respData, "UTF-8"), respData, headers);
            this.releaseResources(entity, response, client);
        }
        catch (Exception e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error("post\u8bf7\u6c42\u5931\u8d25\uff01\uff01\u5f02\u5e38\u4fe1\u606f [ " + e + " ]");
                }
                resp = new ResultMsg(false, 500, e.getMessage(), null, null);
                this.releaseResources(entity, response, client);
            }
            catch (Throwable throwable) {
                this.releaseResources(entity, response, client);
                throw throwable;
            }
        }
        return resp;
    }

    private void releaseResources(HttpEntity entity, CloseableHttpResponse response, CloseableHttpClient client) {
        if (null != entity) {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException var7) {
                log.error("entity\u91ca\u653e\u8d44\u6e90\u5931\u8d25", (Throwable)var7);
            }
        }
        if (null != response) {
            try {
                response.close();
            }
            catch (IOException var6) {
                log.error("response\u91ca\u653e\u8d44\u6e90\u5931\u8d25", (Throwable)var6);
            }
        }
        if (null != client) {
            try {
                client.close();
            }
            catch (IOException var5) {
                log.error("client\u91ca\u653e\u8d44\u6e90\u5931\u8d25", (Throwable)var5);
            }
        }
    }

    HttpUtil(EsbProperties esbProperties) {
        this.esbProperties = esbProperties;
    }

    public static HttpUtilBuilder builder() {
        return new HttpUtilBuilder();
    }

    public static class HttpUtilBuilder {
        private EsbProperties esbProperties;

        HttpUtilBuilder() {
        }

        public HttpUtilBuilder esbProperties(EsbProperties esbProperties) {
            this.esbProperties = esbProperties;
            return this;
        }

        public HttpUtil build() {
            return new HttpUtil(this.esbProperties);
        }

        public String toString() {
            return "HttpUtil.HttpUtilBuilder(esbProperties=" + this.esbProperties + ")";
        }
    }
}

