/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.esb;

import cn.com.yusys.yusp.commons.mybatisplus.util.MybatisPlusUtils;
import cn.com.yusys.yusp.commons.util.IdUtils;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.esb.EsbConfig;
import cn.com.yusys.yusp.esb.HttpUtil;
import cn.com.yusys.yusp.esb.IEsbAppHead;
import cn.com.yusys.yusp.esb.config.EsbProperties;
import cn.com.yusys.yusp.esb.dao.EsbSenderDAO;
import cn.com.yusys.yusp.esb.dao.EsbSenderDO;
import cn.com.yusys.yusp.esb.entity.EsbRequest;
import cn.com.yusys.yusp.esb.entity.EsbResponse;
import cn.com.yusys.yusp.esb.head.pub.EsbReqHeader;
import cn.com.yusys.yusp.esb.head.pub.EsbRespHeader;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class EsbSender<T> {
    private static final Logger log = LoggerFactory.getLogger(EsbSender.class);
    @Autowired
    @Lazy
    private IEsbAppHead appHead;
    @Autowired
    private EsbProperties esbProperties;
    @Autowired
    private HttpUtil httpUtil;
    @Autowired
    private EsbSenderDAO esbSenderDAO;

    public <H, B> EsbResponse exchange(EsbRequest request) {
        Map<String, String> httpHead = this.packHttpHead(request);
        EsbReqHeader esbHead = EsbReqHeader.builder().esbProperties(this.esbProperties).build().init(request);
        request.setHead(esbHead);
        IEsbAppHead ahead = this.appHead.packAppHead(request);
        request.setAppHead(ahead);
        String executeUrl = String.format("http://%s:%s/", this.esbProperties.getEsbAddress(), this.esbProperties.getEsbPort());
        log.info("HTTP\u8bf7\u6c42\u62a5\u6587: \n {}", (Object)request.toJson());
        String appCode = esbHead.getSvcCd() + esbHead.getSvcScn();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("servicecode", esbHead.getSvcCd());
        param.put("servicescene", esbHead.getSvcScn());
        List list = this.esbSenderDAO.selectList(MybatisPlusUtils.lambdaQuery(param));
        if (!list.isEmpty()) {
            String jsonResp = ((EsbSenderDO)list.get(0)).getData();
            Map mapResp = (Map)JSON.parseObject((String)jsonResp, Map.class);
            try {
                log.info("HTTP\u8bf7\u6c42\u8fd4\u56de\uff1a{}", (Object)ObjectMapperUtils.instance().writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapResp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String jsonHead = ObjectMapperUtils.toJson(mapResp.get("Head"));
            EsbRespHeader esbRespHead = (EsbRespHeader)JSON.parseObject((String)jsonHead, EsbRespHeader.class);
            String jsonAppHead = ObjectMapperUtils.toJson(mapResp.get("AppHead"));
            String jsonBody = ObjectMapperUtils.toJson(mapResp.get("Body"));
            try {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(EsbSenderDO::getServicecode, (Object)esbHead.getSvcCd());
                wrapper.eq(EsbSenderDO::getServicescene, (Object)esbHead.getSvcScn());
                long ret = this.esbSenderDAO.selectCount((Wrapper)wrapper);
                if (ret == 0L) {
                    EsbSenderDO esbSenderDO = new EsbSenderDO();
                    esbSenderDO.setId(IdUtils.getNumberId());
                    esbSenderDO.setServicecode(esbHead.getSvcCd());
                    esbSenderDO.setServicescene(esbHead.getSvcScn());
                    esbSenderDO.setRetcode(esbRespHead.getRetCd());
                    esbSenderDO.setRetmsg(esbRespHead.getRetMsg());
                    esbSenderDO.setConsumerseqno(esbRespHead.getCnsmrSeqNo());
                    esbSenderDO.setGlobalseqno(esbRespHead.getGlblSeqNo());
                    esbSenderDO.setData(jsonResp);
                    this.esbSenderDAO.insert(esbSenderDO);
                }
            }
            catch (Exception wrapper) {
                // empty catch block
            }
            Class<?> clazz = request.getBody().getClass();
            EsbConfig esbConfig = clazz.getAnnotation(EsbConfig.class);
            Class respAppHead = esbConfig.appHead();
            Class respBody = esbConfig.respBody();
            Object ah = ObjectMapperUtils.toObject((String)jsonAppHead, (Class)respAppHead);
            Object b = ObjectMapperUtils.toObject((String)jsonBody, (Class)respBody);
            return EsbResponse.builder().Head(esbRespHead).AppHead(ah).Body(b).build();
        }
        return EsbResponse.builder().build().error("\u6a21\u62df\u62a5\u6587\u4e0d\u5b58\u5728");
    }

    private Map<String, String> packHttpHead(EsbRequest request) {
        HashMap<String, String> heads = new HashMap<String, String>();
        heads.put("Content-Type", "application/json;charset=UTF-8");
        if (request.getHttpHeads() != null) {
            heads.putAll(request.getHttpHeads());
        }
        return heads;
    }
}

