/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.util;

import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidator;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.validation.ConstraintValidatorContext;

public class CheckUtils {
    static DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private CheckUtils() {
    }

    public static Object getCurrentBean(ConstraintValidatorContext context) {
        context.getClass();
        return BeanValidator.getCurrentBean().getCurrentBean();
    }

    public static Object getFieldValue(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            return ReflectionUtils.getPropertyValue((Object)object, (Field)field);
        }
        catch (Exception e) {
            throw new IllegalStateException("getFieldValue error", e);
        }
    }

    public static boolean isNumberType(Object value) {
        if (value instanceof String) {
            String valueT = (String)value;
            return valueT.matches("-?[0-9]+.?[0-9]+");
        }
        return value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof BigDecimal;
    }

    public static String getCurrentDate() {
        return LocalDateTime.now().format(format);
    }

    public static LocalDate getDate(String dateStr) {
        try {
            return LocalDate.parse(dateStr, format);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static LocalDate getLocalDate(Object date) {
        try {
            if (date instanceof String) {
                return LocalDate.parse((String)date, format);
            }
            if (date instanceof LocalDate) {
                return (LocalDate)date;
            }
            throw new IllegalStateException("error param type ,must be(String,LocalDate)");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

