/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.annoation;

import cn.com.yusys.yusp.commons.validation.util.CheckUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Checker.class})
@Documented
public @interface IsNumber {
    public String message() default "{cn.com.yusys.yusp.commons.validation.annoation.IsNumber.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public int precision() default 2;

    public boolean mustPositive() default true;

    public static class Checker
    implements ConstraintValidator<IsNumber, Object> {
        int precision = 0;
        boolean mustPositive = true;

        public void initialize(IsNumber ann) {
            this.precision = ann.precision();
            this.mustPositive = ann.mustPositive();
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (null == value) {
                return true;
            }
            if (!CheckUtils.isNumberType(value)) {
                return false;
            }
            String valueStr = value.toString();
            if (this.mustPositive && valueStr.startsWith("-")) {
                return false;
            }
            int currentPrecision = 0;
            if (valueStr.contains(".")) {
                currentPrecision = valueStr.substring(valueStr.lastIndexOf(46) + 1).length();
            }
            return currentPrecision <= this.precision;
        }
    }
}

