/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.annoation;

import cn.com.yusys.yusp.commons.validation.util.CheckUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Checker.class})
@Documented
public @interface DateCompare {
    public String message() default "{cn.com.yusys.yusp.commons.validation.annoation.DateCompare.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String ltField() default "";

    public String leField() default "";

    public ChronoUnit unit();

    public int interval();

    public static class Checker
    implements ConstraintValidator<DateCompare, String> {
        String ltField = null;
        String leField = null;
        ChronoUnit unit = null;
        int interval = 0;

        public void initialize(DateCompare ann) {
            this.ltField = ann.ltField();
            this.leField = ann.leField();
            this.unit = ann.unit();
            this.interval = ann.interval();
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (null == value) {
                return true;
            }
            Object currentBean = CheckUtils.getCurrentBean(context);
            LocalDate currentDate = CheckUtils.getDate(value);
            LocalDate currentDateT = currentDate.plus(this.interval, this.unit);
            ArrayList<Boolean> result = new ArrayList<Boolean>();
            if (null != this.ltField && !"".equals(this.ltField)) {
                Object ltFieldValue = CheckUtils.getFieldValue(this.ltField, currentBean);
                if (null == ltFieldValue) {
                    result.add(true);
                } else {
                    LocalDate ltFieldDate = CheckUtils.getLocalDate(ltFieldValue);
                    result.add(currentDateT.compareTo(ltFieldDate) < 0);
                }
            }
            if (null != this.leField && !"".equals(this.leField)) {
                Object leFieldValue = CheckUtils.getFieldValue(this.leField, currentBean);
                if (null == leFieldValue) {
                    result.add(true);
                } else {
                    LocalDate leFieldDate = CheckUtils.getLocalDate(leFieldValue);
                    result.add(currentDateT.compareTo(leFieldDate) <= 0);
                }
            }
            return !result.contains(false);
        }
    }
}

