/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.cglib;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.i18n.MessageUtils;
import cn.com.yusys.yusp.commons.validation.V;
import cn.com.yusys.yusp.commons.validation.ValidateException;
import cn.com.yusys.yusp.commons.validation.ValueInfo;
import cn.com.yusys.yusp.commons.validation.cglib.BeanMemberValidatorSupport;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorCodeGenerator;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorCodeGeneratorArgs;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorDescription;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorFieldType;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorStaticGenerator;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorSupport;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanValidator {
    static final Logger logger = LoggerFactory.getLogger(BeanValidator.class);
    static final BeanValidatorKey KEY_FACTORY = (BeanValidatorKey)KeyFactory.create(BeanValidatorKey.class);
    static final org.objectweb.asm.Type BEAN_VALIDATOR = TypeUtils.parseType((String)BeanValidator.class.getName());
    static final Signature METHOD_CREATE = new Signature("create", BEAN_VALIDATOR, new org.objectweb.asm.Type[]{Constants.TYPE_CLASS});
    static final Signature METHOD_CREATE_GENERIC = new Signature("create", BEAN_VALIDATOR, new org.objectweb.asm.Type[]{Constants.TYPE_CLASS, Constants.TYPE_STRING_ARRAY});
    private static final org.objectweb.asm.Type EXCEPTION_ARGUMENT = TypeUtils.parseType((String)IllegalArgumentException.class.getName());
    private static final String METHOD_VALIDATOR_SUFFIX = "$Validate";
    static final org.objectweb.asm.Type TYPE_DESC = TypeUtils.parseType((String)BeanValidatorDescription.class.getName());
    private static final Signature METHOD_SET_FIELDINDEX = new Signature("setIndex", org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{org.objectweb.asm.Type.INT_TYPE});
    private static final Signature METHOD_GET_FIELDPREFIX = new Signature("getPreFix", Constants.TYPE_STRING, new org.objectweb.asm.Type[0]);
    private static final Signature METHOD_SET_FIELDNAME = new Signature("setFieldName", org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{Constants.TYPE_STRING});
    private static final org.objectweb.asm.Type TYPE_SET = TypeUtils.parseType((String)Set.class.getName());
    private static final org.objectweb.asm.Type INTERFACE_COLLECTION = TypeUtils.parseType((String)Collection.class.getName());
    private static final org.objectweb.asm.Type INTERFACE_ITERATOR = TypeUtils.parseType((String)Iterator.class.getName());
    private static final Signature METHOD_ITERATOR = new Signature("iterator", INTERFACE_ITERATOR, new org.objectweb.asm.Type[0]);
    private static final Signature METHOD_HASNEXT = new Signature("hasNext", org.objectweb.asm.Type.BOOLEAN_TYPE, new org.objectweb.asm.Type[0]);
    private static final Signature METHOD_NEXT = new Signature("next", Constants.TYPE_OBJECT, new org.objectweb.asm.Type[0]);
    private static final Signature METHOD_CONTAINS = new Signature("contains", org.objectweb.asm.Type.BOOLEAN_TYPE, new org.objectweb.asm.Type[]{Constants.TYPE_OBJECT});
    private static final Signature METHOD_ADD = new Signature("add", org.objectweb.asm.Type.BOOLEAN_TYPE, new org.objectweb.asm.Type[]{Constants.TYPE_OBJECT});
    private static final Signature METHOD_VALIDATOR_ABSTRACT = new Signature("validate", org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{Constants.TYPE_OBJECT, TYPE_DESC, TYPE_SET, Constants.TYPE_CLASS_ARRAY});
    private static final Signature METHOD_VALIDATOR_PREFIX = new Signature("validate", org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, TYPE_SET, Constants.TYPE_CLASS_ARRAY});
    private static final Signature METHOD_VALIDATE_JSR303 = new Signature("validateJsr303", org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{Constants.TYPE_CLASS, Constants.TYPE_OBJECT, Constants.TYPE_OBJECT, TYPE_DESC, Constants.TYPE_CLASS_ARRAY});
    private static final Map<String, String> ERROR_CODES = new HashMap<String, String>();
    private static final String SUPER_VALIDATOR_NAME = "superValidator";
    private static final HashMap<Class<?>, Object> CACHE;
    protected static final ConcurrentHashMap<Object, GenericInfo> GENERIC_CACHE;
    private static Validator jsr303Validator;
    private static final ThreadLocal<ValueInfo> CURRENT_BEAN_STACK;

    public static ValueInfo getCurrentBean() {
        return CURRENT_BEAN_STACK.get();
    }

    public static void init(Validator validator) {
        if (null == jsr303Validator) {
            jsr303Validator = validator;
        }
    }

    public static BeanValidator create(Class<?> target) {
        return BeanValidator.create(target, new String[0]);
    }

    public static BeanValidator create(Class<?> target, String[] genericKey) {
        Generator gen = new Generator();
        gen.setTarget(target);
        gen.setGenericKey(genericKey);
        return gen.create();
    }

    public void validate(Object validateObj, Class<?> ... groups) {
        this.validate(validateObj, "", new HashSet(), groups);
    }

    public void validate(Object validateObj, String preFix, Set<?> ignoreFields, Class<?> ... groups) {
        BeanValidatorDescription desc = new BeanValidatorDescription();
        desc.setPreFix(preFix);
        this.validate(validateObj, desc, ignoreFields, groups);
    }

    protected abstract void validate(Object var1, BeanValidatorDescription var2, Set<?> var3, Class<?> ... var4);

    protected <T> void validateJsr303(Class<T> beanType, Object beanValue, Object propertyValue, BeanValidatorDescription desc, Class<?> ... groups) {
        ValueInfo info = new ValueInfo();
        info.setCurrentBean(beanValue);
        info.setCurrentFieldName(desc.getFieldName());
        CURRENT_BEAN_STACK.set(info);
        try {
            Set results = jsr303Validator.validateValue(beanType, desc.getFieldName(), propertyValue, (Class[])groups);
            if (!results.isEmpty()) {
                ConstraintViolation result = (ConstraintViolation)results.iterator().next();
                String annotationInfo = result.getMessageTemplate();
                String key = annotationInfo.replace("{", "").replace("}", "");
                String code = ERROR_CODES.get(key);
                String message = null;
                if (null != code) {
                    message = MessageUtils.getMessage((String)code, (Object[])new Object[0]);
                } else {
                    code = key;
                    message = MessageUtils.getMessage((String)result.getMessage(), (Object[])new Object[0]);
                }
                StringBuilder relMessage = new StringBuilder();
                relMessage.append("[");
                relMessage.append(desc.getFieldPath());
                relMessage.append("]");
                relMessage.append(message);
                throw new BizBaseException(code, relMessage.toString(), new Object[0]);
            }
        }
        catch (ValidationException e) {
            if (e.getCause() instanceof BizException) {
                throw (BizException)e.getCause();
            }
            throw e;
        }
        finally {
            CURRENT_BEAN_STACK.remove();
        }
    }

    public static String[] createGenericInfo(Class<?> targetClazz, Type targetType, GenericInfo derivedInfo) {
        GenericInfo newInfo = BeanValidator.parseGenericInfo(targetClazz, targetType, derivedInfo);
        String[] genericKey = newInfo.genericKey;
        if (genericKey.length > 0) {
            Object key = KEY_FACTORY.newInstance(targetClazz.getName(), genericKey);
            GENERIC_CACHE.put(key, newInfo);
        }
        return genericKey;
    }

    static GenericInfo parseGenericInfo(Class<?> targetClazz, Type targetType, GenericInfo derivedInfo) {
        if (derivedInfo == null) {
            derivedInfo = new GenericInfo();
        }
        GenericInfo newInfo = new GenericInfo();
        if (ParameterizedType.class.isInstance(targetType)) {
            ParameterizedType pType = (ParameterizedType)targetType;
            TypeVariable<Class<?>>[] varTypes = targetClazz.getTypeParameters();
            Type[] actualTypes = pType.getActualTypeArguments();
            String[] arrayKey = new String[varTypes.length * 2];
            for (int i = 0; i < varTypes.length; ++i) {
                int gIndex = i * 2;
                String varName = varTypes[i].getName();
                Type actualType = actualTypes[i];
                if (TypeVariable.class.isInstance(actualType)) {
                    String genericName = ((TypeVariable)actualType).getName();
                    if (derivedInfo.genericMap.containsKey(genericName)) {
                        Type extendGenericType = derivedInfo.genericMap.get(genericName);
                        newInfo.genericMap.put(varName, extendGenericType);
                    } else {
                        newInfo.genericMap.put(varName, (Type)((Object)Object.class));
                    }
                } else {
                    newInfo.genericMap.put(varName, actualType);
                }
                arrayKey[gIndex] = varName;
                arrayKey[gIndex + 1] = newInfo.genericMap.get(varName).toString();
            }
            newInfo.genericKey = arrayKey;
        }
        return newInfo;
    }

    static {
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.Compare.message", "CK0001");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.CustomCheck.message", "CK0002");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.InDict.message", "CK0003");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.DateCompare.message", "CK0004");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.DateRange.message", "CK0005");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.DefaultValue.message", "CK0006");
        ERROR_CODES.put("javax.validation.constraints.Email.message", "CK0007");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.IsMatche.message", "CK0008");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.IsNull.message", "CK0009");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.IsNumber.message", "CK0010");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.NumberRange.message", "CK0011");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.IsEmpty.message", "CK0012");
        ERROR_CODES.put("javax.validation.constraints.NotEmpty.message", "CK0013");
        ERROR_CODES.put("javax.validation.constraints.NotNull.message", "CK0014");
        ERROR_CODES.put("org.hibernate.validator.constraints.Length.message", "CK0015");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.NotNull.message", "CK0014");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.NoSame.message", "CK0016");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.Contains.message", "CK0017");
        ERROR_CODES.put("cn.com.yusys.yusp.commons.validation.annoation.IsMobile.message", "CK0018");
        CACHE = new HashMap(1000);
        GENERIC_CACHE = new ConcurrentHashMap(1000);
        CURRENT_BEAN_STACK = new ThreadLocal();
    }

    static class GenericInfo {
        String[] genericKey = new String[0];
        HashMap<String, Type> genericMap = new HashMap();

        GenericInfo() {
        }
    }

    static class SrcFieldInfo {
        BeanValidatorFieldType srcFieldType = null;
        V[] vAnnotations = null;
        boolean needMemberValid = false;

        SrcFieldInfo() {
        }
    }

    public static class Generator
    extends AbstractClassGenerator<BeanValidator> {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanValidator.class.getName());
        private static final V[] EMPTY_VS = new V[0];
        private Class<?> target;
        private String[] genericKey = new String[0];
        private GenericInfo genericInfo = new GenericInfo();
        private Object key;

        protected Generator() {
            super(SOURCE);
            super.setNamePrefix(BeanValidator.class.getPackage().getName());
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public void setTarget(Class<?> target) {
            if (!Modifier.isPublic(target.getModifiers())) {
                this.setNamePrefix(target.getName());
            }
            this.target = target;
        }

        public void setGenericKey(String[] genericKey) {
            this.genericKey = genericKey;
        }

        public BeanValidator create() {
            this.key = KEY_FACTORY.newInstance(this.target.getName(), this.genericKey);
            return (BeanValidator)super.create(this.key);
        }

        public void generateClass(ClassVisitor v) throws Exception {
            if (logger.isDebugEnabled()) {
                logger.debug("generate bean validator for {}", (Object)this.target.getName());
            }
            this.generateClassInternal(v);
        }

        private void generateClassInternal(ClassVisitor v) throws NoSuchFieldException {
            BeanDescriptor beanDescriptor = jsr303Validator.getConstraintsForClass(this.target);
            if (this.genericKey != null && this.genericKey.length > 0) {
                this.genericInfo = GENERIC_CACHE.get(this.key);
            }
            org.objectweb.asm.Type valueType = org.objectweb.asm.Type.getType(this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(52, 1, this.getClassName(), BEAN_VALIDATOR, null, "<generated>");
            EmitUtils.null_constructor((ClassEmitter)ce);
            PropertyDescriptor[] getters = ReflectUtils.getBeanGetters(this.target);
            CodeEmitter ceStatic = ce.begin_static();
            CodeEmitter ceValidate = ce.begin_method(1, METHOD_VALIDATOR_ABSTRACT, null);
            Local valueLocal = ceValidate.make_local(valueType);
            Label notNull = ceValidate.make_label();
            ceValidate.load_arg(0);
            ceValidate.ifnonnull(notNull);
            ceValidate.throw_exception(EXCEPTION_ARGUMENT, "The validateObj is null.");
            ceValidate.mark(notNull);
            ceValidate.load_arg(0);
            ceValidate.checkcast(valueType);
            ceValidate.store_local(valueLocal);
            for (PropertyDescriptor srcGetter : getters) {
                Method srcReadMethod = srcGetter.getReadMethod();
                String srcFieldName = srcGetter.getName();
                MethodInfo srcRead = ReflectUtils.getMethodInfo((Member)srcReadMethod);
                if (!srcReadMethod.getDeclaringClass().equals(this.target) || !this.needJsr303Validate(beanDescriptor, srcFieldName, srcReadMethod)) continue;
                SrcFieldInfo fi = this.parseSrcFieldInfo(srcFieldName, srcReadMethod);
                Label fieldEndLabel = ceValidate.make_label();
                ceValidate.load_arg(2);
                ceValidate.push(srcFieldName);
                ceValidate.invoke_interface(TYPE_SET, METHOD_CONTAINS);
                ceValidate.if_jump(154, fieldEndLabel);
                ceValidate.load_arg(2);
                ceValidate.push(srcFieldName);
                ceValidate.invoke_interface(TYPE_SET, METHOD_ADD);
                ceValidate.pop();
                ceValidate.load_arg(1);
                ceValidate.push(srcFieldName);
                ceValidate.invoke_virtual(TYPE_DESC, METHOD_SET_FIELDNAME);
                org.objectweb.asm.Type srcFieldAsmType = org.objectweb.asm.Type.getType(fi.srcFieldType.getFieldClazz());
                Signature srcFieldValidateSignature = new Signature(srcFieldName + BeanValidator.METHOD_VALIDATOR_SUFFIX, org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{valueType, srcFieldAsmType, TYPE_DESC, Constants.TYPE_CLASS_ARRAY});
                CodeEmitter ceValidateSrc = ce.begin_method(2, srcFieldValidateSignature, null);
                Label targetFaildLabel = ceValidateSrc.make_label();
                for (V annotation : fi.vAnnotations) {
                    this.generateTargetValidator(srcFieldName, valueType, ce, getters, ceStatic, ceValidateSrc, targetFaildLabel, annotation);
                }
                ceValidateSrc.load_this();
                ceValidateSrc.visitLdcInsn((Object)valueType);
                ceValidateSrc.load_arg(0);
                ceValidateSrc.load_arg(1);
                if (fi.srcFieldType.getFieldClazz().isPrimitive()) {
                    ceValidateSrc.box(srcFieldAsmType);
                }
                ceValidateSrc.load_arg(2);
                ceValidateSrc.load_arg(3);
                ceValidateSrc.invoke_virtual_this(METHOD_VALIDATE_JSR303);
                if (fi.needMemberValid) {
                    this.generateMemberValidator(ceStatic, srcFieldName, fi, ceValidateSrc);
                }
                ceValidateSrc.mark(targetFaildLabel);
                ceValidateSrc.return_value();
                ceValidateSrc.end_method();
                ceValidate.load_this();
                ceValidate.load_local(valueLocal);
                ceValidate.dup();
                ceValidate.invoke(srcRead);
                if (!fi.srcFieldType.getFieldClazz().isPrimitive()) {
                    ceValidate.checkcast(srcFieldAsmType);
                }
                ceValidate.load_arg(1);
                ceValidate.load_arg(3);
                ceValidate.invoke(ceValidateSrc.getMethodInfo());
                ceValidate.mark(fieldEndLabel);
            }
            this.generateSuperclassValidator(ceStatic, ceValidate);
            ceStatic.end_method();
            ceValidate.return_value();
            ceValidate.end_method();
            ce.end_class();
        }

        private void generateMemberValidator(CodeEmitter ceStatic, String srcFieldName, SrcFieldInfo fi, CodeEmitter ceValidateSrc) {
            if (fi.srcFieldType.isCollection() && BeanMemberValidatorSupport.apply(fi.srcFieldType.getItemClazz())) {
                BeanMemberValidatorSupport.generatorStatic(ceStatic, fi.srcFieldType, srcFieldName);
                org.objectweb.asm.Type itemAsmType = org.objectweb.asm.Type.getType(fi.srcFieldType.getItemClazz());
                Label labelHasNext = ceValidateSrc.make_label();
                Label labelNext = ceValidateSrc.make_label();
                Local iteratorLocal = ceValidateSrc.make_local(INTERFACE_ITERATOR);
                Local indexLocal = ceValidateSrc.make_local(org.objectweb.asm.Type.INT_TYPE);
                ceValidateSrc.push(0);
                ceValidateSrc.store_local(indexLocal);
                ceValidateSrc.load_arg(1);
                ceValidateSrc.checkcast(INTERFACE_COLLECTION);
                ceValidateSrc.invoke_interface(INTERFACE_COLLECTION, METHOD_ITERATOR);
                ceValidateSrc.store_local(iteratorLocal);
                ceValidateSrc.goTo(labelHasNext);
                ceValidateSrc.mark(labelNext);
                ceValidateSrc.load_arg(2);
                ceValidateSrc.load_local(indexLocal);
                ceValidateSrc.invoke_virtual(TYPE_DESC, METHOD_SET_FIELDINDEX);
                ceValidateSrc.iinc(indexLocal, 1);
                BeanMemberValidatorSupport.generator(ceValidateSrc, srcFieldName, emitter -> {
                    emitter.load_local(iteratorLocal);
                    emitter.invoke_interface(INTERFACE_ITERATOR, METHOD_NEXT);
                    emitter.checkcast(itemAsmType);
                });
                ceValidateSrc.mark(labelHasNext);
                ceValidateSrc.load_local(iteratorLocal);
                ceValidateSrc.invoke_interface(INTERFACE_ITERATOR, METHOD_HASNEXT);
                ceValidateSrc.if_jump(154, labelNext);
            } else if (BeanMemberValidatorSupport.apply(fi.srcFieldType.getFieldClazz())) {
                BeanMemberValidatorSupport.generatorStatic(ceStatic, fi.srcFieldType, srcFieldName);
                BeanMemberValidatorSupport.generator(ceValidateSrc, srcFieldName, emitter -> emitter.load_arg(1));
            }
        }

        private void generateTargetValidator(String srcFieldName, org.objectweb.asm.Type valueType, ClassEmitter ce, PropertyDescriptor[] getters, CodeEmitter ceStatic, CodeEmitter ceValidateSrc, Label targetFaildLabel, V annotation) throws NoSuchFieldException {
            String staticNamePre;
            String annoHash = Integer.toString(annotation.hashCode());
            String targetFieldName = annotation.field();
            Field targetField = this.target.getDeclaredField(targetFieldName);
            BeanValidatorFieldType targetFieldType = this.parseFieldType(targetField, this.genericInfo);
            ArrayList<BeanValidatorCodeGenerator> applyList = this.generateApplyPrepare(ceStatic, annotation, targetFieldType, staticNamePre = targetFieldName + "$" + annoHash);
            if (!applyList.isEmpty()) {
                PropertyDescriptor targetGetter = this.findGetter(getters, targetFieldName);
                if (!targetField.getType().equals(targetGetter.getReadMethod().getReturnType())) {
                    throw new IllegalStateException("The type of field[" + targetFieldName + "] and getter method is not match");
                }
                org.objectweb.asm.Type targetFieldAsmType = org.objectweb.asm.Type.getType(targetFieldType.getFieldClazz());
                Signature targetFieldValidateSignature = new Signature(srcFieldName + BeanValidator.METHOD_VALIDATOR_SUFFIX + "$" + targetFieldName + annoHash, org.objectweb.asm.Type.BOOLEAN_TYPE, new org.objectweb.asm.Type[]{valueType, targetFieldAsmType});
                CodeEmitter ceValidateTarget = ce.begin_method(2, targetFieldValidateSignature, null);
                Label falseLabel = ceValidateTarget.make_label();
                Label endLabel = ceValidateTarget.make_label();
                BeanValidatorCodeGeneratorArgs args = new BeanValidatorCodeGeneratorArgs();
                args.codeEmitter = ceValidateTarget;
                args.valueClazz = targetFieldType.getFieldClazz();
                args.annotation = annotation;
                args.fieldName = targetFieldName;
                args.staticNamePre = staticNamePre;
                for (BeanValidatorCodeGenerator cg : applyList) {
                    cg.generator(args);
                    ceValidateTarget.if_jump(153, falseLabel);
                }
                ceValidateTarget.push(true);
                ceValidateTarget.goTo(endLabel);
                ceValidateTarget.mark(falseLabel);
                ceValidateTarget.push(false);
                ceValidateTarget.mark(endLabel);
                ceValidateTarget.return_value();
                ceValidateTarget.end_method();
                ceValidateSrc.load_this();
                ceValidateSrc.load_arg(0);
                ceValidateSrc.dup();
                ceValidateSrc.invoke(ReflectUtils.getMethodInfo((Member)targetGetter.getReadMethod()));
                if (!targetFieldType.getFieldClazz().isPrimitive()) {
                    ceValidateSrc.checkcast(targetFieldAsmType);
                }
                ceValidateSrc.invoke(ceValidateTarget.getMethodInfo());
                ceValidateSrc.if_jump(153, targetFaildLabel);
            }
        }

        private PropertyDescriptor findGetter(PropertyDescriptor[] getters, String targetFieldName) {
            PropertyDescriptor targetGetter = null;
            for (PropertyDescriptor findGetter : getters) {
                if (!findGetter.getName().equals(targetFieldName)) continue;
                targetGetter = findGetter;
                break;
            }
            if (targetGetter == null) {
                throw new ValidateException("\u6ca1\u6709\u627e\u5230getter\u65b9\u6cd5\uff0cfield=" + targetFieldName);
            }
            return targetGetter;
        }

        private ArrayList<BeanValidatorCodeGenerator> generateApplyPrepare(CodeEmitter ceStatic, V annotation, BeanValidatorFieldType targetFieldType, String staticNamePre) {
            ArrayList<BeanValidatorCodeGenerator> applyList = new ArrayList<BeanValidatorCodeGenerator>();
            for (BeanValidatorCodeGenerator cg : BeanValidatorSupport.GENERATOR_LIST) {
                boolean applied = false;
                if (cg.apply(targetFieldType.getFieldClazz(), annotation)) {
                    applied = true;
                    applyList.add(cg);
                }
                if (!applied || !BeanValidatorStaticGenerator.class.isInstance(cg)) continue;
                ((BeanValidatorStaticGenerator)((Object)cg)).generatorStatic(ceStatic, targetFieldType, staticNamePre, annotation);
            }
            return applyList;
        }

        private boolean needJsr303Validate(BeanDescriptor beanDescriptor, String srcFieldName, Method srcReadMethod) {
            boolean needJsr303Validate;
            boolean bl = needJsr303Validate = beanDescriptor.getConstraintsForProperty(srcFieldName) != null;
            if (!needJsr303Validate) {
                needJsr303Validate = beanDescriptor.getConstraintsForMethod(srcReadMethod.getName(), (Class[])srcReadMethod.getParameterTypes()) != null;
            }
            return needJsr303Validate;
        }

        private SrcFieldInfo parseSrcFieldInfo(String srcFieldName, Method srcReadMethod) {
            try {
                return this.tryParseSrcFieldInfo(srcFieldName);
            }
            catch (NoSuchFieldException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("not find field[{}], using annotations of getter method", (Object)srcFieldName, (Object)e);
                }
                SrcFieldInfo info = new SrcFieldInfo();
                info.vAnnotations = this.parseVs(srcReadMethod.getAnnotations());
                info.srcFieldType = this.parseFieldType(srcReadMethod, this.genericInfo);
                info.needMemberValid = srcReadMethod.isAnnotationPresent(Valid.class);
                return info;
            }
        }

        private SrcFieldInfo tryParseSrcFieldInfo(String srcFieldName) throws NoSuchFieldException {
            Field field;
            String fieldName = srcFieldName;
            try {
                field = this.target.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                char firstChar;
                if (logger.isDebugEnabled()) {
                    logger.debug("not find field[{}], try lowerCase", (Object)srcFieldName, (Object)e);
                }
                if ('A' <= (firstChar = fieldName.charAt(0)) && firstChar <= 'Z') {
                    fieldName = String.valueOf(firstChar).toLowerCase() + fieldName.substring(1);
                }
                field = this.target.getDeclaredField(fieldName);
            }
            SrcFieldInfo info = new SrcFieldInfo();
            info.vAnnotations = this.parseVs(field.getAnnotations());
            info.srcFieldType = this.parseFieldType(field, this.genericInfo);
            info.needMemberValid = field.isAnnotationPresent(Valid.class);
            return info;
        }

        private void generateSuperclassValidator(CodeEmitter staticEmitter, CodeEmitter ceValidate) {
            if (!this.target.isMemberClass()) {
                Class<?> superClazz = this.target.getSuperclass();
                if (Object.class.equals(superClazz)) {
                    return;
                }
                Type superType = this.target.getGenericSuperclass();
                Object[] superKey = BeanValidator.createGenericInfo(superClazz, superType, this.genericInfo);
                org.objectweb.asm.Type currentType = staticEmitter.getClassEmitter().getClassType();
                staticEmitter.getClassEmitter().declare_field(26, BeanValidator.SUPER_VALIDATOR_NAME, BEAN_VALIDATOR, null);
                staticEmitter.visitLdcInsn((Object)org.objectweb.asm.Type.getType(superClazz));
                EmitUtils.push_array((CodeEmitter)staticEmitter, (Object[])superKey);
                staticEmitter.invoke_static(BEAN_VALIDATOR, METHOD_CREATE_GENERIC);
                staticEmitter.putstatic(currentType, BeanValidator.SUPER_VALIDATOR_NAME, BEAN_VALIDATOR);
                ceValidate.getstatic(currentType, BeanValidator.SUPER_VALIDATOR_NAME, BEAN_VALIDATOR);
                ceValidate.load_arg(0);
                ceValidate.load_arg(1);
                ceValidate.invoke_virtual(TYPE_DESC, METHOD_GET_FIELDPREFIX);
                ceValidate.load_arg(2);
                ceValidate.load_arg(3);
                ceValidate.invoke_virtual(BEAN_VALIDATOR, METHOD_VALIDATOR_PREFIX);
            }
        }

        private V[] parseVs(Annotation[] annotations) {
            for (Annotation anno : annotations) {
                if (anno instanceof V.Vs) {
                    return ((V.Vs)anno).value();
                }
                if (!(anno instanceof V)) continue;
                return new V[]{(V)anno};
            }
            return EMPTY_VS;
        }

        private BeanValidatorFieldType parseFieldType(Method method, GenericInfo genericInfo) {
            BeanValidatorFieldType fieldType = new BeanValidatorFieldType();
            String fieldDesc = method.getDeclaringClass().getName() + "." + method.getName();
            fieldType.setFieldClazz(method.getReturnType());
            fieldType.setFieldGenericType(method.getGenericReturnType());
            this.updateFieldTypeByGenericInfo(fieldType, genericInfo, fieldDesc);
            GenericInfo fieldGenericInfo = BeanValidator.parseGenericInfo(fieldType.getFieldClazz(), fieldType.getFieldGenericType(), genericInfo);
            this.updateCollectionFieldItemType(fieldType, fieldGenericInfo, fieldDesc);
            return fieldType;
        }

        private BeanValidatorFieldType parseFieldType(Field field, GenericInfo genericInfo) {
            BeanValidatorFieldType fieldType = new BeanValidatorFieldType();
            String fieldDesc = field.getDeclaringClass().getName() + "." + field.getName();
            fieldType.setFieldClazz(field.getType());
            fieldType.setFieldGenericType(field.getGenericType());
            this.updateFieldTypeByGenericInfo(fieldType, genericInfo, fieldDesc);
            GenericInfo fieldGenericInfo = BeanValidator.parseGenericInfo(fieldType.getFieldClazz(), fieldType.getFieldGenericType(), genericInfo);
            this.updateCollectionFieldItemType(fieldType, fieldGenericInfo, fieldDesc);
            return fieldType;
        }

        private void updateFieldTypeByGenericInfo(BeanValidatorFieldType fieldType, GenericInfo genericInfo, String fieldDesc) {
            Object fieldGenericType;
            Class fieldClazz = fieldType.getFieldClazz();
            if (!fieldClazz.equals(fieldGenericType = fieldType.getFieldGenericType())) {
                if (TypeVariable.class.isInstance(fieldGenericType)) {
                    String varName = ((TypeVariable)fieldGenericType).getName();
                    if (genericInfo.genericMap.containsKey(varName)) {
                        fieldGenericType = genericInfo.genericMap.get(varName);
                    } else {
                        if (logger.isWarnEnabled()) {
                            logger.warn("\u65e0\u6cd5\u786e\u8ba4\u6cdb\u578b\u6210\u5458\u53d8\u91cf{}\u7684\u5177\u4f53\u7c7b\u578b\uff0c\u9ed8\u8ba4\u6309Object\u7c7b\u578b\u5904\u7406", (Object)fieldDesc);
                        }
                        fieldGenericType = Object.class;
                    }
                }
                fieldClazz = ParameterizedType.class.isInstance(fieldGenericType) ? (Class)((ParameterizedType)fieldGenericType).getRawType() : (Class)fieldGenericType;
                fieldType.setFieldClazz(fieldClazz);
                fieldType.setFieldGenericType((Type)fieldGenericType);
            }
        }

        private void updateCollectionFieldItemType(BeanValidatorFieldType fieldType, GenericInfo genericInfo, String fieldDesc) {
            Class<?> clazz = fieldType.getFieldClazz();
            if (!Collection.class.isAssignableFrom(clazz)) {
                fieldType.setCollection(false);
                return;
            }
            Type genericType = fieldType.getFieldGenericType();
            GenericInfo targetInfo = genericInfo;
            if (targetInfo == null) {
                targetInfo = new GenericInfo();
            }
            Class<?> superClazz = clazz.getSuperclass();
            while (superClazz != null && Collection.class.isAssignableFrom(superClazz)) {
                genericType = clazz.getGenericSuperclass();
                clazz = superClazz;
                superClazz = clazz.getSuperclass();
                targetInfo = BeanValidator.parseGenericInfo(clazz, genericType, targetInfo);
            }
            block1: while (!Collection.class.equals(clazz)) {
                for (Type interfaceType : clazz.getGenericInterfaces()) {
                    Class<?> interfaceClazz = this.parseInterfaceClass(interfaceType);
                    if (!Collection.class.isAssignableFrom(interfaceClazz)) continue;
                    clazz = interfaceClazz;
                    genericType = interfaceType;
                    targetInfo = BeanValidator.parseGenericInfo(clazz, genericType, targetInfo);
                    continue block1;
                }
            }
            fieldType.setCollection(true);
            if (ParameterizedType.class.isInstance(genericType)) {
                Type actualType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                BeanValidatorFieldType collectionType = new BeanValidatorFieldType();
                collectionType.setFieldClazz(Object.class);
                collectionType.setFieldGenericType(actualType);
                this.updateFieldTypeByGenericInfo(collectionType, targetInfo, fieldDesc);
                fieldType.setItemClazz(collectionType.getFieldClazz());
                fieldType.setItemGenericType(collectionType.getFieldGenericType());
            } else {
                fieldType.setItemClazz(Object.class);
                fieldType.setItemGenericType((Type)((Object)Object.class));
            }
        }

        private Class<?> parseInterfaceClass(Type interfaceType) {
            Class interfaceClazz = null;
            if (ParameterizedType.class.isInstance(interfaceType)) {
                interfaceClazz = (Class)((ParameterizedType)interfaceType).getRawType();
            } else if (Class.class.isInstance(interfaceType)) {
                interfaceClazz = (Class)interfaceType;
            }
            if (interfaceClazz == null) {
                throw new ValidateException("Can not deal with the generic interface:" + interfaceType);
            }
            return interfaceClazz;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object firstInstance(Class type) throws Exception {
            if (CACHE.containsKey(type)) {
                return CACHE.get(type);
            }
            HashMap hashMap = CACHE;
            synchronized (hashMap) {
                if (!CACHE.containsKey(type)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("create validator: {} for {}", (Object)type.getSimpleName(), (Object)this.target.getName());
                    }
                    Object instance = ReflectUtils.newInstance((Class)type);
                    CACHE.put(type, instance);
                }
            }
            return CACHE.get(type);
        }

        protected Object nextInstance(Object instance) throws Exception {
            return instance;
        }
    }

    static interface BeanValidatorKey {
        public Object newInstance(String var1, String[] var2);
    }
}

