/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.annoation;

import cn.com.yusys.yusp.commons.validation.metadata.api.IDict;
import cn.com.yusys.yusp.commons.validation.metadata.api.NullDict;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@Constraint(validatedBy={InDictConstraint.class})
public @interface InDict {
    public Class<? extends IDict> value() default NullDict.class;

    public String message() default "{cn.com.yusys.yusp.commons.validation.annoation.InDict.message}";

    public Class<? extends Payload>[] payload() default {};

    public Class<?>[] groups() default {};

    public static class InDictConstraint
    implements ConstraintValidator<InDict, Object> {
        private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("(?<!_)[A-Z]");
        private static final ConcurrentHashMap<Class<?>, Set<String>> VALUE_SET_MAP = new ConcurrentHashMap();
        private Class<? extends IDict> configDictClass;

        public void initialize(InDict constraintAnnotation) {
            this.configDictClass = constraintAnnotation.value();
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            String fieldName = ValidatorUtils.getCurrentValueInfo().getCurrentFieldName();
            if (this.configDictClass.equals(NullDict.class)) {
                String string = FIELD_NAME_PATTERN.matcher(fieldName).replaceAll("_$0").toUpperCase();
            }
            if (this.configDictClass == null) {
                throw new IllegalStateException(fieldName + "\u5b57\u6bb5\u65e0\u6cd5\u786e\u5b9a\u6570\u636e\u5b57\u5178");
            }
            Set dictValueSet = VALUE_SET_MAP.computeIfAbsent(this.configDictClass, c -> Arrays.stream(this.configDictClass.getEnumConstants()).map(IDict::value).collect(Collectors.toSet()));
            if (value instanceof Collection) {
                return ((Collection)value).stream().filter(Objects::nonNull).map(Objects::toString).allMatch(dictValueSet::contains);
            }
            return dictValueSet.contains(value.toString());
        }
    }
}

