/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.cglib;

import cn.com.yusys.yusp.commons.validation.V;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorCodeGenerator;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorCodeGeneratorArgs;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorFieldType;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorStaticGenerator;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanValidatorSupport {
    private static final Logger logger = LoggerFactory.getLogger(BeanValidatorSupport.class);
    private static final Type BEAN_SUPPORT = TypeUtils.parseType((String)BeanValidatorSupport.class.getName());
    private static final Type TYPE_HASHSET = TypeUtils.parseType((String)Set.class.getName());
    private static final Signature CREATE_SET_METHOD = TypeUtils.parseSignature((String)"java.util.Set createSetFromArray(Object[])");
    private static final HashMap<String, Signature> SIGNATURE_MAPPING = BeanValidatorSupport.createMethodSignatures();
    private static final String CHECK_METHOD_PREFIX = "check";
    static final List<BeanValidatorCodeGenerator> GENERATOR_LIST = BeanValidatorSupport.createCodeGenerators();

    private static List<BeanValidatorCodeGenerator> createCodeGenerators() {
        ArrayList<BeanValidatorCodeGenerator> list = new ArrayList<BeanValidatorCodeGenerator>();
        list.add(new CheckNotNullEmptyGenerator());
        list.add(new CheckDigitGenerator());
        list.add(new CheckIntegerGenerator());
        list.add(new CheckStringSizeGenerator());
        list.add(new CheckStringInGenerator());
        list.add(new CheckStringLengthGenerator());
        list.add(new CheckCustomGenerator());
        return list;
    }

    private static HashMap<String, Signature> createMethodSignatures() {
        Method[] methods = BeanValidatorSupport.class.getDeclaredMethods();
        HashMap<String, Signature> signatureMap = new HashMap<String, Signature>(methods.length);
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !method.getName().startsWith(CHECK_METHOD_PREFIX)) continue;
            Signature signature = ReflectUtils.getSignature((Member)method);
            signatureMap.put(method.getName(), signature);
        }
        return signatureMap;
    }

    public static <T> Set<T> createSetFromArray(T[] values) {
        List<T> list = Arrays.asList(values);
        return new HashSet<T>(list);
    }

    public static boolean checkNotEmptyString(String value) {
        if (value != null && value.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("The String {} length is 0.", (Object)value);
            }
            return false;
        }
        return true;
    }

    public static boolean checkNotEmptyCollection(Collection<?> value) {
        if (value != null && value.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("The Collection value is empty.");
            }
            return false;
        }
        return true;
    }

    public static boolean checkNotNull(Object value) {
        if (value == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate value is null");
            }
            return false;
        }
        return true;
    }

    public static boolean checkDigit(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value) && !StringUtils.isNumeric((CharSequence)value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: not a digit value:{}", (Object)value);
            }
            return false;
        }
        return true;
    }

    public static boolean checkInteger(int min, int max, Integer value) {
        if (value == null) {
            return false;
        }
        return BeanValidatorSupport.checkInt(min, max, value);
    }

    public static boolean checkInt(int min, int max, int value) {
        if (value < min) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate value is:{}, min value is:{}", (Object)value, (Object)min);
            }
            return false;
        }
        if (value > max) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate value is:{}, max value is:{}", (Object)value, (Object)max);
            }
            return false;
        }
        return true;
    }

    public static boolean checkStringSize(int min, int max, String value) {
        int size = 0;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            size = value.length();
        }
        if (min > 0 && max > 0 && (size < min || size > max)) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate size is:{}, minSize value is:{}, maxSize value is:{}", new Object[]{size, min, max});
            }
            return false;
        }
        if (min > 0 && max < 0 && size < min) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate size is:{}, minSize value is:{}", (Object)size, (Object)min);
            }
            return false;
        }
        if (min < 0 && max > 0 && size > max) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate size is:{}, maxSize value is:{}", (Object)size, (Object)max);
            }
            return false;
        }
        return true;
    }

    public static boolean checkStringIn(Set<String> inSet, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value) && !inSet.contains(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: validate value is:{}", (Object)value);
            }
            return false;
        }
        return true;
    }

    public static boolean checkStringLength(Set<Integer> lenSet, String annotationLength, String value) {
        if (value != null && !lenSet.contains(value.length())) {
            if (logger.isDebugEnabled()) {
                logger.debug("@V invalid: The String length is {}, the excepted length is {}.", (Object)value.length(), (Object)annotationLength);
            }
            return false;
        }
        return true;
    }

    private BeanValidatorSupport() {
    }

    static class CheckCustomGenerator
    implements BeanValidatorCodeGenerator {
        CheckCustomGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return !annotation.custom().equals(V.VoidCustom.class);
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            Type customType = Type.getType(args.annotation.custom());
            CodeEmitter ce = args.codeEmitter;
            ce.new_instance(customType);
            ce.dup();
            ce.invoke_constructor(customType);
            ce.push(args.fieldName);
            ce.load_arg(1);
            Signature sigCheck = new Signature("customCheck", Type.BOOLEAN_TYPE, new Type[]{Constants.TYPE_STRING, Constants.TYPE_OBJECT});
            ce.invoke_interface(Type.getType(V.Custom.class), sigCheck);
        }
    }

    static class CheckStringLengthGenerator
    implements BeanValidatorCodeGenerator,
    BeanValidatorStaticGenerator {
        private static final String LENGTH_SUFFIX = "Length";

        CheckStringLengthGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return String.class.equals(fieldClazz) && StringUtils.isNotEmpty((CharSequence)annotation.length());
        }

        @Override
        public void generatorStatic(CodeEmitter staticEmitter, BeanValidatorFieldType fieldType, String staticNamePre, V annotation) {
            String length = annotation.length();
            if (StringUtils.isNotEmpty((CharSequence)length)) {
                String staticName = staticNamePre + LENGTH_SUFFIX;
                staticEmitter.getClassEmitter().declare_field(26, staticName, TYPE_HASHSET, null);
                String[] lengthValues = length.split(",");
                Signature constructor = TypeUtils.parseConstructor((String)"int");
                staticEmitter.push(lengthValues.length);
                staticEmitter.newarray(Constants.TYPE_INTEGER);
                for (int i = 0; i < lengthValues.length; ++i) {
                    staticEmitter.dup();
                    staticEmitter.push(i);
                    staticEmitter.new_instance(Constants.TYPE_INTEGER);
                    staticEmitter.dup();
                    staticEmitter.push(Integer.parseInt(lengthValues[i]));
                    staticEmitter.invoke_constructor(Constants.TYPE_INTEGER, constructor);
                    staticEmitter.aastore();
                }
                staticEmitter.invoke_static(BEAN_SUPPORT, CREATE_SET_METHOD);
                staticEmitter.putstatic(staticEmitter.getClassEmitter().getClassType(), staticName, TYPE_HASHSET);
            }
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            CodeEmitter ce = args.codeEmitter;
            ce.getstatic(ce.getClassEmitter().getClassType(), args.staticNamePre + LENGTH_SUFFIX, TYPE_HASHSET);
            ce.push(args.annotation.length());
            ce.load_arg(1);
            ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkStringLength"));
        }
    }

    static class CheckStringInGenerator
    implements BeanValidatorCodeGenerator,
    BeanValidatorStaticGenerator {
        private static final String IN_SUFFIX = "In";

        CheckStringInGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return String.class.equals(fieldClazz) && StringUtils.isNotEmpty((CharSequence)annotation.in());
        }

        @Override
        public void generatorStatic(CodeEmitter staticEmitter, BeanValidatorFieldType fieldType, String staticNamePre, V annotation) {
            String in = annotation.in();
            if (StringUtils.isNotEmpty((CharSequence)in)) {
                String staticName = staticNamePre + IN_SUFFIX;
                staticEmitter.getClassEmitter().declare_field(26, staticName, TYPE_HASHSET, null);
                Object[] validateValues = in.split(",");
                EmitUtils.push_array((CodeEmitter)staticEmitter, (Object[])validateValues);
                staticEmitter.invoke_static(BEAN_SUPPORT, CREATE_SET_METHOD);
                staticEmitter.putstatic(staticEmitter.getClassEmitter().getClassType(), staticName, TYPE_HASHSET);
            }
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            CodeEmitter ce = args.codeEmitter;
            ce.getstatic(ce.getClassEmitter().getClassType(), args.staticNamePre + IN_SUFFIX, TYPE_HASHSET);
            ce.load_arg(1);
            ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkStringIn"));
        }
    }

    static class CheckStringSizeGenerator
    implements BeanValidatorCodeGenerator {
        CheckStringSizeGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return String.class.equals(fieldClazz) && (annotation.minSize() > 0 || annotation.maxSize() > 0);
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            CodeEmitter ce = args.codeEmitter;
            ce.push(args.annotation.minSize());
            ce.push(args.annotation.maxSize());
            ce.load_arg(1);
            ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkStringSize"));
        }
    }

    static class CheckIntegerGenerator
    implements BeanValidatorCodeGenerator {
        CheckIntegerGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return Integer.class.equals(fieldClazz) || Integer.TYPE.equals(fieldClazz);
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            CodeEmitter ce = args.codeEmitter;
            ce.push(args.annotation.min());
            ce.push(args.annotation.max());
            ce.load_arg(1);
            if (Integer.class.equals(args.valueClazz)) {
                ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkInteger"));
            } else {
                ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkInt"));
            }
        }
    }

    static class CheckDigitGenerator
    implements BeanValidatorCodeGenerator {
        CheckDigitGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return annotation.digit() && String.class.equals(fieldClazz);
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            CodeEmitter ce = args.codeEmitter;
            ce.load_arg(1);
            ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkDigit"));
        }
    }

    static class CheckNotNullEmptyGenerator
    implements BeanValidatorCodeGenerator {
        CheckNotNullEmptyGenerator() {
        }

        @Override
        public boolean apply(Class<?> fieldClazz, V annotation) {
            return annotation.notNull() && !fieldClazz.isPrimitive();
        }

        @Override
        public void generator(BeanValidatorCodeGeneratorArgs args) {
            CodeEmitter ce = args.codeEmitter;
            Class<?> valueClazz = args.valueClazz;
            Label checkNotEmpty = ce.make_label();
            Label endLabel = ce.make_label();
            ce.load_arg(1);
            ce.ifnonnull(checkNotEmpty);
            ce.load_arg(1);
            ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkNotNull"));
            ce.goTo(endLabel);
            ce.mark(checkNotEmpty);
            if (args.annotation.notEmpty()) {
                if (valueClazz.equals(String.class)) {
                    ce.load_arg(1);
                    ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkNotEmptyString"));
                } else if (Collection.class.isAssignableFrom(valueClazz)) {
                    ce.load_arg(1);
                    ce.invoke_static(BEAN_SUPPORT, (Signature)SIGNATURE_MAPPING.get("checkNotEmptyCollection"));
                } else {
                    ce.push(true);
                }
            } else {
                ce.push(true);
            }
            ce.mark(endLabel);
        }
    }
}

