/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.interceptor;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetHandlerInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object proceed = invocation.proceed();
        if (proceed instanceof List) {
            List list = (List)proceed;
            for (Object object : list) {
                if (!(object instanceof Map)) break;
                this.convertMapKey((Map)object);
            }
            return list;
        }
        if (proceed instanceof Map) {
            this.convertMapKey((Map)proceed);
        }
        return proceed;
    }

    private void convertMapKey(Map<String, Object> map) {
        HashSet<String> keySet = new HashSet<String>(map.keySet());
        for (String key : keySet) {
            if (!key.contains("_")) continue;
            Object value = map.get(key);
            map.remove(key);
            map.put(StringUtils.camelCase((CharSequence)key.toLowerCase()), value);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

